/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.nodes.AssignmentInstruction;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.BlockAssignment;
import freemarker.core.nodes.generated.BreakInstruction;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.EscapeBlock;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.ImportDeclaration;
import freemarker.core.nodes.generated.Interpolation;
import freemarker.core.nodes.generated.IteratorBlock;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.NoEscapeBlock;
import freemarker.core.nodes.generated.PropertySetting;
import freemarker.core.nodes.generated.ReturnInstruction;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.nodes.generated.SwitchBlock;
import freemarker.core.nodes.generated.TemplateHeaderElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.nodes.generated.VarDirective;
import freemarker.core.parser.Node;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblemImpl;
import freemarker.core.parser.Token;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class PostParseVisitor
extends Node.Visitor {
    private Template template;
    private List<EscapeBlock> escapes = new ArrayList<EscapeBlock>();

    PostParseVisitor(Template template) {
        this.template = template;
    }

    private Expression escapedExpression(Expression exp) {
        if (this.escapes.isEmpty()) {
            return exp;
        }
        EscapeBlock lastEscape = this.escapes.get(this.escapes.size() - 1);
        return lastEscape.doEscape(exp);
    }

    void visit(Template template) {
        TemplateHeaderElement header = template.getHeaderElement();
        if (header != null) {
            this.visit(header);
        }
        this.visit(template.getRootTreeNode());
    }

    void visit(TemplateHeaderElement header) {
        if (header == null) {
            return;
        }
        for (Map.Entry<String, Expression> entry : header.getParams().entrySet()) {
            String key = entry.getKey();
            try {
                if (key.equals("strict_vars")) {
                    boolean strictVariableDeclaration = header.getBooleanParameter("strict_vars");
                    this.template.setStrictVariableDeclaration(strictVariableDeclaration);
                    continue;
                }
                if (key.equals("legacy_syntax")) {
                    boolean strictVariableDeclaration = !header.getBooleanParameter("legacy_syntax");
                    this.template.setStrictVariableDeclaration(strictVariableDeclaration);
                    continue;
                }
                if (key.equals("nsPrefixes")) {
                    Object obj = header.getParameter("nsPrefixes");
                    if (!(obj instanceof Map)) continue;
                    Map map = (Map)obj;
                    for (Object prefix : map.keySet()) {
                        Object value = map.get(prefix);
                        this.template.addPrefixNSMapping(key.toString(), value.toString());
                    }
                    continue;
                }
                if (key.equals("encoding")) continue;
                ParsingProblemImpl problem = new ParsingProblemImpl("Unknown ftl header parameter: " + entry.getKey(), header);
                this.template.addParsingProblem(problem);
            }
            catch (Exception e) {
                ParsingProblemImpl problem = new ParsingProblemImpl(e.getMessage(), header);
                this.template.addParsingProblem(problem);
            }
        }
    }

    void visit(AssignmentInstruction node) {
        Macro macro;
        this.recurse(node);
        for (Expression target : node.getTargetExpressions()) {
            if (target.isAssignableTo()) continue;
            ParsingProblemImpl problem = new ParsingProblemImpl("Cannot assign to expression" + target + " ", target);
            this.template.addParsingProblem(problem);
        }
        if (this.template.strictVariableDeclaration()) {
            ParsingProblemImpl problem;
            if (node.get(0).getType() == Token.TokenType.ASSIGN) {
                problem = new ParsingProblemImpl("The assign directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            } else if (node.get(0).getType() == Token.TokenType.LOCALASSIGN) {
                problem = new ParsingProblemImpl("The local directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
        } else if (node.get(0).getType() == Token.TokenType.LOCALASSIGN && (macro = PostParseVisitor.getContainingMacro(node)) == null) {
            ParsingProblemImpl problem = new ParsingProblemImpl("The local directive can only be used inside a function or macro.", node);
            this.template.addParsingProblem(problem);
        }
    }

    void visit(BlockAssignment node) {
        Macro macro;
        ParsingProblemImpl problem;
        this.recurse(node);
        Expression targetExpression = node.getTargetExpression();
        if (!targetExpression.isAssignableTo()) {
            problem = new ParsingProblemImpl("The expression " + targetExpression + " cannot be assigned to.", targetExpression);
            this.template.addParsingProblem(problem);
        }
        if (this.template.strictVariableDeclaration()) {
            if (node.get(0).getType() == Token.TokenType.ASSIGN) {
                problem = new ParsingProblemImpl("The assign directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
            if (node.get(0).getType() == Token.TokenType.LOCALASSIGN) {
                problem = new ParsingProblemImpl("The local directive is deprecated and cannot be used in strict_vars mode. See the var and set directives.", node);
                this.template.addParsingProblem(problem);
            }
        } else if (node.get(0).getType() == Token.TokenType.LOCALASSIGN && (macro = PostParseVisitor.getContainingMacro(node)) == null) {
            this.template.addParsingProblem(new ParsingProblemImpl("The local directive can only be used inside a function or macro.", node));
        }
    }

    void visit(BuiltInExpression node) {
        this.recurse(node);
        if (node.getBuiltIn() == null) {
            ParsingProblemImpl problem = new ParsingProblemImpl("Unknown builtin: " + node.getName(), node);
            this.template.addParsingProblem(problem);
        }
    }

    void visit(Interpolation node) {
        this.recurse(node);
        Expression escapedExpression = this.escapedExpression(node.getExpression());
        node.setEscapedExpression(escapedExpression);
    }

    void visit(EscapeBlock node) {
        Expression escapedExpression = this.escapedExpression(node.getExpression());
        node.setEscapedExpression(escapedExpression);
        this.escapes.add(node);
        this.recurse(node);
        this.escapes.remove(this.escapes.size() - 1);
    }

    void visit(Macro node) {
        String macroName = node.getName();
        if (this.template.strictVariableDeclaration() && this.template.declaresVariable(macroName)) {
            ParsingProblemImpl problem = new ParsingProblemImpl("You already have declared a variable (or declared another macro) as " + macroName + ". You cannot reuse the variable name in the same template.", node);
            this.template.addParsingProblem(problem);
        }
        if (this.template.strictVariableDeclaration()) {
            this.template.declareVariable(macroName);
            Node parent = node.getParent();
            while (parent != null) {
                if ((parent = parent.getParent()) == null || parent instanceof EscapeBlock || parent instanceof NoEscapeBlock || parent instanceof Block) continue;
                ParsingProblemImpl problem = new ParsingProblemImpl("Macro " + macroName + " is within a " + ((TemplateNode)parent).getDescription() + ". It must be a top-level element.", node);
                this.template.addParsingProblem(problem);
            }
        }
        this.template.addMacro(node);
        this.recurse(node);
    }

    void visit(NoEscapeBlock node) {
        Node parent;
        for (parent = node; parent != null && !(parent instanceof EscapeBlock); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblemImpl("The noescape directive only makes sense inside an escape block.", node));
        }
        EscapeBlock last = this.escapes.remove(this.escapes.size() - 1);
        this.recurse(node);
        this.escapes.add(last);
    }

    void visit(IteratorBlock node) {
        node.getNestedBlock().declareVariable(node.getIndexName());
        node.getNestedBlock().declareVariable(node.getIndexName() + "_has_next");
        node.getNestedBlock().declareVariable(node.getIndexName() + "_index");
        if (node.getValueVarName() != null) {
            node.getNestedBlock().declareVariable(node.getValueVarName());
            node.getNestedBlock().declareVariable(node.getValueVarName() + "_has_next");
            node.getNestedBlock().declareVariable(node.getValueVarName() + "_index");
        }
        this.recurse(node);
    }

    void visit(BreakInstruction node) {
        Node parent;
        this.recurse(node);
        for (parent = node; parent != null && !(parent instanceof SwitchBlock) && !(parent instanceof IteratorBlock); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblemImpl("The break directive can only be used within a loop or a switch-case construct.", node));
        }
    }

    void visit(ReturnInstruction node) {
        Node parent;
        this.recurse(node);
        for (parent = node; parent != null && !(parent instanceof Macro); parent = parent.getParent()) {
        }
        if (parent == null) {
            this.template.addParsingProblem(new ParsingProblemImpl("The return directive can only be used inside a function or macro.", node));
        } else {
            Macro macro = (Macro)parent;
            if (!macro.isFunction() && node.size() > 2) {
                this.template.addParsingProblem(new ParsingProblemImpl("Can only return a value from a function, not a macro", node));
            } else if (macro.isFunction() && node.size() == 2) {
                this.template.addParsingProblem(new ParsingProblemImpl("A function must return a value.", node));
            }
        }
    }

    void visit(VarDirective node) {
        Block parent = (Block)node.getParent();
        for (String key : node.getVariables().keySet()) {
            if (parent == null) {
                this.template.declareVariable(key);
                continue;
            }
            if (parent.declaresVariable(key)) {
                String msg = "The variable " + key + " has already been declared in this block.";
                this.template.addParsingProblem(new ParsingProblemImpl(msg, node));
            }
            parent.declareVariable(key);
        }
    }

    void visit(StringLiteral node) {
        if (!node.isRaw()) {
            try {
                node.checkInterpolation();
            }
            catch (ParseException pe) {
                String msg = "Error in string " + node.getLocation();
                msg = msg + "\n" + pe.getMessage();
                this.template.addParsingProblem(new ParsingProblemImpl(msg, node));
            }
        }
    }

    void visit(ImportDeclaration node) {
        String namespaceName = node.getNamespace();
        if (this.template.strictVariableDeclaration() && this.template.declaresVariable(namespaceName)) {
            String msg = "The variable " + namespaceName + " is already declared and should not be used as a namespace name to import.";
            this.template.addParsingProblem(new ParsingProblemImpl(msg, node));
        }
        this.template.declareVariable(namespaceName);
        this.recurse(node);
    }

    void visit(PropertySetting node) {
        String key = node.getKey();
        if (!(key.equals("locale") || key.equals("number_format") || key.equals("time_format") || key.equals("date_format") || key.equals("datetime_format") || key.equals("time_zone") || key.equals("boolean_format") || key.equals("url_escaping_charset"))) {
            ParsingProblemImpl problem = new ParsingProblemImpl("Invalid setting name, or it is not allowed to change thevalue of the setting with FTL: " + key, node);
            this.template.addParsingProblem(problem);
        }
    }

    static Macro getContainingMacro(TemplateNode node) {
        Node parent;
        for (parent = node; parent != null && !(parent instanceof Macro); parent = parent.getParent()) {
        }
        return (Macro)parent;
    }
}

