/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.ParsingProblemImpl;
import freemarker.core.variables.Wrap;
import freemarker.log.Logger;
import freemarker.template.SettingStringParser;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Configuration
extends Configurable {
    private static final Logger logger = Logger.getLogger("freemarker.parser");
    private static Configuration defaultConfig = new Configuration();
    private boolean localizedLookup = true;
    private boolean legacySyntax;
    private TemplateCache cache;
    private HashMap<String, Object> variables = new HashMap();
    private HashMap<String, String> encodingMap = new HashMap();
    private Map<String, String> autoImportMap = new HashMap<String, String>();
    private ArrayList<String> autoImports = new ArrayList();
    private ArrayList<String> autoIncludes = new ArrayList();
    private String defaultEncoding = "UTF-8";
    private boolean tolerateParsingProblems = false;

    public Configuration() {
        this.cache = new TemplateCache();
        this.cache.setConfiguration(this);
        this.cache.setDelay(5000L);
        this.loadBuiltInSharedVariables();
    }

    public void setTemplateCache(TemplateCache cache) {
        this.cache = cache;
        cache.setConfiguration(this);
        cache.setDelay(5000L);
    }

    public TemplateCache getTemplateCache() {
        return this.cache;
    }

    private void loadBuiltInSharedVariables() {
        this.variables.put("compress", StandardCompress.INSTANCE);
        this.variables.put("html_escape", new HtmlEscape());
        this.variables.put("xml_escape", new XmlEscape());
    }

    public static Configuration getDefaultConfiguration() {
        return defaultConfig;
    }

    public static Configuration getCurrentConfiguration() {
        Environment env = Environment.getCurrentEnvironment();
        return env != null ? env.getConfiguration() : defaultConfig;
    }

    public static void setDefaultConfiguration(Configuration config) {
        defaultConfig = config;
    }

    public synchronized void setTemplateLoader(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void setTemplateLoaderNoCheck(TemplateLoader loader) {
        this.createTemplateCache(loader, this.cache.getCacheStorage());
    }

    private void createTemplateCache(TemplateLoader loader, CacheStorage storage) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage);
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setConfiguration(this);
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    public synchronized TemplateLoader getTemplateLoader() {
        return this.cache.getTemplateLoader();
    }

    public synchronized void setCacheStorage(CacheStorage storage) {
        this.createTemplateCache(this.cache.getTemplateLoader(), storage);
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoaderNoCheck(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object sctxt, String path) {
        try {
            if (path == null) {
                this.setTemplateLoaderNoCheck((TemplateLoader)Class.forName("freemarker.cache.WebappTemplateLoader").getConstructor(Class.forName("javax.servlet.ServletContext")).newInstance(sctxt));
            } else {
                this.setTemplateLoaderNoCheck((TemplateLoader)Class.forName("freemarker.cache.WebappTemplateLoader").getConstructor(Class.forName("javax.servlet.ServletContext"), String.class).newInstance(sctxt, path));
            }
        }
        catch (Exception exc) {
            throw new RuntimeException("Internal FreeMarker error: " + exc);
        }
    }

    public void setClassForTemplateLoading(Class clazz, String pathPrefix) {
        this.setTemplateLoaderNoCheck(new ClassTemplateLoader(clazz, pathPrefix));
    }

    public void setTemplateUpdateDelay(int delay) {
        this.cache.setDelay(1000L * (long)delay);
    }

    public void setStrictVariableDefinition(boolean b) {
        this.legacySyntax = !b;
    }

    public void setLegacySyntax(boolean b) {
        this.legacySyntax = b;
    }

    public boolean getStrictVariableDefinition() {
        return !this.legacySyntax;
    }

    public Template getTemplate(String name) throws IOException {
        Locale loc = this.getLocale();
        return this.getTemplate(name, loc, this.getEncoding(loc), true);
    }

    public Template getTemplate(String name, Locale locale) throws IOException {
        return this.getTemplate(name, locale, this.getEncoding(locale), true);
    }

    public Template getTemplate(String name, String encoding) throws IOException {
        return this.getTemplate(name, this.getLocale(), encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws IOException {
        return this.getTemplate(name, locale, encoding, true);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parse) throws IOException {
        Template result = this.cache.getTemplate(name, locale, encoding, parse);
        if (result == null) {
            throw new FileNotFoundException("Template " + name + " not found.");
        }
        if (result.hasParsingProblems() && !this.tolerateParsingProblems) {
            for (ParsingProblemImpl pp : result.getParsingProblems()) {
                logger.error(pp.getMessage());
            }
            throw new ParseException(result.getParsingProblems());
        }
        for (ParsingProblemImpl pp : result.getParsingProblems()) {
            logger.warn(pp.getMessage());
        }
        return result;
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale loc) {
        String charset = this.encodingMap.get(loc.toString());
        if (charset == null) {
            Locale l;
            if (loc.getVariant().length() > 0 && (charset = this.encodingMap.get((l = new Locale(loc.getLanguage(), loc.getCountry())).toString())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
            if ((charset = this.encodingMap.get(loc.getLanguage())) != null) {
                this.encodingMap.put(loc.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.encodingMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, Object tm) {
        this.variables.put(name, Wrap.wrap(tm));
    }

    public void put(String key, Object obj) {
        this.variables.put(key, Wrap.wrap(obj));
    }

    public Set<String> getSharedVariableNames() {
        return new HashSet<String>(this.variables.keySet());
    }

    public Object getSharedVariable(String name) {
        return this.variables.get(name);
    }

    public void clearSharedVariables() {
        this.variables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    @Override
    public void setSetting(String key, String value) {
        block24: {
            if ("TemplateUpdateInterval".equalsIgnoreCase(key)) {
                key = "template_update_delay";
            } else if ("DefaultEncoding".equalsIgnoreCase(key)) {
                key = "default_encoding";
            }
            try {
                if ("default_encoding".equalsIgnoreCase(key)) {
                    this.setDefaultEncoding(value);
                    break block24;
                }
                if ("localized_lookup".equalsIgnoreCase(key)) {
                    this.setLocalizedLookup(StringUtil.getYesNo(value));
                    break block24;
                }
                if ("strict_vars".equalsIgnoreCase(key)) {
                    this.setStrictVariableDefinition(StringUtil.getYesNo(value));
                    break block24;
                }
                if ("legacy_syntax".equalsIgnoreCase(key)) {
                    this.setStrictVariableDefinition(!StringUtil.getYesNo(value));
                    break block24;
                }
                if ("cache_storage".equalsIgnoreCase(key)) {
                    if (value.indexOf(46) == -1) {
                        int strongSize = 0;
                        int softSize = 0;
                        Map<String, String> map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                        for (Map.Entry<String, String> ent : map.entrySet()) {
                            int pvalue;
                            String pname = ent.getKey();
                            try {
                                pvalue = Integer.parseInt(ent.getValue());
                            }
                            catch (NumberFormatException e) {
                                throw this.invalidSettingValueException(key, value);
                            }
                            if ("soft".equalsIgnoreCase(pname)) {
                                softSize = pvalue;
                                continue;
                            }
                            if ("strong".equalsIgnoreCase(pname)) {
                                strongSize = pvalue;
                                continue;
                            }
                            throw this.invalidSettingValueException(key, value);
                        }
                        if (softSize == 0 && strongSize == 0) {
                            throw this.invalidSettingValueException(key, value);
                        }
                        this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                        break block24;
                    }
                    this.setCacheStorage((CacheStorage)Class.forName(value).newInstance());
                    break block24;
                }
                if ("template_update_delay".equalsIgnoreCase(key)) {
                    this.setTemplateUpdateDelay(Integer.parseInt(value));
                } else if ("auto_include".equalsIgnoreCase(key)) {
                    this.setAutoIncludes(new SettingStringParser(value).parseAsList());
                } else if ("auto_import".equalsIgnoreCase(key)) {
                    this.setAutoImports(new SettingStringParser(value).parseAsImportList());
                } else {
                    super.setSetting(key, value);
                }
            }
            catch (TemplateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TemplateException("Failed to set setting " + key + " to value " + value, e, this.getEnvironment());
            }
        }
    }

    public synchronized void addAutoImport(String namespace, String template) {
        this.autoImports.remove(namespace);
        this.autoImports.add(namespace);
        this.autoImportMap.put(namespace, template);
    }

    public synchronized void removeAutoImport(String namespace) {
        this.autoImports.remove(namespace);
        this.autoImportMap.remove(namespace);
    }

    public synchronized void setAutoImports(Map<String, String> map) {
        this.autoImports = new ArrayList<String>(map.keySet());
        this.autoImportMap = new HashMap<String, String>(map);
    }

    @Override
    protected void doAutoImportsAndIncludes(Environment env) throws IOException {
        for (String namespace : this.autoImports) {
            String templateName = this.autoImportMap.get(namespace);
            env.importLib(templateName, namespace);
        }
        for (String templateName : this.autoIncludes) {
            env.include(this.getTemplate(templateName, env.getLocale()), false);
        }
    }

    public synchronized void addAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
        this.autoIncludes.add(templateName);
    }

    public synchronized void setAutoIncludes(List<String> templateNames) {
        this.autoIncludes.clear();
        this.autoIncludes.addAll(templateNames);
    }

    public synchronized void removeAutoInclude(String templateName) {
        this.autoIncludes.remove(templateName);
    }

    public static String getVersionNumber() {
        return "3.0 Preview";
    }

    public void setTolerateParsingProblems(boolean tolerateParsingProblems) {
        this.tolerateParsingProblems = tolerateParsingProblems;
    }
}

