/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables.scope;

import freemarker.core.variables.scope.Scope;
import java.util.List;

public class NamedParameterListScope
implements Scope {
    private final List<String> paramNames;
    private final List<Object> paramValues;
    private final boolean readOnly;
    private Scope enclosingScope;

    public NamedParameterListScope(Scope enclosingScope, List<String> paramNames, List<Object> paramValues, boolean readOnly) {
        this.enclosingScope = enclosingScope;
        this.paramNames = paramNames;
        this.paramValues = paramValues;
        this.readOnly = readOnly;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.paramNames.contains(name);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        int i = this.paramNames.indexOf(key);
        if (i == -1) {
            throw new IllegalArgumentException("key " + key + " not found");
        }
        while (i >= this.paramValues.size()) {
            this.paramValues.add(null);
        }
        return this.paramValues.set(i, value);
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int nonNullCount = 0;
        int size = Math.min(this.paramNames.size(), this.paramValues.size());
        for (int i = 0; i < size; ++i) {
            if (this.paramValues.get(i) == null) continue;
            ++nonNullCount;
        }
        return nonNullCount;
    }

    @Override
    public Object get(Object key) {
        int i = this.paramNames.indexOf(key);
        return i != -1 && i < this.paramValues.size() ? this.paramValues.get(i) : null;
    }
}

