/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables.scope;

import freemarker.core.nodes.generated.Block;
import freemarker.core.variables.scope.Scope;
import freemarker.template.Template;
import java.util.HashMap;

public class BlockScope
extends HashMap<String, Object>
implements Scope {
    private Block block;
    private Scope enclosingScope;

    public BlockScope(Block block, Scope enclosingScope) {
        this.block = block;
        this.enclosingScope = enclosingScope;
    }

    @Override
    public Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public Template getTemplate() {
        return this.block.getTemplate();
    }

    @Override
    public Object put(String key, Object tm) {
        if (this.getTemplate().strictVariableDeclaration() && !this.definesVariable(key)) {
            throw new IllegalArgumentException("The variable " + key + " is not declared here.");
        }
        return super.put(key, tm);
    }

    protected void putUnconditionally(String key, Object var) {
        super.put(key, var);
    }

    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.getBlock().declaresVariable(name);
    }

    public Object remove(String key) {
        return super.remove(key);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean isTemplateNamespace() {
        return this.block.isTemplateRoot();
    }
}

