/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.variables.DateWrapper;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.GeneralPurposeNothing;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.ResourceBundleWrapper;
import freemarker.core.variables.WrappedVariable;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.xml.WrappedDomNode;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Node;

public class Wrap {
    public static final Object NOTHING = GeneralPurposeNothing.getInstance();
    public static final Object JAVA_NULL = new JavaNull();
    private static int defaultDateType = 0;
    private static final Class<?> RECORD_CLASS;

    public static boolean isJdk14OrGreater() {
        return RECORD_CLASS != null;
    }

    private Wrap() {
    }

    public static boolean isRecord(Object obj) {
        return RECORD_CLASS != null && RECORD_CLASS.isInstance(obj);
    }

    public static boolean isMap(Object obj) {
        if (obj instanceof WrappedVariable) {
            obj = ((WrappedVariable)obj).getWrappedObject();
        }
        return obj instanceof Map;
    }

    public static boolean isList(Object obj) {
        if (obj instanceof TemplateSequenceModel) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return true;
        }
        return obj instanceof List;
    }

    public static List<?> asList(Object obj) {
        if (obj instanceof TemplateSequenceModel) {
            TemplateSequenceModel tsm = (TemplateSequenceModel)obj;
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < tsm.size(); ++i) {
                result.add(tsm.get(i));
            }
            return result;
        }
        if (obj.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(obj); ++i) {
                result.add(Array.get(obj, i));
            }
            return result;
        }
        return (List)obj;
    }

    public static boolean isDate(Object obj) {
        if (obj instanceof TemplateDateModel) {
            return true;
        }
        if (obj instanceof WrappedVariable) {
            obj = ((WrappedVariable)obj).getWrappedObject();
        }
        return obj instanceof Date;
    }

    public static Date asDate(Object obj) {
        if (obj instanceof TemplateDateModel) {
            return ((TemplateDateModel)obj).getAsDate();
        }
        return (Date)obj;
    }

    public static String asString(Object obj) {
        if (obj instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)obj).getAsString();
        }
        return obj.toString();
    }

    public static boolean isBoolean(Object obj) {
        if (obj instanceof TemplateBooleanModel) {
            return true;
        }
        if (obj instanceof WrappedVariable) {
            obj = ((WrappedVariable)obj).getWrappedObject();
        }
        return obj instanceof Boolean;
    }

    public static boolean asBoolean(Object obj) {
        if (obj instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)obj).getAsBoolean();
        }
        return (Boolean)obj;
    }

    public static boolean isIterable(Object obj) {
        return obj instanceof Iterable || obj instanceof Iterator || obj.getClass().isArray();
    }

    public static Iterator<?> asIterator(Object obj) {
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj.getClass().isArray()) {
            final Object arr = obj;
            return new Iterator<Object>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < Array.getLength(arr);
                }

                @Override
                public Object next() {
                    return Array.get(arr, this.index++);
                }
            };
        }
        return ((Iterable)obj).iterator();
    }

    public static synchronized void setDefaultDateType(int defaultDateType) {
        Wrap.defaultDateType = defaultDateType;
    }

    static synchronized int getDefaultDateType() {
        return defaultDateType;
    }

    public static Object wrap(Object object) {
        if (object == null) {
            return JAVA_NULL;
        }
        if (object instanceof Date) {
            return new DateWrapper((Date)object);
        }
        if (object instanceof ResourceBundle) {
            return new ResourceBundleWrapper((ResourceBundle)object);
        }
        if (object instanceof Node) {
            return WrappedDomNode.wrapNode((Node)object);
        }
        return object;
    }

    public static Object unwrap(Object object) {
        Object unwrapped;
        if (object == null) {
            throw new EvaluationException("invalid reference");
        }
        if (object == JAVA_NULL) {
            return null;
        }
        if (object instanceof WrappedVariable && (unwrapped = ((WrappedVariable)object).getWrappedObject()) != null) {
            return unwrapped;
        }
        return object;
    }

    public static Date getDate(TemplateDateModel wrappedDate, Expression expr, Environment env) {
        Date value = wrappedDate.getAsDate();
        if (value == null) {
            throw new TemplateException(expr + " evaluated to null date.", env);
        }
        return value;
    }

    public static Number getNumber(Object object, Expression expr, Environment env) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object == null) {
            throw new InvalidReferenceException(expr + " is undefined.", env);
        }
        if (object == JAVA_NULL) {
            throw new InvalidReferenceException(expr + " is null.", env);
        }
        throw new TemplateException(expr + " is not a number, it is " + object.getClass().getName(), env);
    }

    public static Number getNumber(Expression expr, Environment env) {
        Object value = expr.evaluate(env);
        return Wrap.getNumber(value, expr, env);
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.lang.Record");
        }
        catch (Exception exception) {
        }
        finally {
            RECORD_CLASS = clazz;
        }
    }

    private static class JavaNull
    implements WrappedVariable {
        private JavaNull() {
        }

        @Override
        public Object getWrappedObject() {
            return null;
        }
    }
}

