/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables;

import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateHashModel;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleWrapper
implements VarArgsFunction,
TemplateHashModel {
    private Hashtable<String, MessageFormat> formats = null;
    private ResourceBundle bundle;

    public ResourceBundleWrapper(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public Object apply(Object ... arguments) throws EvaluationException {
        if (arguments.length < 1) {
            throw new EvaluationException("No message key was specified");
        }
        Iterator<Object> it = Arrays.asList(arguments).iterator();
        String key = Wrap.asString(it.next());
        try {
            if (!it.hasNext()) {
                return Wrap.wrap(this.bundle.getObject(key));
            }
            int args = arguments.length - 1;
            Object[] params = new Object[args];
            for (int i = 0; i < args; ++i) {
                params[i] = Wrap.unwrap(it.next());
            }
            return this.format(key, params);
        }
        catch (MissingResourceException e) {
            throw new EvaluationException("No such key: " + key);
        }
        catch (Exception e) {
            throw new EvaluationException(e.getMessage());
        }
    }

    @Override
    public Object get(String key) {
        return this.getWrappedObject().getObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String key, Object[] params) throws MissingResourceException {
        if (this.formats == null) {
            this.formats = new Hashtable();
        }
        MessageFormat format = null;
        format = this.formats.get(key);
        if (format == null) {
            format = new MessageFormat(this.getWrappedObject().getString(key));
            format.setLocale(this.bundle.getLocale());
            this.formats.put(key, format);
        }
        MessageFormat messageFormat = format;
        synchronized (messageFormat) {
            return format.format(params);
        }
    }

    public ResourceBundle getWrappedObject() {
        return this.bundle;
    }
}

