/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables;

import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.JavaMethodCall;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionCode {
    private static Map<String, Method> methodCache = new ConcurrentHashMap<String, Method>();
    private static Map<String, Method> getterCache = new ConcurrentHashMap<String, Method>();
    private static Map<String, Method> setterCache = new ConcurrentHashMap<String, Method>();
    private static Map<String, Boolean> classHasMethodCache = new ConcurrentHashMap<String, Boolean>();
    private static final Object CAN_NOT_UNWRAP = new Object();
    private static final Method NO_SUCH_METHOD;

    private ReflectionCode() {
    }

    public static Object invokeMethod(Object target, Method method, Object[] params) {
        if (ReflectionCode.isBannedMethod(method)) {
            throw new EvaluationException("Cannot run method: " + method);
        }
        Object[] args = ReflectionCode.unwrapArgsForMethod(method, params);
        Object result = null;
        try {
            result = method.invoke(target, args);
        }
        catch (Exception e) {
            throw new EvaluationException("Error invoking method " + method, e);
        }
        if (result == null && method.getReturnType() == Void.TYPE) {
            result = null;
        }
        return result;
    }

    public static Object getProperty(Object object, String key, boolean looseSyntax) {
        Method getter = ReflectionCode.getGetter(object, key);
        if (getter != NO_SUCH_METHOD) {
            try {
                return Wrap.wrap(getter.invoke(object, new Object[0]));
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
        }
        if (looseSyntax && ReflectionCode.methodOfNameExists(object, key)) {
            return new JavaMethodCall(object, key);
        }
        return null;
    }

    public static boolean setProperty(Object object, String key, Object value) {
        Method setter = ReflectionCode.getSetter(object, key, value);
        if (setter == NO_SUCH_METHOD) {
            return false;
        }
        Class<?> desiredType = setter.getParameterTypes()[0];
        value = ReflectionCode.unwrap(value, desiredType);
        try {
            setter.invoke(object, value);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
        return true;
    }

    static Method getCachedMethod(Object target, String methodName, Object[] params) {
        return methodCache.get(ReflectionCode.getLookupKey(target, methodName, params));
    }

    static void cacheMethod(Method m, Object target, Object[] params) {
        methodCache.put(ReflectionCode.getLookupKey(target, m.getName(), params), m);
    }

    static boolean isCompatibleMethod(Method method, Object[] params) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!method.isVarArgs() && paramTypes.length != params.length) {
            return false;
        }
        if (method.isVarArgs() && params.length < paramTypes.length - 1) {
            return false;
        }
        int paramTypesToCheck = paramTypes.length;
        if (method.isVarArgs()) {
            --paramTypesToCheck;
        }
        for (int i = 0; i < paramTypesToCheck; ++i) {
            Object arg = ReflectionCode.unwrap(params[i], paramTypes[i]);
            if (arg != CAN_NOT_UNWRAP) continue;
            return false;
        }
        if (!method.isVarArgs()) {
            return true;
        }
        Class<?> varArgsType = paramTypes[paramTypes.length - 1].getComponentType();
        for (int i = paramTypes.length - 1; i < params.length; ++i) {
            Object arg = ReflectionCode.unwrap(params[i], varArgsType);
            if (arg != CAN_NOT_UNWRAP) continue;
            return false;
        }
        return true;
    }

    static boolean isMoreSpecific(Method method1, Method method2, Object[] params) {
        if (!method1.isVarArgs() && method2.isVarArgs()) {
            return true;
        }
        if (method1.isVarArgs() && !method2.isVarArgs()) {
            return false;
        }
        Class<?>[] types1 = method1.getParameterTypes();
        Class<?>[] types2 = method2.getParameterTypes();
        int numParams = types1.length;
        if (method1.isVarArgs()) {
            --numParams;
        }
        boolean moreSpecific = false;
        boolean lessSpecific = false;
        for (int i = 0; i < numParams; ++i) {
            Class<?> type1 = types1[i];
            Class<?> type2 = types2[i];
            if (type1 == type2) continue;
            Object param = params[i];
            if (type1.isInstance(param) && !type2.isInstance(param)) {
                moreSpecific = true;
                continue;
            }
            if (type2.isInstance(param) && !type1.isInstance(param)) {
                lessSpecific = true;
                continue;
            }
            if (type2.isAssignableFrom(type1)) {
                moreSpecific = true;
                continue;
            }
            lessSpecific = true;
        }
        return moreSpecific && !lessSpecific;
    }

    private static boolean methodOfNameExists(Object object, String name) {
        String lookupKey = ReflectionCode.getLookupKey(object, name);
        Boolean b = classHasMethodCache.get(lookupKey);
        if (b != null) {
            return b;
        }
        for (Method m : object.getClass().getMethods()) {
            if (!m.getName().equals(name)) continue;
            classHasMethodCache.put(lookupKey, true);
            return true;
        }
        classHasMethodCache.put(lookupKey, false);
        return false;
    }

    private static Method getGetter(Object object, String name) {
        Method m3;
        String lookupKey = ReflectionCode.getLookupKey(object, name);
        Method cachedMethod = getterCache.get(lookupKey);
        if (cachedMethod != null) {
            return cachedMethod;
        }
        if (Wrap.isRecord(object)) {
            try {
                Method m2 = object.getClass().getMethod(name, new Class[0]);
                if (m2.getReturnType() != Void.TYPE) {
                    getterCache.put(lookupKey, m2);
                    m2.setAccessible(true);
                    return m2;
                }
            }
            catch (NoSuchMethodException m2) {
                // empty catch block
            }
        }
        String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
        try {
            m3 = object.getClass().getMethod(methodName, new Class[0]);
            if (m3.getReturnType() != Void.TYPE) {
                getterCache.put(lookupKey, m3);
                m3.setAccessible(true);
                return m3;
            }
        }
        catch (NoSuchMethodException m3) {
            // empty catch block
        }
        methodName = methodName.replaceFirst("get", "is");
        try {
            m3 = object.getClass().getMethod(methodName, new Class[0]);
            if (m3.getReturnType() == Boolean.TYPE || m3.getReturnType() == Boolean.class) {
                getterCache.put(ReflectionCode.getLookupKey(object, name), m3);
                m3.setAccessible(true);
                return m3;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getterCache.put(lookupKey, NO_SUCH_METHOD);
        return NO_SUCH_METHOD;
    }

    private static Method getSetter(Object target, String name, Object value) {
        String lookupKey = ReflectionCode.getLookupKey(target, name, value);
        Method cachedMethod = setterCache.get(lookupKey);
        if (cachedMethod != null) {
            return cachedMethod;
        }
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : target.getClass().getMethods()) {
            Class<?> type;
            Object unwrapped;
            if (!m.getName().equals(methodName) || m.getReturnType() != Void.TYPE || m.getParameterTypes().length != 1 || (unwrapped = ReflectionCode.unwrap(value, type = m.getParameterTypes()[0])) == CAN_NOT_UNWRAP) continue;
            setterCache.put(lookupKey, m);
            m.setAccessible(true);
            return m;
        }
        setterCache.put(lookupKey, NO_SUCH_METHOD);
        return NO_SUCH_METHOD;
    }

    private static Object[] unwrapArgsForMethod(Method method, Object[] params) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        int numFixedParams = paramTypes.length;
        if (method.isVarArgs()) {
            --numFixedParams;
        }
        for (int i = 0; i < numFixedParams; ++i) {
            Object param = params[i];
            Class<?> paramType = paramTypes[i];
            args[i] = ReflectionCode.unwrap(param, paramType);
        }
        if (method.isVarArgs()) {
            Class<?> varArgType = paramTypes[paramTypes.length - 1].getComponentType();
            Object varArgsArray = Array.newInstance(varArgType, params.length - numFixedParams);
            for (int i = numFixedParams; i < params.length; ++i) {
                Object arg = ReflectionCode.unwrap(params[i], varArgType);
                Array.set(varArgsArray, i - numFixedParams, arg);
            }
            args[args.length - 1] = varArgsArray;
        }
        return args;
    }

    private static boolean isBannedMethod(Method method) {
        Class<?> clazz = method.getDeclaringClass();
        if (clazz == Object.class && (method.getName().equals("wait") || method.getName().startsWith("notify"))) {
            return true;
        }
        return clazz == System.class || clazz == Runtime.class || clazz == Thread.class || clazz == ThreadGroup.class || clazz == Class.class || clazz == ClassLoader.class || clazz.getPackage().getName().equals("java.lang.reflect");
    }

    private static Object unwrap(Object object, Class<?> desiredType) {
        if (object == null || object == Wrap.JAVA_NULL || object == Wrap.NOTHING) {
            return desiredType.isPrimitive() ? CAN_NOT_UNWRAP : null;
        }
        if (desiredType.isInstance(object = Wrap.unwrap(object))) {
            return object;
        }
        if (desiredType == Boolean.TYPE || desiredType == Boolean.class) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof TemplateBooleanModel) {
                return ((TemplateBooleanModel)object).getAsBoolean();
            }
            return CAN_NOT_UNWRAP;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            if (desiredType == Integer.class || desiredType == Integer.TYPE) {
                return num.intValue();
            }
            if (desiredType == Long.class || desiredType == Long.TYPE) {
                return num.longValue();
            }
            if (desiredType == Short.class || desiredType == Short.TYPE) {
                return num.shortValue();
            }
            if (desiredType == Byte.class || desiredType == Byte.TYPE) {
                return num.byteValue();
            }
            if (desiredType == Float.class || desiredType == Float.TYPE) {
                return Float.valueOf(num.floatValue());
            }
            if (desiredType == Double.class || desiredType == Double.TYPE) {
                return num.doubleValue();
            }
            if (desiredType == BigDecimal.class) {
                return new BigDecimal(num.toString());
            }
            if (desiredType == BigInteger.class) {
                return new BigInteger(num.toString());
            }
            return CAN_NOT_UNWRAP;
        }
        if (desiredType == Date.class && object instanceof TemplateDateModel) {
            return ((TemplateDateModel)object).getAsDate();
        }
        if (desiredType == String.class) {
            return object.toString();
        }
        return CAN_NOT_UNWRAP;
    }

    private static String getLookupKey(Object target, String methodName, Object[] params) {
        StringBuilder buf = new StringBuilder();
        buf.append(target.getClass().getName());
        buf.append('#');
        buf.append(methodName);
        buf.append('#');
        if (params != null) {
            for (Object param : params) {
                buf.append(param.getClass());
                buf.append(':');
            }
        }
        return buf.toString();
    }

    private static String getLookupKey(Object object, String propertyName) {
        return object.getClass().getName() + "##" + propertyName;
    }

    private static String getLookupKey(Object object, String propertyName, Object value) {
        return object.getClass().getName() + "#" + propertyName + "#" + value.getClass().getName();
    }

    static {
        try {
            NO_SUCH_METHOD = Object.class.getMethod("wait", new Class[0]);
        }
        catch (Exception e) {
            throw new InternalError("This should be impossible!");
        }
    }
}

