/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.variables;

import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.ReflectionCode;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.WrappedVariable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class JavaMethodCall
implements VarArgsFunction<Object> {
    private String methodName;
    private Object target;
    private List<Method> possibleMethods;

    public JavaMethodCall(Object target, String methodName) {
        Object wrappedObject;
        if (target instanceof WrappedVariable && (wrappedObject = ((WrappedVariable)target).getWrappedObject()) != null) {
            target = wrappedObject;
        }
        this.target = target;
        this.methodName = methodName;
        this.findPossibleMethods();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object getTarget() {
        return this.target;
    }

    private void findPossibleMethods() {
        Class<?> clazz = this.target.getClass();
        Method[] methods = clazz.getMethods();
        this.possibleMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (!method.getName().equals(this.methodName)) continue;
            this.possibleMethods.add(method);
        }
        if (this.possibleMethods.size() == 1) {
            this.possibleMethods.get(0).setAccessible(true);
        }
    }

    public boolean isMethodOverloaded() {
        return this.possibleMethods.size() > 1;
    }

    public boolean isInvalidMethodName() {
        return this.possibleMethods.size() == 0;
    }

    @Override
    public Object apply(Object ... params) {
        if (this.isInvalidMethodName()) {
            throw new EvaluationException("No such method " + this.methodName + " in class: " + this.target.getClass());
        }
        if (!this.isMethodOverloaded()) {
            return ReflectionCode.invokeMethod(this.target, this.possibleMethods.get(0), params);
        }
        Method method = ReflectionCode.getCachedMethod(this.target, this.methodName, params);
        if (method != null) {
            return ReflectionCode.invokeMethod(this.target, method, params);
        }
        Method matchedMethod = null;
        for (Method m : this.possibleMethods) {
            if (!ReflectionCode.isCompatibleMethod(m, params) || matchedMethod != null && !ReflectionCode.isMoreSpecific(m, matchedMethod, params)) continue;
            matchedMethod = m;
        }
        if (matchedMethod == null) {
            throw new EvaluationException("Cannot invoke method " + this.methodName + " here.");
        }
        ReflectionCode.cacheMethod(matchedMethod, this.target, params);
        return ReflectionCode.invokeMethod(this.target, matchedMethod, params);
    }
}

