/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.nodes.Whitespace;
import freemarker.core.nodes.generated.BooleanLiteral;
import freemarker.core.nodes.generated.Comment;
import freemarker.core.nodes.generated.DIRECTIVE_ENDToken;
import freemarker.core.nodes.generated.Delimiter;
import freemarker.core.nodes.generated.DirectiveName;
import freemarker.core.nodes.generated.EOL;
import freemarker.core.nodes.generated.IGNORED_WS;
import freemarker.core.nodes.generated.Identifier;
import freemarker.core.nodes.generated.LegacyNoParse;
import freemarker.core.nodes.generated.NullLiteral;
import freemarker.core.nodes.generated.NumberLiteral;
import freemarker.core.nodes.generated.Operator;
import freemarker.core.nodes.generated.Printable;
import freemarker.core.nodes.generated.START_TAG;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.InvalidToken;
import freemarker.core.parser.Node;
import freemarker.core.parser.TokenSource;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements CharSequence,
Node.TerminalNode {
    private Template template;
    private FMLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public FMLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (FMLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        FMLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        FMLexer ts = this.getTokenSource();
        return ts == null ? null : ts.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case TRIM: {
                return new DirectiveName(TokenType.TRIM, tokenSource, beginOffset, endOffset);
            }
            case VAR: {
                return new DirectiveName(TokenType.VAR, tokenSource, beginOffset, endOffset);
            }
            case ESCAPED_GT: {
                return new Operator(TokenType.ESCAPED_GT, tokenSource, beginOffset, endOffset);
            }
            case NOPARSE: {
                return new LegacyNoParse(TokenType.NOPARSE, tokenSource, beginOffset, endOffset);
            }
            case PROBLEMATIC_CHAR: {
                return new Printable(TokenType.PROBLEMATIC_CHAR, tokenSource, beginOffset, endOffset);
            }
            case MINUS: {
                return new Operator(TokenType.MINUS, tokenSource, beginOffset, endOffset);
            }
            case POINTY_COMMENT: {
                return new Comment(TokenType.POINTY_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case SEMICOLON: {
                return new Delimiter(TokenType.SEMICOLON, tokenSource, beginOffset, endOffset);
            }
            case OPEN_BRACE: {
                return new Delimiter(TokenType.OPEN_BRACE, tokenSource, beginOffset, endOffset);
            }
            case GREATER_THAN: {
                return new Operator(TokenType.GREATER_THAN, tokenSource, beginOffset, endOffset);
            }
            case BREAK: {
                return new DirectiveName(TokenType.BREAK, tokenSource, beginOffset, endOffset);
            }
            case ELSE: {
                return new DirectiveName(TokenType.ELSE, tokenSource, beginOffset, endOffset);
            }
            case SETTING: {
                return new DirectiveName(TokenType.SETTING, tokenSource, beginOffset, endOffset);
            }
            case FLUSH: {
                return new DirectiveName(TokenType.FLUSH, tokenSource, beginOffset, endOffset);
            }
            case EMPTY_DIRECTIVE_END: {
                return new Delimiter(TokenType.EMPTY_DIRECTIVE_END, tokenSource, beginOffset, endOffset);
            }
            case ID: {
                return new Identifier(TokenType.ID, tokenSource, beginOffset, endOffset);
            }
            case IF: {
                return new DirectiveName(TokenType.IF, tokenSource, beginOffset, endOffset);
            }
            case STOP: {
                return new DirectiveName(TokenType.STOP, tokenSource, beginOffset, endOffset);
            }
            case IN: {
                return new Delimiter(TokenType.IN, tokenSource, beginOffset, endOffset);
            }
            case DOT: {
                return new Operator(TokenType.DOT, tokenSource, beginOffset, endOffset);
            }
            case LESS_THAN: {
                return new Operator(TokenType.LESS_THAN, tokenSource, beginOffset, endOffset);
            }
            case FUNCTION: {
                return new DirectiveName(TokenType.FUNCTION, tokenSource, beginOffset, endOffset);
            }
            case CASE: {
                return new DirectiveName(TokenType.CASE, tokenSource, beginOffset, endOffset);
            }
            case POSSIBLE_DIRECTIVE: {
                return new Printable(TokenType.POSSIBLE_DIRECTIVE, tokenSource, beginOffset, endOffset);
            }
            case AS: {
                return new Delimiter(TokenType.AS, tokenSource, beginOffset, endOffset);
            }
            case OPEN_PAREN: {
                return new Delimiter(TokenType.OPEN_PAREN, tokenSource, beginOffset, endOffset);
            }
            case FTL_HEADER: {
                return new DirectiveName(TokenType.FTL_HEADER, tokenSource, beginOffset, endOffset);
            }
            case ELLIPSIS: {
                return new Operator(TokenType.ELLIPSIS, tokenSource, beginOffset, endOffset);
            }
            case LTRIM: {
                return new DirectiveName(TokenType.LTRIM, tokenSource, beginOffset, endOffset);
            }
            case EXCLAM: {
                return new Operator(TokenType.EXCLAM, tokenSource, beginOffset, endOffset);
            }
            case SET: {
                return new DirectiveName(TokenType.SET, tokenSource, beginOffset, endOffset);
            }
            case EMBED: {
                return new DirectiveName(TokenType.EMBED, tokenSource, beginOffset, endOffset);
            }
            case CLOSE_BRACKET: {
                return new Delimiter(TokenType.CLOSE_BRACKET, tokenSource, beginOffset, endOffset);
            }
            case RECURSE: {
                return new DirectiveName(TokenType.RECURSE, tokenSource, beginOffset, endOffset);
            }
            case TERNARY: {
                return new Operator(TokenType.TERNARY, tokenSource, beginOffset, endOffset);
            }
            case ASSIGN: {
                return new DirectiveName(TokenType.ASSIGN, tokenSource, beginOffset, endOffset);
            }
            case FOREACH: {
                return new DirectiveName(TokenType.FOREACH, tokenSource, beginOffset, endOffset);
            }
            case LESS_THAN_EQUALS: {
                return new Operator(TokenType.LESS_THAN_EQUALS, tokenSource, beginOffset, endOffset);
            }
            case DIVIDE: {
                return new Operator(TokenType.DIVIDE, tokenSource, beginOffset, endOffset);
            }
            case IMPORT: {
                return new DirectiveName(TokenType.IMPORT, tokenSource, beginOffset, endOffset);
            }
            case CLOSE_BRACE: {
                return new Delimiter(TokenType.CLOSE_BRACE, tokenSource, beginOffset, endOffset);
            }
            case LOCALASSIGN: {
                return new DirectiveName(TokenType.LOCALASSIGN, tokenSource, beginOffset, endOffset);
            }
            case POSSIBLE_END_DIRECTIVE: {
                return new Printable(TokenType.POSSIBLE_END_DIRECTIVE, tokenSource, beginOffset, endOffset);
            }
            case COMMA: {
                return new Delimiter(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case DEFAUL: {
                return new DirectiveName(TokenType.DEFAUL, tokenSource, beginOffset, endOffset);
            }
            case RAW_STRING: {
                return new StringLiteral(TokenType.RAW_STRING, tokenSource, beginOffset, endOffset);
            }
            case _INCLUDE: {
                return new DirectiveName(TokenType._INCLUDE, tokenSource, beginOffset, endOffset);
            }
            case _ATTEMPT: {
                return new DirectiveName(TokenType._ATTEMPT, tokenSource, beginOffset, endOffset);
            }
            case UNKNOWN_DIRECTIVE: {
                return new DirectiveName(TokenType.UNKNOWN_DIRECTIVE, tokenSource, beginOffset, endOffset);
            }
            case _ASSERT: {
                return new DirectiveName(TokenType._ASSERT, tokenSource, beginOffset, endOffset);
            }
            case PERCENT: {
                return new Operator(TokenType.PERCENT, tokenSource, beginOffset, endOffset);
            }
            case SQUARE_COMMENT: {
                return new Comment(TokenType.SQUARE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case UNIFIED_CALL_END: {
                return new Delimiter(TokenType.UNIFIED_CALL_END, tokenSource, beginOffset, endOffset);
            }
            case ELSE_IF: {
                return new DirectiveName(TokenType.ELSE_IF, tokenSource, beginOffset, endOffset);
            }
            case NOESCAPE: {
                return new DirectiveName(TokenType.NOESCAPE, tokenSource, beginOffset, endOffset);
            }
            case OUTPUT_ESCAPE: {
                return new Delimiter(TokenType.OUTPUT_ESCAPE, tokenSource, beginOffset, endOffset);
            }
            case NUMBER: {
                return new NumberLiteral(TokenType.NUMBER, tokenSource, beginOffset, endOffset);
            }
            case NULL: {
                return new NullLiteral(TokenType.NULL, tokenSource, beginOffset, endOffset);
            }
            case DOUBLE_EQUALS: {
                return new Operator(TokenType.DOUBLE_EQUALS, tokenSource, beginOffset, endOffset);
            }
            case TRUE: {
                return new BooleanLiteral(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case DOUBLE_STAR: {
                return new Operator(TokenType.DOUBLE_STAR, tokenSource, beginOffset, endOffset);
            }
            case NON_TRAILING_WHITESPACE: {
                return new Whitespace(TokenType.NON_TRAILING_WHITESPACE, tokenSource, beginOffset, endOffset);
            }
            case USING: {
                return new Delimiter(TokenType.USING, tokenSource, beginOffset, endOffset);
            }
            case EXEC: {
                return new DirectiveName(TokenType.EXEC, tokenSource, beginOffset, endOffset);
            }
            case AND: {
                return new Operator(TokenType.AND, tokenSource, beginOffset, endOffset);
            }
            case TRAILING_WHITESPACE: {
                return new Whitespace(TokenType.TRAILING_WHITESPACE, tokenSource, beginOffset, endOffset);
            }
            case ESCAPED_GTE: {
                return new Operator(TokenType.ESCAPED_GTE, tokenSource, beginOffset, endOffset);
            }
            case SWITCH: {
                return new DirectiveName(TokenType.SWITCH, tokenSource, beginOffset, endOffset);
            }
            case CLOSE_PAREN: {
                return new Delimiter(TokenType.CLOSE_PAREN, tokenSource, beginOffset, endOffset);
            }
            case START_TAG: {
                return new START_TAG(TokenType.START_TAG, tokenSource, beginOffset, endOffset);
            }
            case LIST: {
                return new DirectiveName(TokenType.LIST, tokenSource, beginOffset, endOffset);
            }
            case CLOSE_DIRECTIVE_BLOCK: {
                return new Delimiter(TokenType.CLOSE_DIRECTIVE_BLOCK, tokenSource, beginOffset, endOffset);
            }
            case PLUS: {
                return new Operator(TokenType.PLUS, tokenSource, beginOffset, endOffset);
            }
            case BUILT_IN: {
                return new Operator(TokenType.BUILT_IN, tokenSource, beginOffset, endOffset);
            }
            case GREATER_THAN_EQUALS: {
                return new Operator(TokenType.GREATER_THAN_EQUALS, tokenSource, beginOffset, endOffset);
            }
            case RETURN: {
                return new DirectiveName(TokenType.RETURN, tokenSource, beginOffset, endOffset);
            }
            case DOT_DOT: {
                return new Operator(TokenType.DOT_DOT, tokenSource, beginOffset, endOffset);
            }
            case SINGLE_LINE_COMMENT: {
                return new Comment(TokenType.SINGLE_LINE_COMMENT, tokenSource, beginOffset, endOffset);
            }
            case _MACRO: {
                return new DirectiveName(TokenType._MACRO, tokenSource, beginOffset, endOffset);
            }
            case REGULAR_PRINTABLE: {
                return new Printable(TokenType.REGULAR_PRINTABLE, tokenSource, beginOffset, endOffset);
            }
            case RTRIM: {
                return new DirectiveName(TokenType.RTRIM, tokenSource, beginOffset, endOffset);
            }
            case EOL: {
                return new EOL(TokenType.EOL, tokenSource, beginOffset, endOffset);
            }
            case OR: {
                return new Operator(TokenType.OR, tokenSource, beginOffset, endOffset);
            }
            case EXISTS: {
                return new Operator(TokenType.EXISTS, tokenSource, beginOffset, endOffset);
            }
            case EQUALS: {
                return new Operator(TokenType.EQUALS, tokenSource, beginOffset, endOffset);
            }
            case TIMES: {
                return new Operator(TokenType.TIMES, tokenSource, beginOffset, endOffset);
            }
            case NOT_EQUALS: {
                return new Operator(TokenType.NOT_EQUALS, tokenSource, beginOffset, endOffset);
            }
            case FALLBACK: {
                return new DirectiveName(TokenType.FALLBACK, tokenSource, beginOffset, endOffset);
            }
            case _RECOVER: {
                return new DirectiveName(TokenType._RECOVER, tokenSource, beginOffset, endOffset);
            }
            case IGNORED_WS: {
                return new IGNORED_WS(TokenType.IGNORED_WS, tokenSource, beginOffset, endOffset);
            }
            case OPEN_BRACKET: {
                return new Delimiter(TokenType.OPEN_BRACKET, tokenSource, beginOffset, endOffset);
            }
            case COLON: {
                return new Delimiter(TokenType.COLON, tokenSource, beginOffset, endOffset);
            }
            case ESCAPE: {
                return new DirectiveName(TokenType.ESCAPE, tokenSource, beginOffset, endOffset);
            }
            case DOUBLE_COLON: {
                return new Operator(TokenType.DOUBLE_COLON, tokenSource, beginOffset, endOffset);
            }
            case UNIFIED_CALL: {
                return new Delimiter(TokenType.UNIFIED_CALL, tokenSource, beginOffset, endOffset);
            }
            case GLOBALASSIGN: {
                return new DirectiveName(TokenType.GLOBALASSIGN, tokenSource, beginOffset, endOffset);
            }
            case VISIT: {
                return new DirectiveName(TokenType.VISIT, tokenSource, beginOffset, endOffset);
            }
            case NESTED: {
                return new DirectiveName(TokenType.NESTED, tokenSource, beginOffset, endOffset);
            }
            case FALSE: {
                return new BooleanLiteral(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case STRING_LITERAL: {
                return new StringLiteral(TokenType.STRING_LITERAL, tokenSource, beginOffset, endOffset);
            }
            case DIRECTIVE_END: {
                return new DIRECTIVE_ENDToken(TokenType.DIRECTIVE_END, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        ASSIGN,
        _ASSERT,
        CASE,
        ELSE_IF,
        EMBED,
        ESCAPE,
        EXEC,
        FOREACH,
        FTL_HEADER,
        FUNCTION,
        GLOBALASSIGN,
        IF,
        IMPORT,
        _INCLUDE,
        LIST,
        LOCALASSIGN,
        _MACRO,
        NESTED,
        RECURSE,
        RETURN,
        SET,
        SETTING,
        STOP,
        SWITCH,
        VAR,
        VISIT,
        EOL,
        FALSE,
        TRUE,
        NULL,
        DOT,
        DOT_DOT,
        DOUBLE_COLON,
        BUILT_IN,
        EXISTS,
        TERNARY,
        EQUALS,
        DOUBLE_EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        GREATER_THAN_EQUALS,
        PLUS,
        MINUS,
        TIMES,
        DOUBLE_STAR,
        ELLIPSIS,
        DIVIDE,
        PERCENT,
        EXCLAM,
        COMMA,
        SEMICOLON,
        COLON,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        OPEN_PAREN,
        CLOSE_PAREN,
        OPEN_BRACE,
        CLOSE_BRACE,
        IN,
        AS,
        USING,
        SQUARE_COMMENT,
        POINTY_COMMENT,
        SINGLE_LINE_COMMENT,
        START_TAG,
        CLOSE_DIRECTIVE_BLOCK,
        UNIFIED_CALL,
        UNIFIED_CALL_END,
        OUTPUT_ESCAPE,
        NOPARSE,
        TRAILING_WHITESPACE,
        NON_TRAILING_WHITESPACE,
        PROBLEMATIC_CHAR,
        POSSIBLE_DIRECTIVE,
        POSSIBLE_END_DIRECTIVE,
        REGULAR_PRINTABLE,
        _ATTEMPT,
        BREAK,
        DEFAUL,
        ELSE,
        FALLBACK,
        FLUSH,
        LTRIM,
        NOESCAPE,
        _RECOVER,
        RTRIM,
        TRIM,
        UNKNOWN_DIRECTIVE,
        IGNORED_WS,
        STRING_LITERAL,
        RAW_STRING,
        NUMBER,
        LESS_THAN,
        LESS_THAN_EQUALS,
        ESCAPED_GT,
        ESCAPED_GTE,
        AND,
        OR,
        EMPTY_DIRECTIVE_END,
        ID,
        DIRECTIVE_END,
        DUMMY,
        INVALID;


        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

