/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.parser.InvalidToken;
import freemarker.core.parser.Token;
import freemarker.core.parser.TokenSource;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;

public class FMLexer
extends TokenSource {
    private int hashLiteralNesting;
    private int parenthesisNesting;
    private int bracketNesting;
    private boolean inPointySyntax;
    private boolean onlyTextOutput;
    String templateName;
    private static EnumSet<Token.TokenType> directiveNames = EnumSet.of(Token.TokenType._ATTEMPT, new Token.TokenType[]{Token.TokenType._ASSERT, Token.TokenType._RECOVER, Token.TokenType.IF, Token.TokenType.ELSE_IF, Token.TokenType.EXEC, Token.TokenType.LIST, Token.TokenType.FOREACH, Token.TokenType.SWITCH, Token.TokenType.CASE, Token.TokenType.ASSIGN, Token.TokenType.GLOBALASSIGN, Token.TokenType.LOCALASSIGN, Token.TokenType.SET, Token.TokenType._INCLUDE, Token.TokenType.IMPORT, Token.TokenType.FUNCTION, Token.TokenType._MACRO, Token.TokenType.VISIT, Token.TokenType.STOP, Token.TokenType.RETURN, Token.TokenType.SETTING, Token.TokenType.EMBED, Token.TokenType.VAR, Token.TokenType.ELSE, Token.TokenType.BREAK, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.DEFAUL, Token.TokenType.NESTED, Token.TokenType.RECURSE, Token.TokenType.FALLBACK, Token.TokenType.ESCAPE, Token.TokenType.NOESCAPE, Token.TokenType.FTL_HEADER, Token.TokenType.UNKNOWN_DIRECTIVE});
    private static EnumSet<Token.TokenType> emptyDirectives = EnumSet.of(Token.TokenType._ATTEMPT, new Token.TokenType[]{Token.TokenType._RECOVER, Token.TokenType.ELSE, Token.TokenType.BREAK, Token.TokenType.FLUSH, Token.TokenType.TRIM, Token.TokenType.LTRIM, Token.TokenType.RTRIM, Token.TokenType.DEFAUL, Token.TokenType.FALLBACK, Token.TokenType.NOESCAPE});
    private static EnumSet<Token.TokenType> continueLineTokens = EnumSet.of(Token.TokenType.COMMA, new Token.TokenType[]{Token.TokenType.EQUALS, Token.TokenType.DOUBLE_EQUALS, Token.TokenType.NOT_EQUALS, Token.TokenType.DOT_DOT, Token.TokenType.GREATER_THAN, Token.TokenType.GREATER_THAN_EQUALS, Token.TokenType.LESS_THAN, Token.TokenType.LESS_THAN_EQUALS, Token.TokenType.ESCAPED_GT, Token.TokenType.ESCAPED_GTE, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.TIMES, Token.TokenType.DIVIDE, Token.TokenType.PERCENT, Token.TokenType.AND, Token.TokenType.OR, Token.TokenType.SEMICOLON, Token.TokenType.COLON, Token.TokenType.IN, Token.TokenType.AS, Token.TokenType.USING});
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
    private static final EnumMap<Token.TokenType, LexicalState> tokenTypeToLexicalStateMap;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap;

    public boolean isOnlyTextOutput() {
        return this.onlyTextOutput;
    }

    public void setOnlyTextOutput(boolean onlyTextOutput) {
        this.onlyTextOutput = onlyTextOutput;
    }

    private boolean atLineStart(Token tok) {
        char ch;
        for (int i = tok.getBeginOffset() - 1; i >= 0 && (ch = this.charAt(i)) != '\n'; --i) {
            if (Character.isWhitespace((int)ch)) continue;
            return false;
        }
        return true;
    }

    private boolean atLineEnd(Token tok) {
        char ch;
        for (int i = tok.getEndOffset(); i < this.length() && (ch = this.charAt(i)) != '\n'; ++i) {
            if (Character.isWhitespace((int)ch)) continue;
            return false;
        }
        return true;
    }

    private Token.TokenType directiveTypeFromString(String name) {
        switch (name) {
            case "#assert": {
                return Token.TokenType._ASSERT;
            }
            case "#assign": {
                return Token.TokenType.ASSIGN;
            }
            case "#attempt": {
                return Token.TokenType._ATTEMPT;
            }
            case "#break": {
                return Token.TokenType.BREAK;
            }
            case "#case": {
                return Token.TokenType.CASE;
            }
            case "#default": {
                return Token.TokenType.DEFAUL;
            }
            case "#embed": {
                return Token.TokenType.EMBED;
            }
            case "#escape": {
                return Token.TokenType.ESCAPE;
            }
            case "#else": {
                return Token.TokenType.ELSE;
            }
            case "#elseif": {
                return Token.TokenType.ELSE_IF;
            }
            case "#exec": {
                return Token.TokenType.EXEC;
            }
            case "#fallback": {
                return Token.TokenType.FALLBACK;
            }
            case "#flush": {
                return Token.TokenType.FLUSH;
            }
            case "#foreach": {
                return Token.TokenType.FOREACH;
            }
            case "#ftl": {
                return Token.TokenType.FTL_HEADER;
            }
            case "#function": {
                return Token.TokenType.FUNCTION;
            }
            case "#global": {
                return Token.TokenType.GLOBALASSIGN;
            }
            case "#if": {
                return Token.TokenType.IF;
            }
            case "#import": {
                return Token.TokenType.IMPORT;
            }
            case "#include": {
                return Token.TokenType._INCLUDE;
            }
            case "#list": {
                return Token.TokenType.LIST;
            }
            case "#local": {
                return Token.TokenType.LOCALASSIGN;
            }
            case "#macro": {
                return Token.TokenType._MACRO;
            }
            case "#nested": {
                return Token.TokenType.NESTED;
            }
            case "#noescape": {
                return Token.TokenType.NOESCAPE;
            }
            case "#recover": {
                return Token.TokenType._RECOVER;
            }
            case "#recurse": {
                return Token.TokenType.RECURSE;
            }
            case "#return": {
                return Token.TokenType.RETURN;
            }
            case "#set": {
                return Token.TokenType.SET;
            }
            case "#setting": {
                return Token.TokenType.SETTING;
            }
            case "#stop": {
                return Token.TokenType.STOP;
            }
            case "#switch": {
                return Token.TokenType.SWITCH;
            }
            case "#var": {
                return Token.TokenType.VAR;
            }
            case "#visit": {
                return Token.TokenType.VISIT;
            }
        }
        return Token.TokenType.UNKNOWN_DIRECTIVE;
    }

    private Token tokenHook$FMLexer_ccc$115$19(Token token) {
        Token.TokenType type = token.getType();
        if (type == Token.TokenType.POSSIBLE_DIRECTIVE) {
            if (!this.atLineStart(token)) {
                return token;
            }
            Token.TokenType directiveType = this.directiveTypeFromString(token.toString());
            if (emptyDirectives.contains(directiveType) && !this.atLineEnd(token)) {
                return token;
            }
            token.setType(directiveType);
            if (directiveType == Token.TokenType.UNKNOWN_DIRECTIVE) {
                return token;
            }
            if (!emptyDirectives.contains(directiveType)) {
                this.switchTo(LexicalState.EXPRESSION);
                this.activeTokenTypes.add(Token.TokenType.EOL);
            }
        } else if (type == Token.TokenType.POSSIBLE_END_DIRECTIVE) {
            if (!this.atLineStart(token) && !this.atLineEnd(token)) {
                return token;
            }
            token.setType(Token.TokenType.CLOSE_DIRECTIVE_BLOCK);
        } else if (type == Token.TokenType.EOL) {
            Token prevTok = token.previousCachedToken();
            if (this.parenthesisNesting > 0 || this.bracketNesting > 0 || this.hashLiteralNesting > 0 || prevTok != null && continueLineTokens.contains(prevTok.getType())) {
                token.setUnparsed(true);
            } else {
                token.setType(Token.TokenType.DIRECTIVE_END);
                this.activeTokenTypes.remove(Token.TokenType.EOL);
                this.switchTo(LexicalState.DEFAULT);
            }
        }
        return token;
    }

    private Token tokenHook$FMLexer_ccc$151$19(Token token) {
        if (directiveNames.contains(token.getType())) {
            boolean bl = this.inPointySyntax = token.charAt(0) == '<';
            if (emptyDirectives.contains(token.getType())) {
                this.switchTo(LexicalState.DEFAULT);
            } else {
                this.switchTo(LexicalState.EXPRESSION);
            }
        }
        switch (token.getType()) {
            case GREATER_THAN_EQUALS: 
            case GREATER_THAN: {
                if (this.parenthesisNesting != 0 || !this.inPointySyntax || this.activeTokenTypes.contains(Token.TokenType.EOL)) break;
                if (token.getType() == Token.TokenType.GREATER_THAN_EQUALS) {
                    token.truncate(1);
                }
                token.setType(Token.TokenType.DIRECTIVE_END);
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case OPEN_PAREN: {
                ++this.parenthesisNesting;
                break;
            }
            case CLOSE_PAREN: {
                --this.parenthesisNesting;
                break;
            }
            case OPEN_BRACKET: {
                ++this.bracketNesting;
                break;
            }
            case CLOSE_BRACKET: {
                if (this.bracketNesting > 0) {
                    --this.bracketNesting;
                    break;
                }
                if (this.activeTokenTypes.contains(Token.TokenType.EOL)) break;
                token.setType(Token.TokenType.DIRECTIVE_END);
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case OPEN_BRACE: {
                ++this.hashLiteralNesting;
                break;
            }
            case CLOSE_BRACE: {
                if (this.hashLiteralNesting > 0) {
                    --this.hashLiteralNesting;
                    break;
                }
                this.switchTo(LexicalState.DEFAULT);
                break;
            }
            case UNIFIED_CALL: {
                this.switchTo(LexicalState.EXPRESSION);
            }
        }
        return token;
    }

    public FMLexer(CharSequence input) {
        this("input", input);
    }

    public FMLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public FMLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        this.activeTokenTypes.remove(Token.TokenType.EOL);
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(234);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(234);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(234);
        BitSet nextStates = new BitSet(234);
        while (matchedToken == null) {
            NfaFunction[] nfaFunctions = functionTableMap.get((Object)lexicalState);
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = FMLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = FMLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            LexicalState newState = tokenTypeToLexicalStateMap.get(matchedType);
            if (newState != null) {
                lexicalState = this.lexicalState = newState;
            }
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        this.doLexicalStateSwitch(matchedToken.getType());
        matchedToken = this.tokenHook$FMLexer_ccc$115$19(matchedToken);
        matchedToken = this.tokenHook$FMLexer_ccc$151$19(matchedToken);
        return matchedToken;
    }

    boolean doLexicalStateSwitch(Token.TokenType tokenType) {
        LexicalState newState = tokenTypeToLexicalStateMap.get(tokenType);
        if (newState == null) {
            return false;
        }
        return this.switchTo(newState);
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        } else {
            this.doLexicalStateSwitch(t.getType());
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        tokenTypeToLexicalStateMap = new EnumMap(Token.TokenType.class);
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.ASSIGN, Token.TokenType._ASSERT, Token.TokenType.CASE, Token.TokenType.ELSE_IF, Token.TokenType.EMBED, Token.TokenType.ESCAPE, Token.TokenType.EXEC, Token.TokenType.FOREACH, Token.TokenType.FTL_HEADER, Token.TokenType.FUNCTION, Token.TokenType.GLOBALASSIGN, Token.TokenType.IF, Token.TokenType.IMPORT, Token.TokenType._INCLUDE, Token.TokenType.LIST, Token.TokenType.LOCALASSIGN, Token.TokenType._MACRO, Token.TokenType.NESTED, Token.TokenType.RECURSE, Token.TokenType.RETURN, Token.TokenType.SET, Token.TokenType.SETTING, Token.TokenType.STOP, Token.TokenType.SWITCH, Token.TokenType.VAR, Token.TokenType.VISIT, Token.TokenType.EOL, Token.TokenType.FALSE, Token.TokenType.TRUE, Token.TokenType.NULL, Token.TokenType.DOT, Token.TokenType.DOT_DOT, Token.TokenType.DOUBLE_COLON, Token.TokenType.BUILT_IN, Token.TokenType.EXISTS, Token.TokenType.TERNARY, Token.TokenType.EQUALS, Token.TokenType.DOUBLE_EQUALS, Token.TokenType.NOT_EQUALS, Token.TokenType.GREATER_THAN, Token.TokenType.GREATER_THAN_EQUALS, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.TIMES, Token.TokenType.DOUBLE_STAR, Token.TokenType.ELLIPSIS, Token.TokenType.DIVIDE, Token.TokenType.PERCENT, Token.TokenType.EXCLAM, Token.TokenType.COMMA, Token.TokenType.SEMICOLON, Token.TokenType.COLON, Token.TokenType.OPEN_BRACKET, Token.TokenType.CLOSE_BRACKET, Token.TokenType.OPEN_PAREN, Token.TokenType.CLOSE_PAREN, Token.TokenType.OPEN_BRACE, Token.TokenType.CLOSE_BRACE, Token.TokenType.IN, Token.TokenType.AS, Token.TokenType.USING, Token.TokenType.CLOSE_DIRECTIVE_BLOCK, Token.TokenType.UNIFIED_CALL, Token.TokenType.UNIFIED_CALL_END, Token.TokenType.OUTPUT_ESCAPE, Token.TokenType.NOPARSE, Token.TokenType.TRAILING_WHITESPACE, Token.TokenType.NON_TRAILING_WHITESPACE, Token.TokenType.PROBLEMATIC_CHAR, Token.TokenType.POSSIBLE_DIRECTIVE, Token.TokenType.POSSIBLE_END_DIRECTIVE, Token.TokenType.REGULAR_PRINTABLE, Token.TokenType._ATTEMPT, Token.TokenType.BREAK, Token.TokenType.DEFAUL, Token.TokenType.ELSE, Token.TokenType.FALLBACK, Token.TokenType.FLUSH, Token.TokenType.LTRIM, Token.TokenType.NOESCAPE, Token.TokenType._RECOVER, Token.TokenType.RTRIM, Token.TokenType.TRIM, Token.TokenType.UNKNOWN_DIRECTIVE, Token.TokenType.STRING_LITERAL, Token.TokenType.RAW_STRING, Token.TokenType.NUMBER, Token.TokenType.LESS_THAN, Token.TokenType.LESS_THAN_EQUALS, Token.TokenType.ESCAPED_GT, Token.TokenType.ESCAPED_GTE, Token.TokenType.AND, Token.TokenType.OR, Token.TokenType.EMPTY_DIRECTIVE_END, Token.TokenType.ID});
        unparsedTokens = EnumSet.of(Token.TokenType.SQUARE_COMMENT, Token.TokenType.POINTY_COMMENT, Token.TokenType.SINGLE_LINE_COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType.IGNORED_WS);
        moreTokens = EnumSet.of(Token.TokenType.START_TAG);
        regularTokens.add(Token.TokenType.DIRECTIVE_END);
        tokenTypeToLexicalStateMap.put(Token.TokenType.START_TAG, LexicalState.DIRECTIVE_NAME);
        tokenTypeToLexicalStateMap.put(Token.TokenType.OUTPUT_ESCAPE, LexicalState.EXPRESSION);
        tokenTypeToLexicalStateMap.put(Token.TokenType.EMPTY_DIRECTIVE_END, LexicalState.DEFAULT);
        functionTableMap = new EnumMap(LexicalState.class);
        DEFAULT.NFA_FUNCTIONS_init();
        EXPRESSION.NFA_FUNCTIONS_init();
        DIRECTIVE_NAME.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT,
        EXPRESSION,
        DIRECTIVE_NAME;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRAILING_WHITESPACE)) {
                    nextStates.set(22);
                }
            } else if (ch == 35) {
                if (validTypes == null || validTypes.contains(Token.TokenType.POSSIBLE_DIRECTIVE)) {
                    nextStates.set(4);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    nextStates.set(28);
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OUTPUT_ESCAPE)) {
                    nextStates.set(20);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NOPARSE)) {
                    nextStates.set(29);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.POSSIBLE_END_DIRECTIVE)) {
                    nextStates.set(12);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_DIRECTIVE_BLOCK)) {
                    nextStates.set(24);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.UNIFIED_CALL_END)) {
                    nextStates.set(26);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                    nextStates.set(57);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.START_TAG)) {
                    nextStates.set(17);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.UNIFIED_CALL)) {
                    nextStates.set(23);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOPARSE)) {
                    nextStates.set(69);
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNIFIED_CALL_END)) {
                    nextStates.set(26);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.UNIFIED_CALL)) {
                    nextStates.set(8);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.START_TAG)) {
                    nextStates.set(14);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                    nextStates.set(62);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_DIRECTIVE_BLOCK)) {
                    nextStates.set(67);
                }
            }
            if (ch >= 0 && ch <= 8 || ch >= 11 && ch <= 31 || ch >= 33 && ch <= 35 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92) {
                if (validTypes == null || validTypes.contains(Token.TokenType.REGULAR_PRINTABLE)) {
                    nextStates.set(15);
                    type = Token.TokenType.REGULAR_PRINTABLE;
                }
            } else if (ch == 36) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PROBLEMATIC_CHAR)) {
                    type = Token.TokenType.PROBLEMATIC_CHAR;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PROBLEMATIC_CHAR)) {
                    type = Token.TokenType.PROBLEMATIC_CHAR;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PROBLEMATIC_CHAR)) {
                    type = Token.TokenType.PROBLEMATIC_CHAR;
                }
            } else if (ch == 9 || ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NON_TRAILING_WHITESPACE)) {
                    nextStates.set(3);
                    type = Token.TokenType.NON_TRAILING_WHITESPACE;
                }
            } else if (ch == 10 && (validTypes == null || validTypes.contains(Token.TokenType.TRAILING_WHITESPACE))) {
                type = Token.TokenType.TRAILING_WHITESPACE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(2);
            } else if (ch >= 97 && ch <= 122) {
                nextStates.set(1);
            } else if (ch == 62) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(2);
            } else if (ch == 62) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 9 || ch == 32) {
                nextStates.set(3);
                return Token.TokenType.NON_TRAILING_WHITESPACE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(4);
                return Token.TokenType.POSSIBLE_DIRECTIVE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch == 11 || ch == 12 || ch >= 14 && ch <= 31 || ch >= 33 && ch <= 61 || ch >= 63 && ch <= 92 || ch >= 94) {
                nextStates.set(5);
            } else if (ch == 62) {
                type = Token.TokenType.UNIFIED_CALL_END;
            } else if (ch == 93) {
                type = Token.TokenType.UNIFIED_CALL_END;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(7);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(7);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 64) {
                return Token.TokenType.UNIFIED_CALL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(9);
            } else if (ch == 93) {
                type = Token.TokenType.NOPARSE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(10);
            } else if (ch == 62) {
                type = Token.TokenType.NOPARSE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 62) {
                return Token.TokenType.POINTY_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 35) {
                nextStates.set(13);
                return Token.TokenType.POSSIBLE_END_DIRECTIVE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(13);
                return Token.TokenType.POSSIBLE_END_DIRECTIVE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 35) {
                return Token.TokenType.START_TAG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 8 || ch >= 11 && ch <= 31 || ch >= 33 && ch <= 35 || ch >= 37 && ch <= 59 || ch >= 61 && ch <= 90 || ch >= 92) {
                nextStates.set(15);
                return Token.TokenType.REGULAR_PRINTABLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 93) {
                return Token.TokenType.SQUARE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 35) {
                return Token.TokenType.START_TAG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(19);
            } else if (ch >= 97 && ch <= 122) {
                nextStates.set(18);
            } else if (ch == 93) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(19);
            } else if (ch == 93) {
                type = Token.TokenType.CLOSE_DIRECTIVE_BLOCK;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 92) {
                nextStates.set(21);
            } else if (ch == 123) {
                type = Token.TokenType.OUTPUT_ESCAPE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 123) {
                return Token.TokenType.OUTPUT_ESCAPE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 32) {
                nextStates.set(22);
            } else if (ch == 10) {
                type = Token.TokenType.TRAILING_WHITESPACE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 64) {
                return Token.TokenType.UNIFIED_CALL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 35) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(27);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 64) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 110) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 111) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 112) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 97) {
                nextStates.set(34);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 114) {
                nextStates.set(35);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 115) {
                nextStates.set(36);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 101) {
                nextStates.set(37);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(37);
            } else if (ch == 93) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(38);
            }
            if (ch == 60) {
                nextStates.set(48);
            } else if (ch == 91) {
                nextStates.set(39);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 47) {
                nextStates.set(40);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 110) {
                nextStates.set(42);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 111) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 112) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 97) {
                nextStates.set(45);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 114) {
                nextStates.set(46);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 115) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 101) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 47) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(50);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 110) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 111) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 112) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 97) {
                nextStates.set(54);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 114) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 115) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 101) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(59);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(60);
            }
            if (ch == 45) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(65);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(65);
            }
            if (ch == 45) {
                nextStates.set(66);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 35) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 110) {
                nextStates.set(71);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 111) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 112) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 97) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 114) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 115) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 101) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.NOPARSE)) {
                return null;
            }
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(77);
            } else if (ch == 62) {
                nextStates.set(38);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77};
            functionTableMap.put(LexicalState.DEFAULT, functions);
        }
    }

    private static class EXPRESSION {
        private static final int[] NFA_MOVES_EXPRESSION_156 = EXPRESSION.NFA_MOVES_EXPRESSION_156_init();
        private static final int[] NFA_MOVES_EXPRESSION_158 = EXPRESSION.NFA_MOVES_EXPRESSION_158_init();

        private EXPRESSION() {
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NOT_EQUALS)) {
                    nextStates.set(27);
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(5);
                }
            } else if (ch == 35) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SINGLE_LINE_COMMENT)) {
                    nextStates.set(53);
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GTE)) {
                    nextStates.set(49);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.AND)) {
                    nextStates.set(21);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GT)) {
                    nextStates.set(67);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN)) {
                    nextStates.set(69);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN_EQUALS)) {
                    nextStates.set(79);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING_LITERAL)) {
                    nextStates.set(34);
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_STAR)) {
                    nextStates.set(8);
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ELLIPSIS)) {
                    nextStates.set(42);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT_DOT)) {
                    nextStates.set(39);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EMPTY_DIRECTIVE_END)) {
                    nextStates.set(19);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EMPTY_DIRECTIVE_END)) {
                    nextStates.set(31);
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_COLON)) {
                    nextStates.set(9);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                    nextStates.set(73);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN_EQUALS)) {
                    nextStates.set(41);
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE_EQUALS)) {
                    nextStates.set(17);
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GREATER_THAN_EQUALS)) {
                    nextStates.set(15);
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TERNARY)) {
                    nextStates.set(13);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXISTS)) {
                    nextStates.set(35);
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                    nextStates.set(43);
                }
            } else if (ch == 92) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GTE)) {
                    nextStates.set(57);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GT)) {
                    nextStates.set(82);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AS)) {
                    nextStates.set(23);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(54);
                }
            } else if (ch == 103) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GT)) {
                    nextStates.set(10);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPED_GTE)) {
                    nextStates.set(59);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IN)) {
                    nextStates.set(37);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN_EQUALS)) {
                    nextStates.set(62);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN)) {
                    nextStates.set(38);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NULL)) {
                    nextStates.set(60);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RAW_STRING)) {
                    nextStates.set(66);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(71);
                }
            } else if (ch == 117) {
                if (validTypes == null || validTypes.contains(Token.TokenType.USING)) {
                    nextStates.set(63);
                }
            } else if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.OR))) {
                nextStates.set(28);
            }
            if (ch == 36 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_EXPRESSION_156, ch)) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ID)) {
                    nextStates.set(7);
                    type = Token.TokenType.ID;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ID)) {
                    nextStates.set(7);
                    type = Token.TokenType.ID;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OR)) {
                    type = Token.TokenType.OR;
                }
            } else if (ch == 38) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AND)) {
                    type = Token.TokenType.AND;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LESS_THAN)) {
                    type = Token.TokenType.LESS_THAN;
                }
            } else if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NUMBER)) {
                    nextStates.set(52);
                    type = Token.TokenType.NUMBER;
                }
            } else if (ch >= 49 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NUMBER)) {
                    nextStates.set(1);
                    type = Token.TokenType.NUMBER;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IGNORED_WS)) {
                    type = Token.TokenType.IGNORED_WS;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IGNORED_WS)) {
                    type = Token.TokenType.IGNORED_WS;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IGNORED_WS)) {
                    type = Token.TokenType.IGNORED_WS;
                }
            } else if (ch == 32) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IGNORED_WS)) {
                    type = Token.TokenType.IGNORED_WS;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_BRACE)) {
                    type = Token.TokenType.CLOSE_BRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPEN_BRACE)) {
                    type = Token.TokenType.OPEN_BRACE;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_PAREN)) {
                    type = Token.TokenType.CLOSE_PAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPEN_PAREN)) {
                    type = Token.TokenType.OPEN_PAREN;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CLOSE_BRACKET)) {
                    type = Token.TokenType.CLOSE_BRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPEN_BRACKET)) {
                    type = Token.TokenType.OPEN_BRACKET;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SEMICOLON)) {
                    type = Token.TokenType.SEMICOLON;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXCLAM)) {
                    type = Token.TokenType.EXCLAM;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PERCENT)) {
                    type = Token.TokenType.PERCENT;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DIVIDE)) {
                    type = Token.TokenType.DIVIDE;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TIMES)) {
                    type = Token.TokenType.TIMES;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GREATER_THAN)) {
                    type = Token.TokenType.GREATER_THAN;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EQUALS)) {
                    type = Token.TokenType.EQUALS;
                }
            } else if (ch == 63) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BUILT_IN)) {
                    type = Token.TokenType.BUILT_IN;
                }
            } else if (ch == 46 && (validTypes == null || validTypes.contains(Token.TokenType.DOT))) {
                type = Token.TokenType.DOT;
            }
            if (ch == 10 && (validTypes == null || validTypes.contains(Token.TokenType.EOL))) {
                type = Token.TokenType.EOL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(2);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
                type = Token.TokenType.NUMBER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
                return Token.TokenType.NUMBER;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                return Token.TokenType.ELLIPSIS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 93) {
                return Token.TokenType.SQUARE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(5);
            } else if (ch == 92) {
                nextStates.set(48);
            } else if (ch == 34) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.ESCAPED_GTE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 8 || ch >= 14 && ch <= 27 || ch == 36 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122 || ch >= 127 && ch <= 159 || ch >= 128 && TokenSource.checkIntervals(NFA_MOVES_EXPRESSION_158, ch)) {
                nextStates.set(7);
                type = Token.TokenType.ID;
            } else if (ch == 64) {
                nextStates.set(7);
                type = Token.TokenType.ID;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 42) {
                return Token.TokenType.DOUBLE_STAR;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                return Token.TokenType.DOUBLE_COLON;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.ESCAPED_GT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(12);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch >= 11) {
                nextStates.set(12);
                return Token.TokenType.SINGLE_LINE_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 58) {
                return Token.TokenType.TERNARY;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.GREATER_THAN_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ESCAPED_GTE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.DOUBLE_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ESCAPED_GTE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 62) {
                return Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.NULL;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 38) {
                return Token.TokenType.AND;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LESS_THAN_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.AS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.USING;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(25);
            } else if (ch == 34) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(26);
            } else if (ch == 39) {
                type = Token.TokenType.RAW_STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.NOT_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 124) {
                return Token.TokenType.OR;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 59) {
                return Token.TokenType.ESCAPED_GT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 59) {
                return Token.TokenType.LESS_THAN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 93) {
                return Token.TokenType.EMPTY_DIRECTIVE_END;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 62) {
                return Token.TokenType.POINTY_COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(34);
            } else if (ch == 92) {
                nextStates.set(78);
            } else if (ch == 39) {
                type = Token.TokenType.STRING_LITERAL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 63) {
                return Token.TokenType.EXISTS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.LESS_THAN_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.IN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.LESS_THAN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                return Token.TokenType.DOT_DOT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.ESCAPED_GT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.LESS_THAN_EQUALS;
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(45);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(46);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(46);
            }
            if (ch == 45) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.SQUARE_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(4);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(50);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 59) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(22);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(65);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(25);
            } else if (ch == 39) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(29);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 35) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch >= 0) {
                nextStates.set(76);
            }
            if (ch == 45) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (alreadyMatchedTypes.contains(Token.TokenType.POINTY_COMMENT)) {
                return null;
            }
            if (ch == 45) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0) {
                nextStates.set(34);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 59) {
                nextStates.set(36);
            }
            return null;
        }

        private static Token.TokenType getNfaNameEXPRESSIONIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(40);
            }
            return null;
        }

        private static int[] NFA_MOVES_EXPRESSION_156_init() {
            return new int[]{36, 36, 65, 90, 95, 95, 97, 122, 162, 165, 170, 170, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 880, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1488, 1514, 1519, 1522, 1547, 1547, 1568, 1610, 1646, 1647, 1649, 1747, 1749, 1749, 1765, 1766, 1774, 1775, 1786, 1788, 1791, 1791, 1808, 1808, 1810, 1839, 1869, 1957, 1969, 1969, 1994, 2026, 2036, 2037, 2042, 2042, 2046, 2069, 2074, 2074, 2084, 2084, 2088, 2088, 2112, 2136, 2144, 2154, 2160, 2183, 2185, 2190, 2208, 2249, 2308, 2361, 2365, 2365, 2384, 2384, 2392, 2401, 2417, 2432, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2493, 2493, 2510, 2510, 2524, 2525, 2527, 2529, 2544, 2547, 2555, 2556, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2649, 2652, 2654, 2654, 2674, 2676, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2749, 2749, 2768, 2768, 2784, 2785, 2801, 2801, 2809, 2809, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2877, 2877, 2908, 2909, 2911, 2913, 2929, 2929, 2947, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3024, 3024, 3065, 3065, 3077, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3133, 3133, 3160, 3162, 3165, 3165, 3168, 3169, 3200, 3200, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3261, 3261, 3293, 3294, 3296, 3297, 3313, 3314, 3332, 3340, 3342, 3344, 3346, 3386, 3389, 3389, 3406, 3406, 3412, 3414, 3423, 3425, 3450, 3455, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3585, 3632, 3634, 3635, 3647, 3654, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3760, 3762, 3763, 3773, 3773, 3776, 3780, 3782, 3782, 3804, 3807, 3840, 3840, 3904, 3911, 3913, 3948, 3976, 3980, 4096, 4138, 4159, 4159, 4176, 4181, 4186, 4189, 4193, 4193, 4197, 4198, 4206, 4208, 4213, 4225, 4238, 4238, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5905, 5919, 5937, 5952, 5969, 5984, 5996, 5998, 6000, 6016, 6067, 6103, 6103, 6107, 6108, 6176, 6264, 6272, 6276, 6279, 6312, 6314, 6314, 6320, 6389, 6400, 6430, 6480, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6656, 6678, 6688, 6740, 6823, 6823, 6917, 6963, 6981, 6988, 7043, 7072, 7086, 7087, 7098, 7141, 7168, 7203, 7245, 7247, 7258, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7401, 7404, 7406, 7411, 7413, 7414, 7418, 7418, 7424, 7615, 7680, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8255, 8256, 8276, 8276, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11502, 11506, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11648, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11823, 11823, 12293, 12295, 12321, 12329, 12337, 12341, 12344, 12348, 12353, 12438, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42527, 42538, 42539, 42560, 42606, 42623, 42653, 42656, 42735, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43009, 43011, 43013, 43015, 43018, 43020, 43042, 43064, 43064, 43072, 43123, 43138, 43187, 43250, 43255, 43259, 43259, 43261, 43262, 43274, 43301, 43312, 43334, 43360, 43388, 43396, 43442, 43471, 43471, 43488, 43492, 43494, 43503, 43514, 43518, 43520, 43560, 43584, 43586, 43588, 43595, 43616, 43638, 43642, 43642, 43646, 43695, 43697, 43697, 43701, 43702, 43705, 43709, 43712, 43712, 43714, 43714, 43739, 43741, 43744, 43754, 43762, 43764, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44002, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64285, 64287, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65284, 65284, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66176, 66204, 66208, 66256, 66304, 66335, 66349, 66378, 66384, 66421, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68096, 68112, 68115, 68117, 68119, 68121, 68149, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68324, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68899, 69248, 69289, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69445, 69488, 69505, 69552, 69572, 69600, 69622, 69635, 69687, 69745, 69746, 69749, 69749, 69763, 69807, 69840, 69864, 69891, 69926, 69956, 69956, 69959, 69959, 69968, 70002, 70006, 70006, 70019, 70066, 70081, 70084, 70106, 70106, 70108, 70108, 70144, 70161, 70163, 70187, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70366, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70461, 70461, 70480, 70480, 70493, 70497, 70656, 70708, 70727, 70730, 70751, 70753, 70784, 70831, 70852, 70853, 70855, 70855, 71040, 71086, 71128, 71131, 71168, 71215, 71236, 71236, 71296, 71338, 71352, 71352, 71424, 71450, 71488, 71494, 71680, 71723, 71840, 71903, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71983, 71999, 71999, 72001, 72001, 72096, 72103, 72106, 72144, 72161, 72161, 72163, 72163, 72192, 72192, 72203, 72242, 72250, 72250, 72272, 72272, 72284, 72329, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72750, 72768, 72768, 72818, 72847, 72960, 72966, 72968, 72969, 72971, 73008, 73030, 73030, 73056, 73061, 73063, 73064, 73066, 73097, 73112, 73112, 73440, 73458, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 82944, 83526, 92160, 92728, 92736, 92766, 92784, 92862, 92880, 92909, 92928, 92975, 92992, 92995, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94032, 94032, 94099, 94111, 94176, 94177, 94179, 94179, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 122624, 122654, 123136, 123180, 123191, 123197, 123214, 123214, 123536, 123565, 123584, 123627, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125184, 125251, 125259, 125259, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546};
        }

        private static int[] NFA_MOVES_EXPRESSION_158_init() {
            return new int[]{0, 8, 14, 27, 36, 36, 48, 57, 65, 90, 95, 95, 97, 122, 127, 159, 162, 165, 170, 170, 173, 173, 181, 181, 186, 186, 192, 214, 216, 246, 248, 705, 710, 721, 736, 740, 748, 748, 750, 750, 768, 884, 886, 887, 890, 893, 895, 895, 902, 902, 904, 906, 908, 908, 910, 929, 931, 1013, 1015, 1153, 1155, 1159, 1162, 1327, 1329, 1366, 1369, 1369, 1376, 1416, 1423, 1423, 1425, 1469, 1471, 1471, 1473, 1474, 1476, 1477, 1479, 1479, 1488, 1514, 1519, 1522, 1536, 1541, 1547, 1547, 1552, 1562, 1564, 1564, 1568, 1641, 1646, 1747, 1749, 1757, 1759, 1768, 1770, 1788, 1791, 1791, 1807, 1866, 1869, 1969, 1984, 2037, 2042, 2042, 2045, 2093, 2112, 2139, 2144, 2154, 2160, 2183, 2185, 2190, 2192, 2193, 2200, 2403, 2406, 2415, 2417, 2435, 2437, 2444, 2447, 2448, 2451, 2472, 2474, 2480, 2482, 2482, 2486, 2489, 2492, 2500, 2503, 2504, 2507, 2510, 2519, 2519, 2524, 2525, 2527, 2531, 2534, 2547, 2555, 2556, 2558, 2558, 2561, 2563, 2565, 2570, 2575, 2576, 2579, 2600, 2602, 2608, 2610, 2611, 2613, 2614, 2616, 2617, 2620, 2620, 2622, 2626, 2631, 2632, 2635, 2637, 2641, 2641, 2649, 2652, 2654, 2654, 2662, 2677, 2689, 2691, 2693, 2701, 2703, 2705, 2707, 2728, 2730, 2736, 2738, 2739, 2741, 2745, 2748, 2757, 2759, 2761, 2763, 2765, 2768, 2768, 2784, 2787, 2790, 2799, 2801, 2801, 2809, 2815, 2817, 2819, 2821, 2828, 2831, 2832, 2835, 2856, 2858, 2864, 2866, 2867, 2869, 2873, 2876, 2884, 2887, 2888, 2891, 2893, 2901, 2903, 2908, 2909, 2911, 2915, 2918, 2927, 2929, 2929, 2946, 2947, 2949, 2954, 2958, 2960, 2962, 2965, 2969, 2970, 2972, 2972, 2974, 2975, 2979, 2980, 2984, 2986, 2990, 3001, 3006, 3010, 3014, 3016, 3018, 3021, 3024, 3024, 3031, 3031, 3046, 3055, 3065, 3065, 3072, 3084, 3086, 3088, 3090, 3112, 3114, 3129, 3132, 3140, 3142, 3144, 3146, 3149, 3157, 3158, 3160, 3162, 3165, 3165, 3168, 3171, 3174, 3183, 3200, 3203, 3205, 3212, 3214, 3216, 3218, 3240, 3242, 3251, 3253, 3257, 3260, 3268, 3270, 3272, 3274, 3277, 3285, 3286, 3293, 3294, 3296, 3299, 3302, 3311, 3313, 3314, 3328, 3340, 3342, 3344, 3346, 3396, 3398, 3400, 3402, 3406, 3412, 3415, 3423, 3427, 3430, 3439, 3450, 3455, 3457, 3459, 3461, 3478, 3482, 3505, 3507, 3515, 3517, 3517, 3520, 3526, 3530, 3530, 3535, 3540, 3542, 3542, 3544, 3551, 3558, 3567, 3570, 3571, 3585, 3642, 3647, 3662, 3664, 3673, 3713, 3714, 3716, 3716, 3718, 3722, 3724, 3747, 3749, 3749, 3751, 3773, 3776, 3780, 3782, 3782, 3784, 3789, 3792, 3801, 3804, 3807, 3840, 3840, 3864, 3865, 3872, 3881, 3893, 3893, 3895, 3895, 3897, 3897, 3902, 3911, 3913, 3948, 3953, 3972, 3974, 3991, 3993, 4028, 4038, 4038, 4096, 4169, 4176, 4253, 4256, 4293, 4295, 4295, 4301, 4301, 4304, 4346, 4348, 4680, 4682, 4685, 4688, 4694, 4696, 4696, 4698, 4701, 4704, 4744, 4746, 4749, 4752, 4784, 4786, 4789, 4792, 4798, 4800, 4800, 4802, 4805, 4808, 4822, 4824, 4880, 4882, 4885, 4888, 4954, 4957, 4959, 4992, 5007, 5024, 5109, 5112, 5117, 5121, 5740, 5743, 5759, 5761, 5786, 5792, 5866, 5870, 5880, 5888, 5909, 5919, 5940, 5952, 5971, 5984, 5996, 5998, 6000, 6002, 6003, 6016, 6099, 6103, 6103, 6107, 6109, 6112, 6121, 6155, 6169, 6176, 6264, 6272, 6314, 6320, 6389, 6400, 6430, 6432, 6443, 6448, 6459, 6470, 6509, 6512, 6516, 6528, 6571, 6576, 6601, 6608, 6617, 6656, 6683, 6688, 6750, 6752, 6780, 6783, 6793, 6800, 6809, 6823, 6823, 6832, 6845, 6847, 6862, 6912, 6988, 6992, 7001, 7019, 7027, 7040, 7155, 7168, 7223, 7232, 7241, 7245, 7293, 7296, 7304, 7312, 7354, 7357, 7359, 7376, 7378, 7380, 7418, 7424, 7957, 7960, 7965, 7968, 8005, 8008, 8013, 8016, 8023, 8025, 8025, 8027, 8027, 8029, 8029, 8031, 8061, 8064, 8116, 8118, 8124, 8126, 8126, 8130, 8132, 8134, 8140, 8144, 8147, 8150, 8155, 8160, 8172, 8178, 8180, 8182, 8188, 8203, 8207, 8234, 8238, 8255, 8256, 8276, 8276, 8288, 8292, 8294, 8303, 8305, 8305, 8319, 8319, 8336, 8348, 8352, 8384, 8400, 8412, 8417, 8417, 8421, 8432, 8450, 8450, 8455, 8455, 8458, 8467, 8469, 8469, 8473, 8477, 8484, 8484, 8486, 8486, 8488, 8488, 8490, 8493, 8495, 8505, 8508, 8511, 8517, 8521, 8526, 8526, 8544, 8584, 11264, 11492, 11499, 11507, 11520, 11557, 11559, 11559, 11565, 11565, 11568, 11623, 11631, 11631, 11647, 11670, 11680, 11686, 11688, 11694, 11696, 11702, 11704, 11710, 11712, 11718, 11720, 11726, 11728, 11734, 11736, 11742, 11744, 11775, 11823, 11823, 12293, 12295, 12321, 12335, 12337, 12341, 12344, 12348, 12353, 12438, 12441, 12442, 12445, 12447, 12449, 12538, 12540, 12543, 12549, 12591, 12593, 12686, 12704, 12735, 12784, 12799, 13312, 19903, 19968, 42124, 42192, 42237, 42240, 42508, 42512, 42539, 42560, 42607, 42612, 42621, 42623, 42737, 42775, 42783, 42786, 42888, 42891, 42954, 42960, 42961, 42963, 42963, 42965, 42969, 42994, 43047, 43052, 43052, 43064, 43064, 43072, 43123, 43136, 43205, 43216, 43225, 43232, 43255, 43259, 43259, 43261, 43309, 43312, 43347, 43360, 43388, 43392, 43456, 43471, 43481, 43488, 43518, 43520, 43574, 43584, 43597, 43600, 43609, 43616, 43638, 43642, 43714, 43739, 43741, 43744, 43759, 43762, 43766, 43777, 43782, 43785, 43790, 43793, 43798, 43808, 43814, 43816, 43822, 43824, 43866, 43868, 43881, 43888, 44010, 44012, 44013, 44016, 44025, 44032, 55203, 55216, 55238, 55243, 55291, 63744, 64109, 64112, 64217, 64256, 64262, 64275, 64279, 64285, 64296, 64298, 64310, 64312, 64316, 64318, 64318, 64320, 64321, 64323, 64324, 64326, 64433, 64467, 64829, 64848, 64911, 64914, 64967, 65008, 65020, 65024, 65039, 65056, 65071, 65075, 65076, 65101, 65103, 65129, 65129, 65136, 65140, 65142, 65276, 65279, 65279, 65284, 65284, 65296, 65305, 65313, 65338, 65343, 65343, 65345, 65370, 65382, 65470, 65474, 65479, 65482, 65487, 65490, 65495, 65498, 65500, 65504, 65505, 65509, 65510, 65529, 65531, 65536, 65547, 65549, 65574, 65576, 65594, 65596, 65597, 65599, 65613, 65616, 65629, 65664, 65786, 65856, 65908, 66045, 66045, 66176, 66204, 66208, 66256, 66272, 66272, 66304, 66335, 66349, 66378, 66384, 66426, 66432, 66461, 66464, 66499, 66504, 66511, 66513, 66517, 66560, 66717, 66720, 66729, 66736, 66771, 66776, 66811, 66816, 66855, 66864, 66915, 66928, 66938, 66940, 66954, 66956, 66962, 66964, 66965, 66967, 66977, 66979, 66993, 66995, 67001, 67003, 67004, 67072, 67382, 67392, 67413, 67424, 67431, 67456, 67461, 67463, 67504, 67506, 67514, 67584, 67589, 67592, 67592, 67594, 67637, 67639, 67640, 67644, 67644, 67647, 67669, 67680, 67702, 67712, 67742, 67808, 67826, 67828, 67829, 67840, 67861, 67872, 67897, 67968, 68023, 68030, 68031, 68096, 68099, 68101, 68102, 68108, 68115, 68117, 68119, 68121, 68149, 68152, 68154, 68159, 68159, 68192, 68220, 68224, 68252, 68288, 68295, 68297, 68326, 68352, 68405, 68416, 68437, 68448, 68466, 68480, 68497, 68608, 68680, 68736, 68786, 68800, 68850, 68864, 68903, 68912, 68921, 69248, 69289, 69291, 69292, 69296, 69297, 69376, 69404, 69415, 69415, 69424, 69456, 69488, 69509, 69552, 69572, 69600, 69622, 69632, 69702, 69734, 69749, 69759, 69818, 69821, 69821, 69826, 69826, 69837, 69837, 69840, 69864, 69872, 69881, 69888, 69940, 69942, 69951, 69956, 69959, 69968, 70003, 70006, 70006, 70016, 70084, 70089, 70092, 70094, 70106, 70108, 70108, 70144, 70161, 70163, 70199, 70206, 70206, 70272, 70278, 70280, 70280, 70282, 70285, 70287, 70301, 70303, 70312, 70320, 70378, 70384, 70393, 70400, 70403, 70405, 70412, 70415, 70416, 70419, 70440, 70442, 70448, 70450, 70451, 70453, 70457, 70459, 70468, 70471, 70472, 70475, 70477, 70480, 70480, 70487, 70487, 70493, 70499, 70502, 70508, 70512, 70516, 70656, 70730, 70736, 70745, 70750, 70753, 70784, 70853, 70855, 70855, 70864, 70873, 71040, 71093, 71096, 71104, 71128, 71133, 71168, 71232, 71236, 71236, 71248, 71257, 71296, 71352, 71360, 71369, 71424, 71450, 71453, 71467, 71472, 71481, 71488, 71494, 71680, 71738, 71840, 71913, 71935, 71942, 71945, 71945, 71948, 71955, 71957, 71958, 71960, 71989, 71991, 71992, 71995, 72003, 72016, 72025, 72096, 72103, 72106, 72151, 72154, 72161, 72163, 72164, 72192, 72254, 72263, 72263, 72272, 72345, 72349, 72349, 72368, 72440, 72704, 72712, 72714, 72758, 72760, 72768, 72784, 72793, 72818, 72847, 72850, 72871, 72873, 72886, 72960, 72966, 72968, 72969, 72971, 73014, 73018, 73018, 73020, 73021, 73023, 73031, 73040, 73049, 73056, 73061, 73063, 73064, 73066, 73102, 73104, 73105, 73107, 73112, 73120, 73129, 73440, 73462, 73648, 73648, 73693, 73696, 73728, 74649, 74752, 74862, 74880, 75075, 77712, 77808, 77824, 78894, 78896, 78904, 82944, 83526, 92160, 92728, 92736, 92766, 92768, 92777, 92784, 92862, 92864, 92873, 92880, 92909, 92912, 92916, 92928, 92982, 92992, 92995, 93008, 93017, 93027, 93047, 93053, 93071, 93760, 93823, 93952, 94026, 94031, 94087, 94095, 94111, 94176, 94177, 94179, 94180, 94192, 94193, 94208, 100343, 100352, 101589, 101632, 101640, 110576, 110579, 110581, 110587, 110589, 110590, 110592, 110882, 110928, 110930, 110948, 110951, 110960, 111355, 113664, 113770, 113776, 113788, 113792, 113800, 113808, 113817, 113821, 113822, 113824, 113827, 118528, 118573, 118576, 118598, 119141, 119145, 119149, 119170, 119173, 119179, 119210, 119213, 119362, 119364, 119808, 119892, 119894, 119964, 119966, 119967, 119970, 119970, 119973, 119974, 119977, 119980, 119982, 119993, 119995, 119995, 119997, 120003, 120005, 120069, 120071, 120074, 120077, 120084, 120086, 120092, 120094, 120121, 120123, 120126, 120128, 120132, 120134, 120134, 120138, 120144, 120146, 120485, 120488, 120512, 120514, 120538, 120540, 120570, 120572, 120596, 120598, 120628, 120630, 120654, 120656, 120686, 120688, 120712, 120714, 120744, 120746, 120770, 120772, 120779, 120782, 120831, 121344, 121398, 121403, 121452, 121461, 121461, 121476, 121476, 121499, 121503, 121505, 121519, 122624, 122654, 122880, 122886, 122888, 122904, 122907, 122913, 122915, 122916, 122918, 122922, 123136, 123180, 123184, 123197, 123200, 123209, 123214, 123214, 123536, 123566, 123584, 123641, 123647, 123647, 124896, 124902, 124904, 124907, 124909, 124910, 124912, 124926, 124928, 125124, 125136, 125142, 125184, 125259, 125264, 125273, 126128, 126128, 126464, 126467, 126469, 126495, 126497, 126498, 126500, 126500, 126503, 126503, 126505, 126514, 126516, 126519, 126521, 126521, 126523, 126523, 126530, 126530, 126535, 126535, 126537, 126537, 126539, 126539, 126541, 126543, 126545, 126546, 126548, 126548, 126551, 126551, 126553, 126553, 126555, 126555, 126557, 126557, 126559, 126559, 126561, 126562, 126564, 126564, 126567, 126570, 126572, 126578, 126580, 126583, 126585, 126588, 126590, 126590, 126592, 126601, 126603, 126619, 126625, 126627, 126629, 126633, 126635, 126651, 130032, 130041, 131072, 173791, 173824, 177976, 177984, 178205, 178208, 183969, 183984, 191456, 194560, 195101, 196608, 201546, 917505, 917505, 917536, 917631, 917760, 917999};
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{EXPRESSION::getNfaNameEXPRESSIONIndex0, EXPRESSION::getNfaNameEXPRESSIONIndex1, EXPRESSION::getNfaNameEXPRESSIONIndex2, EXPRESSION::getNfaNameEXPRESSIONIndex3, EXPRESSION::getNfaNameEXPRESSIONIndex4, EXPRESSION::getNfaNameEXPRESSIONIndex5, EXPRESSION::getNfaNameEXPRESSIONIndex6, EXPRESSION::getNfaNameEXPRESSIONIndex7, EXPRESSION::getNfaNameEXPRESSIONIndex8, EXPRESSION::getNfaNameEXPRESSIONIndex9, EXPRESSION::getNfaNameEXPRESSIONIndex10, EXPRESSION::getNfaNameEXPRESSIONIndex11, EXPRESSION::getNfaNameEXPRESSIONIndex12, EXPRESSION::getNfaNameEXPRESSIONIndex13, EXPRESSION::getNfaNameEXPRESSIONIndex14, EXPRESSION::getNfaNameEXPRESSIONIndex15, EXPRESSION::getNfaNameEXPRESSIONIndex16, EXPRESSION::getNfaNameEXPRESSIONIndex17, EXPRESSION::getNfaNameEXPRESSIONIndex18, EXPRESSION::getNfaNameEXPRESSIONIndex19, EXPRESSION::getNfaNameEXPRESSIONIndex20, EXPRESSION::getNfaNameEXPRESSIONIndex21, EXPRESSION::getNfaNameEXPRESSIONIndex22, EXPRESSION::getNfaNameEXPRESSIONIndex23, EXPRESSION::getNfaNameEXPRESSIONIndex24, EXPRESSION::getNfaNameEXPRESSIONIndex25, EXPRESSION::getNfaNameEXPRESSIONIndex26, EXPRESSION::getNfaNameEXPRESSIONIndex27, EXPRESSION::getNfaNameEXPRESSIONIndex28, EXPRESSION::getNfaNameEXPRESSIONIndex29, EXPRESSION::getNfaNameEXPRESSIONIndex30, EXPRESSION::getNfaNameEXPRESSIONIndex31, EXPRESSION::getNfaNameEXPRESSIONIndex32, EXPRESSION::getNfaNameEXPRESSIONIndex33, EXPRESSION::getNfaNameEXPRESSIONIndex34, EXPRESSION::getNfaNameEXPRESSIONIndex35, EXPRESSION::getNfaNameEXPRESSIONIndex36, EXPRESSION::getNfaNameEXPRESSIONIndex37, EXPRESSION::getNfaNameEXPRESSIONIndex38, EXPRESSION::getNfaNameEXPRESSIONIndex39, EXPRESSION::getNfaNameEXPRESSIONIndex40, EXPRESSION::getNfaNameEXPRESSIONIndex41, EXPRESSION::getNfaNameEXPRESSIONIndex42, EXPRESSION::getNfaNameEXPRESSIONIndex43, EXPRESSION::getNfaNameEXPRESSIONIndex44, EXPRESSION::getNfaNameEXPRESSIONIndex45, EXPRESSION::getNfaNameEXPRESSIONIndex46, EXPRESSION::getNfaNameEXPRESSIONIndex47, EXPRESSION::getNfaNameEXPRESSIONIndex48, EXPRESSION::getNfaNameEXPRESSIONIndex49, EXPRESSION::getNfaNameEXPRESSIONIndex50, EXPRESSION::getNfaNameEXPRESSIONIndex51, EXPRESSION::getNfaNameEXPRESSIONIndex52, EXPRESSION::getNfaNameEXPRESSIONIndex53, EXPRESSION::getNfaNameEXPRESSIONIndex54, EXPRESSION::getNfaNameEXPRESSIONIndex55, EXPRESSION::getNfaNameEXPRESSIONIndex56, EXPRESSION::getNfaNameEXPRESSIONIndex57, EXPRESSION::getNfaNameEXPRESSIONIndex58, EXPRESSION::getNfaNameEXPRESSIONIndex59, EXPRESSION::getNfaNameEXPRESSIONIndex60, EXPRESSION::getNfaNameEXPRESSIONIndex61, EXPRESSION::getNfaNameEXPRESSIONIndex62, EXPRESSION::getNfaNameEXPRESSIONIndex63, EXPRESSION::getNfaNameEXPRESSIONIndex64, EXPRESSION::getNfaNameEXPRESSIONIndex65, EXPRESSION::getNfaNameEXPRESSIONIndex66, EXPRESSION::getNfaNameEXPRESSIONIndex67, EXPRESSION::getNfaNameEXPRESSIONIndex68, EXPRESSION::getNfaNameEXPRESSIONIndex69, EXPRESSION::getNfaNameEXPRESSIONIndex70, EXPRESSION::getNfaNameEXPRESSIONIndex71, EXPRESSION::getNfaNameEXPRESSIONIndex72, EXPRESSION::getNfaNameEXPRESSIONIndex73, EXPRESSION::getNfaNameEXPRESSIONIndex74, EXPRESSION::getNfaNameEXPRESSIONIndex75, EXPRESSION::getNfaNameEXPRESSIONIndex76, EXPRESSION::getNfaNameEXPRESSIONIndex77, EXPRESSION::getNfaNameEXPRESSIONIndex78, EXPRESSION::getNfaNameEXPRESSIONIndex79, EXPRESSION::getNfaNameEXPRESSIONIndex80, EXPRESSION::getNfaNameEXPRESSIONIndex81, EXPRESSION::getNfaNameEXPRESSIONIndex82};
            functionTableMap.put(LexicalState.EXPRESSION, functions);
        }
    }

    private static class DIRECTIVE_NAME {
        private DIRECTIVE_NAME() {
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType._ASSERT)) {
                    nextStates.set(103);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType._ATTEMPT)) {
                    nextStates.set(125);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ASSIGN)) {
                    nextStates.set(156);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BREAK)) {
                    nextStates.set(116);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CASE)) {
                    nextStates.set(174);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DEFAUL)) {
                    nextStates.set(82);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ESCAPE)) {
                    nextStates.set(69);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXEC)) {
                    nextStates.set(93);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ELSE)) {
                    nextStates.set(133);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EMBED)) {
                    nextStates.set(136);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ELSE_IF)) {
                    nextStates.set(170);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FOREACH)) {
                    nextStates.set(54);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FTL_HEADER)) {
                    nextStates.set(124);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALLBACK)) {
                    nextStates.set(139);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FLUSH)) {
                    nextStates.set(146);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FUNCTION)) {
                    nextStates.set(150);
                }
            } else if (ch == 103) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GLOBALASSIGN)) {
                    nextStates.set(107);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType._INCLUDE)) {
                    nextStates.set(95);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IMPORT)) {
                    nextStates.set(120);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IF)) {
                    nextStates.set(31);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LOCALASSIGN)) {
                    nextStates.set(59);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LTRIM)) {
                    nextStates.set(91);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LIST)) {
                    nextStates.set(131);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType._MACRO)) {
                    nextStates.set(100);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NESTED)) {
                    nextStates.set(50);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOESCAPE)) {
                    nextStates.set(62);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RECURSE)) {
                    nextStates.set(73);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RETURN)) {
                    nextStates.set(78);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RTRIM)) {
                    nextStates.set(88);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType._RECOVER)) {
                    nextStates.set(160);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SET)) {
                    nextStates.set(46);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STOP)) {
                    nextStates.set(89);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SETTING)) {
                    nextStates.set(111);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SWITCH)) {
                    nextStates.set(166);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TRIM)) {
                    nextStates.set(4);
                }
            } else if (ch == 118) {
                if (validTypes == null || validTypes.contains(Token.TokenType.VISIT)) {
                    nextStates.set(47);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.VAR)) {
                    nextStates.set(92);
                }
            }
            if ((ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) && (validTypes == null || validTypes.contains(Token.TokenType.UNKNOWN_DIRECTIVE))) {
                nextStates.set(19);
                type = Token.TokenType.UNKNOWN_DIRECTIVE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.SET;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.VISIT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.NESTED;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(4);
            } else if (ch == 47) {
                nextStates.set(5);
            } else if (ch == 62) {
                type = Token.TokenType.TRIM;
            } else if (ch == 93) {
                type = Token.TokenType.TRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.TRIM;
            } else if (ch == 93) {
                type = Token.TokenType.TRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.FOREACH;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.LOCALASSIGN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(8);
            } else if (ch == 62) {
                type = Token.TokenType.NOESCAPE;
            } else if (ch == 93) {
                type = Token.TokenType.NOESCAPE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ESCAPE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.RECURSE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.RETURN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(12);
            } else if (ch == 62) {
                type = Token.TokenType.DEFAUL;
            } else if (ch == 93) {
                type = Token.TokenType.DEFAUL;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(13);
            } else if (ch == 47) {
                nextStates.set(14);
            } else if (ch == 62) {
                type = Token.TokenType.RTRIM;
            } else if (ch == 93) {
                type = Token.TokenType.RTRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.RTRIM;
            } else if (ch == 93) {
                type = Token.TokenType.RTRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.STOP;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(16);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch == 62) {
                type = Token.TokenType.LTRIM;
            } else if (ch == 93) {
                type = Token.TokenType.LTRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.LTRIM;
            } else if (ch == 93) {
                type = Token.TokenType.LTRIM;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.VAR;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(19);
                return Token.TokenType.UNKNOWN_DIRECTIVE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.EXEC;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType._INCLUDE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType._MACRO;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType._ASSERT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.GLOBALASSIGN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.SETTING;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(26);
            } else if (ch == 47) {
                nextStates.set(27);
            } else if (ch == 62) {
                type = Token.TokenType.BREAK;
            } else if (ch == 93) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.BREAK;
            } else if (ch == 93) {
                type = Token.TokenType.BREAK;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.IMPORT;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.FTL_HEADER;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(30);
            } else if (ch == 62) {
                type = Token.TokenType._ATTEMPT;
            } else if (ch == 93) {
                type = Token.TokenType._ATTEMPT;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.IF;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.LIST;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(33);
            } else if (ch == 47) {
                nextStates.set(34);
            } else if (ch == 62) {
                type = Token.TokenType.ELSE;
            } else if (ch == 93) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.ELSE;
            } else if (ch == 93) {
                type = Token.TokenType.ELSE;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.EMBED;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(36);
            } else if (ch == 47) {
                nextStates.set(37);
            } else if (ch == 62) {
                type = Token.TokenType.FALLBACK;
            } else if (ch == 93) {
                type = Token.TokenType.FALLBACK;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.FALLBACK;
            } else if (ch == 93) {
                type = Token.TokenType.FALLBACK;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(38);
            } else if (ch == 47) {
                nextStates.set(39);
            } else if (ch == 62) {
                type = Token.TokenType.FLUSH;
            } else if (ch == 93) {
                type = Token.TokenType.FLUSH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 62) {
                type = Token.TokenType.FLUSH;
            } else if (ch == 93) {
                type = Token.TokenType.FLUSH;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.FUNCTION;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.ASSIGN;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 9 || ch == 10 || ch == 13 || ch == 32) {
                nextStates.set(42);
            } else if (ch == 62) {
                type = Token.TokenType._RECOVER;
            } else if (ch == 93) {
                type = Token.TokenType._RECOVER;
            }
            return type;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.SWITCH;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.ELSE_IF;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.CASE;
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(57);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(7);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(65);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(66);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(67);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(71);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(79);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(83);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(84);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(85);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(86);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(87);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(12);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(13);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(90);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(15);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(96);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(97);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(101);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(22);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(105);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(106);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(23);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(109);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(110);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(113);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(118);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(119);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(26);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(121);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(122);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(123);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(28);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(29);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(126);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(127);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(128);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(129);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(130);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(30);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(132);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(134);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(135);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(137);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(35);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(140);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(141);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(142);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(143);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(145);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(36);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(148);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(151);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(153);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(154);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(40);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(157);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(158);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(161);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(162);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(163);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(164);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(165);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(42);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(168);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(171);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(175);
            }
            return null;
        }

        private static Token.TokenType getNfaNameDIRECTIVE_NAMEIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(45);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex0, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex1, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex2, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex3, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex4, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex5, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex6, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex7, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex8, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex9, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex10, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex11, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex12, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex13, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex14, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex15, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex16, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex17, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex18, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex19, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex20, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex21, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex22, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex23, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex24, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex25, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex26, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex27, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex28, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex29, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex30, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex31, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex32, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex33, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex34, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex35, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex36, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex37, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex38, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex39, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex40, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex41, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex42, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex43, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex44, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex45, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex46, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex47, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex48, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex49, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex50, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex51, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex52, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex53, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex54, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex55, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex56, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex57, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex58, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex59, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex60, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex61, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex62, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex63, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex64, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex65, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex66, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex67, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex68, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex69, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex70, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex71, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex72, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex73, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex74, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex75, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex76, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex77, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex78, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex79, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex80, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex81, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex82, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex83, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex84, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex85, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex86, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex87, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex88, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex89, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex90, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex91, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex92, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex93, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex94, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex95, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex96, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex97, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex98, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex99, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex100, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex101, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex102, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex103, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex104, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex105, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex106, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex107, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex108, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex109, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex110, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex111, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex112, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex113, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex114, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex115, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex116, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex117, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex118, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex119, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex120, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex121, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex122, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex123, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex124, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex125, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex126, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex127, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex128, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex129, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex130, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex131, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex132, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex133, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex134, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex135, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex136, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex137, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex138, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex139, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex140, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex141, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex142, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex143, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex144, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex145, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex146, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex147, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex148, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex149, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex150, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex151, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex152, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex153, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex154, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex155, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex156, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex157, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex158, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex159, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex160, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex161, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex162, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex163, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex164, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex165, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex166, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex167, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex168, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex169, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex170, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex171, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex172, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex173, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex174, DIRECTIVE_NAME::getNfaNameDIRECTIVE_NAMEIndex175};
            functionTableMap.put(LexicalState.DIRECTIVE_NAME, functions);
        }
    }
}

