/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.ListLiteral;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.core.variables.Wrap;
import freemarker.core.variables.WrappedNode;
import freemarker.core.variables.scope.Scope;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class VisitNode
extends TemplateNode
implements TemplateElement {
    public Expression getTargetNode() {
        return (Expression)this.get(1);
    }

    public Expression getNamespaces() {
        if (this.firstChildOfType(Token.TokenType.USING) == null) {
            return null;
        }
        return (Expression)this.get(3);
    }

    @Override
    public void execute(Environment env) throws IOException {
        ArrayList<Scope> nss;
        Expression targetNode = this.getTargetNode();
        Expression namespaces = this.getNamespaces();
        Object node = targetNode.evaluate(env);
        targetNode.assertNonNull(node, env);
        if (!(node instanceof WrappedNode)) {
            throw new TemplateException("Expecting an XML node here", env);
        }
        ArrayList<Scope> arrayList = nss = namespaces == null ? null : namespaces.evaluate(env);
        if (namespaces instanceof StringLiteral) {
            nss = env.importLib(Wrap.asString(nss), null);
        } else if (namespaces instanceof ListLiteral) {
            nss = ((ListLiteral)namespaces).evaluateStringsToNamespaces(env);
        }
        if (nss != null) {
            if (nss instanceof Scope) {
                ArrayList<Scope> ss = new ArrayList<Scope>();
                ss.add((Scope)((Object)nss));
                nss = ss;
            } else if (!Wrap.isList(nss)) {
                throw new TemplateException("Expecting a sequence of namespaces after 'using'", env);
            }
        }
        env.render((WrappedNode)node, (List<Scope>)nss);
    }

    @Override
    public String getDescription() {
        return "visit instruction";
    }
}

