/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.PositionalArgsList;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.UserDirective;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class UnifiedCall
extends TemplateNode
implements TemplateElement {
    public Expression getNameExp() {
        return (Expression)this.get(1);
    }

    public ArgsList getArgs() {
        ArgsList result = this.firstChildOfType(ArgsList.class);
        if (result == null) {
            result = new PositionalArgsList();
        }
        return result;
    }

    public ParameterList getBodyParameters() {
        return this.firstChildOfType(ParameterList.class);
    }

    @Override
    public void close() {
        ParameterList bodyParameters = this.getBodyParameters();
        if (bodyParameters != null) {
            for (String paramName : bodyParameters.getParams()) {
                this.getNestedBlock().declareVariable(paramName);
            }
            String catchallParam = bodyParameters.getCatchAll();
            if (catchallParam != null) {
                this.getNestedBlock().declareVariable(catchallParam);
            }
        }
    }

    @Override
    public void execute(Environment env) throws IOException {
        Expression nameExp = this.getNameExp();
        Object tm = nameExp.evaluate(env);
        ArgsList args = this.getArgs();
        ParameterList bodyParameters = this.getBodyParameters();
        if (tm == Macro.DO_NOTHING_MACRO) {
            return;
        }
        if (tm instanceof Macro) {
            Macro macro = (Macro)tm;
            if (macro.isFunction()) {
                throw new TemplateException("Routine " + macro.getName() + " is a function. A function can only be called within the evaluation of an expression.", env);
            }
            env.render(macro, args, bodyParameters, this.firstChildOfType(Block.class));
        } else if (tm instanceof UserDirective) {
            HashMap<String, Object> argMap = args != null ? args.getParameterMap(tm, env) : new HashMap();
            List<Object> paramNames = bodyParameters == null ? Collections.emptyList() : bodyParameters.getParamNames();
            env.render(this.firstChildOfType(Block.class), (UserDirective)tm, argMap, paramNames);
        } else {
            nameExp.assertNonNull(tm, env);
            throw new TemplateException(this.getLocation() + ": " + this.getNameExp() + " is not a user-defined directive.", env);
        }
    }

    @Override
    public String getDescription() {
        return "user-directive " + this.getNameExp();
    }
}

