/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.template.TemplateException;

public class UnaryPlusMinusExpression
extends TemplateNode
implements Expression {
    private static final Integer MINUS_ONE = -1;

    public Expression getTarget() {
        return this.firstChildOfType(Expression.class);
    }

    public boolean isMinus() {
        return this.get(0).getType() == Token.TokenType.MINUS;
    }

    @Override
    public Object evaluate(Environment env) {
        Number value = null;
        try {
            value = (Number)this.getTarget().evaluate(env);
        }
        catch (ClassCastException cce) {
            String msg = "Error " + this.getLocation();
            msg = msg + "\nExpression " + this.getTarget() + " is not numerical.";
            throw new TemplateException(msg, env);
        }
        if (!this.isMinus()) {
            return value;
        }
        return ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, value);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        UnaryPlusMinusExpression result = new UnaryPlusMinusExpression();
        result.add(this.get(0));
        result.add(this.getTarget().deepClone(name, subst));
        return result;
    }
}

