/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.Wrap;
import freemarker.template.utility.StringUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TemplateHeaderElement
extends TemplateNode {
    private Map<String, Expression> params = new LinkedHashMap<String, Expression>();

    @Override
    public void close() {
        List<Node> ids = this.childrenOfType(Token.TokenType.ID);
        for (Node n : ids) {
            String key = n.toString();
            if (n.nextSibling().getType() == Token.TokenType.EQUALS) {
                Expression exp = (Expression)n.nextSibling().nextSibling();
                this.params.put(key, exp);
                continue;
            }
            Expression syntheticBooleanToken = (Expression)((Object)Token.newToken(Token.TokenType.TRUE, this.getTokenSource(), n.getEndOffset(), n.getEndOffset()));
            this.params.put(key, syntheticBooleanToken);
        }
    }

    public boolean hasParameter(String name) {
        return this.params.containsKey(name);
    }

    public Map<String, Expression> getParams() {
        return this.params;
    }

    public Object getParameter(String name) {
        if (!this.hasParameter(name)) {
            return null;
        }
        Expression exp = this.params.get(name);
        return exp.evaluate(null);
    }

    public String getStringParameter(String name) {
        Object tm = this.getParameter(name);
        if (tm == null) {
            return null;
        }
        try {
            return Wrap.asString(tm);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Parameter " + name + " is not a string.");
        }
    }

    public boolean getBooleanParameter(String name) {
        Object tm = this.getParameter(name);
        if (tm == null) {
            throw new IllegalArgumentException("No parameter " + name);
        }
        if (Wrap.isBoolean(tm)) {
            return Wrap.asBoolean(tm);
        }
        if (tm instanceof CharSequence) {
            try {
                return StringUtil.getYesNo(Wrap.asString(tm));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Parameter " + name + " is not a boolean type.");
    }
}

