/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.BreakException;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.CaseBlock;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateException;
import java.io.IOException;

public class SwitchBlock
extends TemplateNode
implements TemplateElement {
    @Override
    public void execute(Environment env) throws IOException {
        boolean foundMatch = false;
        Object testValue = this.firstChildOfType(Expression.class).evaluate(env);
        try {
            for (CaseBlock cb : this.childrenOfType(CaseBlock.class)) {
                if (foundMatch) {
                    cb.execute(env);
                    continue;
                }
                Expression testExp = cb.getExpression();
                foundMatch = testExp == null || this.equals(env, testValue, cb.getExpression().evaluate(env));
                if (!foundMatch) continue;
                cb.execute(env);
            }
        }
        catch (BreakException breakException) {
            // empty catch block
        }
    }

    private boolean equals(Environment env, Object first, Object second) {
        if (first instanceof Number && second instanceof Number) {
            return ((Number)first).equals((Number)second);
        }
        if (first instanceof CharSequence && second instanceof CharSequence) {
            return Wrap.asString(first).equals(Wrap.asString(second));
        }
        throw new TemplateException("Can only compare numbers and strings", env);
    }
}

