/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Literal;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.Token;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

public class StringLiteral
extends Literal
implements Expression {
    private TemplateElement interpolatedOutput;
    private String value;

    public boolean isRaw() {
        return this.charAt(0) == 'r';
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void close() {
        String s = this.toString();
        s = s.substring(1, s.length() - 1);
        if (this.isRaw()) {
            s = s.substring(1);
        }
        if (!this.isRaw()) {
            s = StringUtil.FTLStringLiteralDec(s);
        }
        this.value = s;
    }

    public void checkInterpolation() {
        String src = this.toString();
        if (src.length() > 5 && src.indexOf("${") >= 0) {
            FMLexer token_source = new FMLexer("input", this.value, FMLexer.LexicalState.DEFAULT, this.getBeginLine(), this.getBeginColumn() + 1);
            FMParser parser = new FMParser(token_source);
            parser.setTemplate(this.getTemplate());
            try {
                this.interpolatedOutput = parser.FreeMarkerText();
            }
            catch (ParseException e) {
                e.setTemplateName(this.getTemplate().getName());
                throw e;
            }
        }
    }

    @Override
    public Object evaluate(Environment env) {
        return this.getStringValue(env);
    }

    public String getAsString() {
        return this.value;
    }

    @Override
    public String getStringValue(Environment env) {
        if (this.interpolatedOutput == null) {
            return this.value;
        }
        TemplateExceptionHandler teh = env.getTemplateExceptionHandler();
        env.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            String string = env.renderElementToString(this.interpolatedOutput);
            return string;
        }
        catch (IOException ioe) {
            throw new TemplateException(ioe, env);
        }
        finally {
            env.setTemplateExceptionHandler(teh);
        }
    }

    @Override
    public boolean isAssignableTo() {
        return true;
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        return this;
    }

    public StringLiteral(Token.TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        super(type, tokenSource, beginOffset, endOffset);
    }
}

