/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.template.TemplateException;

public class RelationalExpression
extends TemplateNode
implements Expression {
    public Expression getLeft() {
        return (Expression)this.get(0);
    }

    public Expression getRight() {
        return (Expression)this.get(2);
    }

    @Override
    public Object evaluate(Environment env) {
        return this.isTrue(env);
    }

    @Override
    public boolean isTrue(Environment env) {
        Token.TokenType operation = (Token.TokenType)this.get(1).getType();
        Object left = this.getLeft().evaluate(env);
        Object right = this.getRight().evaluate(env);
        this.getLeft().assertNonNull(left, env);
        this.getRight().assertNonNull(right, env);
        if (!(left instanceof Number) || !(right instanceof Number)) {
            throw new TemplateException("Can only compare numbers", env);
        }
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        int comp = ae.compareNumbers((Number)left, (Number)right);
        switch (operation) {
            case LESS_THAN: {
                return comp < 0;
            }
            case GREATER_THAN: 
            case ESCAPED_GT: {
                return comp > 0;
            }
            case LESS_THAN_EQUALS: {
                return comp <= 0;
            }
            case GREATER_THAN_EQUALS: 
            case ESCAPED_GTE: {
                return comp >= 0;
            }
        }
        throw new InternalError();
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        RelationalExpression result = new RelationalExpression();
        result.add(this.getLeft().deepClone(name, subst));
        result.add(this.get(1));
        result.add(this.getRight().deepClone(name, subst));
        return result;
    }
}

