/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateException;
import java.util.AbstractList;

public class RangeExpression
extends TemplateNode
implements Expression {
    public Expression getLeft() {
        return (Expression)this.get(0);
    }

    public Expression getRight() {
        return this.hasRhs() ? (Expression)this.get(2) : null;
    }

    public boolean hasRhs() {
        return this.size() == 3;
    }

    @Override
    public Object evaluate(Environment env) {
        int min = Wrap.getNumber(this.getLeft(), env).intValue();
        int max = 0;
        if (this.hasRhs()) {
            max = Wrap.getNumber(this.getRight(), env).intValue();
            return new NumericalRange(min, max);
        }
        return new NumericalRange(min);
    }

    @Override
    public boolean isTrue(Environment env) {
        String msg = "Error " + this.getLocation() + ". \nExpecting a boolean here. Expression " + this + " is a range.";
        throw new TemplateException(msg, env);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        RangeExpression result = new RangeExpression();
        result.add(this.getLeft().deepClone(name, subst));
        result.add(this.get(1));
        if (this.hasRhs()) {
            result.add(this.getRight().deepClone(name, subst));
        }
        return result;
    }

    private class NumericalRange
    extends AbstractList<Integer> {
        private int lower;
        private int upper;
        private boolean descending;
        private boolean norhs;

        public NumericalRange(int lower) {
            this.norhs = true;
            this.lower = lower;
        }

        public NumericalRange(int left, int right) {
            this.lower = Math.min(left, right);
            this.upper = Math.max(left, right);
            this.descending = left != this.lower;
        }

        @Override
        public Integer get(int i) {
            int index;
            int n = index = this.descending ? this.upper - i : this.lower + i;
            if (this.norhs && index > this.upper || index < this.lower) {
                throw new EvaluationException("out of bounds of range");
            }
            return index;
        }

        @Override
        public int size() {
            return 1 + this.upper - this.lower;
        }
    }
}

