/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.parser.Node;
import freemarker.core.variables.EvaluationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PositionalArgsList
extends ArgsList {
    public List getParameterSequence(Object target, Environment env) {
        ParameterList annotatedParameterList = PositionalArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Expression exp : this.childrenOfType(Expression.class)) {
                result.add(exp.evaluate(env));
            }
            return result;
        }
        return annotatedParameterList.getParameterSequence(this, env);
    }

    @Override
    public Map<String, Object> getParameterMap(Object target, Environment env) {
        Map<String, Object> result = new HashMap<String, Object>();
        ParameterList annotatedParameterList = PositionalArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            if (this.firstChildOfType(Expression.class) != null) {
                throw new EvaluationException("Cannot pass positional arguments to this UserDirective");
            }
        } else {
            result = annotatedParameterList.getParameterMap(this, env, false);
        }
        return result;
    }

    public Object getValueAt(int i, Environment env) {
        Expression exp = this.childrenOfType(Expression.class).get(i);
        Object value = exp.evaluate(env);
        exp.assertIsDefined(value, env);
        return value;
    }

    @Override
    public PositionalArgsList deepClone(String name, Expression subst) {
        PositionalArgsList result = new PositionalArgsList();
        for (Node node : this) {
            if (node instanceof Expression) {
                node = ((Expression)node).deepClone(name, subst);
            }
            result.add(node);
        }
        return result;
    }
}

