/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Literal;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.Token;
import freemarker.template.Template;
import java.math.BigDecimal;

public class NumberLiteral
extends Literal
implements Expression {
    private Number value;

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    @Override
    public Object evaluate(Environment env) {
        return this.getValue();
    }

    @Override
    public String getStringValue(Environment env) {
        return env.formatNumber(this.getValue());
    }

    @Override
    public void close() {
        String s = this.toString();
        Template template = this.getTemplate();
        this.value = template != null ? template.getArithmeticEngine().toNumber(s) : new BigDecimal(s);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        return this;
    }

    public NumberLiteral(Token.TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        super(type, tokenSource, beginOffset, endOffset);
    }
}

