/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.parser.ParseException;
import freemarker.template.TemplateException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NamedArgsList
extends ArgsList {
    private LinkedHashMap<String, Expression> namedArgs = new LinkedHashMap();

    public void addNamedArg(String name, Expression exp) throws ParseException {
        if (this.namedArgs.containsKey(name)) {
            throw new ParseException("Error at: " + exp.getLocation() + "\nArgument " + name + " was already specified.");
        }
        this.namedArgs.put(name, exp);
        exp.setParent(this);
    }

    public Map<String, Expression> getArgs() {
        return this.namedArgs;
    }

    @Override
    public int size() {
        return this.namedArgs.size();
    }

    public Map<String, Expression> getCopyOfMap() {
        return (Map)this.namedArgs.clone();
    }

    @Override
    public Map<String, Object> getParameterMap(Object tm, Environment env) {
        HashMap<String, Object> result = null;
        ParameterList annotatedParameterList = ArgsList.getParameterList(tm);
        if (annotatedParameterList == null) {
            result = new HashMap();
            for (String paramName : this.namedArgs.keySet()) {
                Expression exp = this.namedArgs.get(paramName);
                Object value = exp.evaluate(env);
                exp.assertIsDefined(value, env);
                result.put(paramName, value);
            }
        } else {
            result = annotatedParameterList.getParameterMap(this, env);
        }
        return result;
    }

    @Override
    public List<Object> getParameterSequence(Object target, Environment env) {
        ParameterList annotatedParameterList = NamedArgsList.getParameterList(target);
        if (annotatedParameterList == null) {
            String msg = "Error at: " + this.getLocation() + "\nCannot invoke method " + target + " with a key=value parameter list because it is not annotated.";
            throw new TemplateException(msg, env);
        }
        return annotatedParameterList.getParameterSequence(this, env);
    }

    @Override
    public ArgsList deepClone(String name, Expression subst) {
        NamedArgsList result = new NamedArgsList();
        for (Map.Entry<String, Expression> entry : this.namedArgs.entrySet()) {
            try {
                result.addNamedArg(entry.getKey(), entry.getValue());
            }
            catch (ParseException parseException) {}
        }
        return result;
    }
}

