/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateException;

public class MultiplicativeExpression
extends TemplateNode
implements Expression {
    public Expression getLeft() {
        return (Expression)this.get(0);
    }

    public Expression getRight() {
        return (Expression)this.get(2);
    }

    @Override
    public Object evaluate(Environment env) {
        Object result = ((Expression)this.get(0)).evaluate(env);
        for (int i = 0; i < this.size() / 2; ++i) {
            Token.TokenType operation = (Token.TokenType)this.get(i * 2 + 1).getType();
            Object rightSide = ((Expression)this.get(i * 2 + 2)).evaluate(env);
            result = this.mulDivMod(env, result, rightSide, operation);
        }
        return result;
    }

    public Object mulDivMod(Environment env, Object leftSide, Object rightSide, Token.TokenType operation) {
        boolean bothNumbers;
        boolean leftIsNumber = leftSide instanceof Number;
        boolean rightIsNumber = rightSide instanceof Number;
        boolean bl = bothNumbers = leftIsNumber && rightIsNumber;
        if (!bothNumbers) {
            String msg = "Error " + this.getLocation();
            if (!leftIsNumber) {
                msg = msg + "\nExpression " + this.getLeft() + " is not numerical";
            }
            if (!rightIsNumber) {
                msg = msg + "\nExpression " + this.getRight() + " is not numerical";
            }
            throw new TemplateException(msg, env);
        }
        Number first = Wrap.getNumber(leftSide, this.getLeft(), env);
        Number second = Wrap.getNumber(rightSide, this.getRight(), env);
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        switch (operation) {
            case TIMES: {
                return ae.multiply(first, second);
            }
            case DIVIDE: {
                return ae.divide(first, second);
            }
            case PERCENT: {
                return ae.modulus(first, second);
            }
        }
        throw new TemplateException("unknown operation : " + operation, env);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        MultiplicativeExpression result = new MultiplicativeExpression();
        for (Node n : this) {
            if (n instanceof Expression) {
                result.add(((Expression)n).deepClone(name, subst));
                continue;
            }
            result.add(n);
        }
        return result;
    }
}

