/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.QuadFunction;
import freemarker.core.variables.TriFunction;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public class MethodCall
extends TemplateNode
implements Expression {
    public ArgsList getArgs() {
        return this.firstChildOfType(ArgsList.class);
    }

    public Expression getTarget() {
        return (Expression)this.get(0);
    }

    @Override
    public Object evaluate(Environment env) {
        Object value = this.getTarget().evaluate(env);
        if (value instanceof VarArgsFunction) {
            VarArgsFunction targetMethod = (VarArgsFunction)value;
            ArgsList args = this.getArgs();
            List<Object> argumentList = args != null ? args.getParameterSequence(targetMethod, env) : new ArrayList();
            Object result = targetMethod.apply(argumentList.toArray(new Object[argumentList.size()]));
            return Wrap.wrap(result);
        }
        if (value instanceof Supplier) {
            ArgsList argsList = this.getArgs();
            if (argsList != null && argsList.firstChildOfType(Expression.class) != null) {
                throw new EvaluationException("The method " + this.getTarget() + " takes no arguments.");
            }
            Object result = ((Supplier)value).get();
            return Wrap.wrap(result);
        }
        if (value instanceof Function) {
            ArgsList args = this.getArgs();
            if (args == null || args.childrenOfType(Expression.class).size() != 1) {
                throw new EvaluationException("The method " + this.getTarget() + " takes exactly one argument.");
            }
            Expression argExp = (Expression)this.getArgs().get(0);
            Object arg = Wrap.unwrap(argExp.evaluate(env));
            Object result = ((Function)value).apply(arg);
            return Wrap.wrap(result);
        }
        if (value instanceof BiFunction) {
            List<Object> argExpressions;
            ArgsList args = this.getArgs();
            List<Object> list = argExpressions = args == null ? new ArrayList() : args.childrenOfType(Expression.class);
            if (argExpressions.size() != 2) {
                throw new EvaluationException("The method " + this.getTarget() + " takes exactly two arguments.");
            }
            Object firstArg = ((Expression)argExpressions.get(0)).evaluate(env);
            Object secondArg = ((Expression)argExpressions.get(1)).evaluate(env);
            Object result = ((BiFunction)value).apply(firstArg, secondArg);
            return Wrap.wrap(result);
        }
        if (value instanceof TriFunction) {
            List<Object> argExpressions;
            ArgsList args = this.getArgs();
            List<Object> list = argExpressions = args == null ? new ArrayList() : args.childrenOfType(Expression.class);
            if (argExpressions.size() != 3) {
                throw new EvaluationException("The method " + this.getTarget() + " takes exactly three arguments.");
            }
            Object firstArg = ((Expression)argExpressions.get(0)).evaluate(env);
            Object secondArg = ((Expression)argExpressions.get(1)).evaluate(env);
            Object thirdArg = ((Expression)argExpressions.get(2)).evaluate(env);
            Object result = ((TriFunction)value).apply(firstArg, secondArg, thirdArg);
            return Wrap.wrap(result);
        }
        if (value instanceof QuadFunction) {
            List<Object> argExpressions;
            ArgsList args = this.getArgs();
            List<Object> list = argExpressions = args == null ? new ArrayList() : args.childrenOfType(Expression.class);
            if (argExpressions.size() != 4) {
                throw new EvaluationException("The method " + this.getTarget() + " takes exactly four arguments.");
            }
            Object firstArg = ((Expression)argExpressions.get(0)).evaluate(env);
            Object secondArg = ((Expression)argExpressions.get(1)).evaluate(env);
            Object thirdArg = ((Expression)argExpressions.get(2)).evaluate(env);
            Object fourthArg = ((Expression)argExpressions.get(3)).evaluate(env);
            Object result = ((QuadFunction)value).apply(firstArg, secondArg, thirdArg, fourthArg);
            return Wrap.wrap(result);
        }
        if (value instanceof Macro) {
            Macro func = (Macro)value;
            StringWriter sw = null;
            env.setLastReturnValue(null);
            Writer prevOut = env.getOut();
            try {
                env.setOut(Environment.NULL_WRITER);
                if (!func.isFunction()) {
                    sw = new StringWriter();
                    env.setOut(sw);
                }
                env.render(func, this.getArgs(), null, null);
            }
            catch (IOException ioe) {
                throw new InternalError("This should be impossible.");
            }
            finally {
                env.setOut(prevOut);
            }
            return sw != null ? sw.getBuffer().toString() : env.getLastReturnValue();
        }
        throw MethodCall.invalidTypeException(value, this.getTarget(), env, "method");
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        MethodCall result = new MethodCall();
        result.add(this.getTarget().deepClone(name, subst));
        result.add(this.get(1));
        ArgsList args = this.getArgs();
        if (args != null) {
            result.add(this.getArgs().deepClone(name, subst));
            result.add(this.get(3));
        } else {
            result.add(this.get(2));
        }
        return result;
    }
}

