/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.Identifier;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.core.variables.WrappedVariable;

public class Macro
extends TemplateNode
implements TemplateElement,
WrappedVariable {
    public static final Macro DO_NOTHING_MACRO = new Macro();

    public boolean isFunction() {
        return this.get(0).getType() == Token.TokenType.FUNCTION;
    }

    public String getName() {
        if (this == DO_NOTHING_MACRO) {
            return ".pass";
        }
        if (this.get(1) instanceof Identifier) {
            return this.get(1).toString();
        }
        return ((StringLiteral)this.get(1)).getAsString();
    }

    public ParameterList getParams() {
        return this.firstChildOfType(ParameterList.class);
    }

    @Override
    public void close() {
        ParameterList params = this.getParams();
        for (String paramName : params.getParams()) {
            this.getNestedBlock().declareVariable(paramName);
        }
        String catchallVar = params.getCatchAll();
        if (catchallVar != null) {
            this.getNestedBlock().declareVariable(catchallVar);
        }
    }

    @Override
    public void execute(Environment env) {
        env.visitMacroDef(this);
    }

    @Override
    public String getDescription() {
        return (this.isFunction() ? "function " : "macro ") + this.getName();
    }

    static {
        DO_NOTHING_MACRO.add(new Block());
    }
}

