/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.variables.scope.Scope;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ListLiteral
extends TemplateNode
implements Expression {
    public List<Expression> getElements() {
        return this.childrenOfType(Expression.class);
    }

    @Override
    public Object evaluate(Environment env) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression exp : this.getElements()) {
            Object tm = exp.evaluate(env);
            this.assertIsDefined(tm, env);
            result.add(tm);
        }
        return result;
    }

    public List evaluateStringsToNamespaces(Environment env) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression exp : this.getElements()) {
            if (exp instanceof StringLiteral) {
                String s = ((StringLiteral)exp).getAsString();
                try {
                    Scope ns = env.importLib(s, null);
                    result.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new TemplateException("Could not import library '" + s + "', " + ioe.getMessage(), env);
                }
            }
            result.add(exp);
        }
        return result;
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        ListLiteral result = new ListLiteral();
        for (Node node : this) {
            if (node instanceof Expression) {
                node = ((Expression)node).deepClone(name, subst);
            }
            result.add(node);
        }
        return result;
    }
}

