/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.util.Map;

public class IteratorBlock
extends TemplateNode
implements TemplateElement {
    public boolean isForeach() {
        return this.get(0).getType() == Token.TokenType.FOREACH;
    }

    public boolean isOverMap() {
        return this.firstChildOfType(Token.TokenType.COMMA) != null;
    }

    public String getIndexName() {
        return this.isForeach() ? this.get(1).toString() : this.get(3).toString();
    }

    public String getValueVarName() {
        Node comma = this.firstChildOfType(Token.TokenType.COMMA);
        return comma == null ? null : comma.nextSibling().toString();
    }

    public Expression getListExpression() {
        if (!this.isForeach()) {
            return (Expression)this.get(1);
        }
        return this.isOverMap() ? (Expression)this.get(5) : (Expression)this.get(3);
    }

    @Override
    public void execute(Environment env) throws IOException {
        Object listVar = this.getListExpression().evaluate(env);
        this.getListExpression().assertNonNull(listVar, env);
        if (!this.isOverMap()) {
            if (!Wrap.isIterable(listVar)) {
                throw TemplateNode.invalidTypeException(listVar, this.getListExpression(), env, "collection or sequence");
            }
            env.process(Wrap.asIterator(listVar), this.getNestedBlock(), this.getIndexName());
        } else if (listVar instanceof Map || listVar instanceof TemplateHashModel) {
            env.process(listVar, this.getNestedBlock(), this.getIndexName(), this.getValueVarName());
        } else {
            String message = "Expecting map or hash, at " + this.getListExpression().getLocation();
            throw new EvaluationException(message);
        }
    }

    @Override
    public String getDescription() {
        return this.isForeach() ? "foreach " + this.getIndexName() + (this.getValueVarName() == null ? "" : "," + this.getValueVarName()) + " in " + this.getListExpression() : "list " + this.getListExpression() + " as " + this.getIndexName() + (this.getValueVarName() == null ? "" : "," + this.getValueVarName());
    }
}

