/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import java.io.IOException;

public class Interpolation
extends TemplateNode
implements TemplateElement {
    private Expression escapedExpression;

    public boolean isNoEscapeSet() {
        return ((Token)this.get(0)).charAt(1) == '\\';
    }

    public void setEscapedExpression(Expression escapedExpression) {
        this.escapedExpression = escapedExpression;
    }

    public Expression getEscapedExpression() {
        if (this.escapedExpression == null || this.isNoEscapeSet()) {
            return this.getExpression();
        }
        return this.escapedExpression;
    }

    public Expression getExpression() {
        return this.firstChildOfType(Expression.class);
    }

    @Override
    public void execute(Environment env) throws IOException {
        Expression exp = this.getEscapedExpression();
        env.getOut().write(exp.getStringValue(env));
    }

    @Override
    public String getDescription() {
        return this.getSource() + (this.getExpression() == this.escapedExpression || this.isNoEscapeSet() ? "" : " escaped ${" + this.escapedExpression.getDescription() + "}");
    }
}

