/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.cache.TemplateCache;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Identifier;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.Token;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.Wrap;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

public class IncludeInstruction
extends TemplateNode
implements TemplateElement {
    private Template template;

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    public boolean useFreshNamespace() {
        return this.get(0).getType() == Token.TokenType.EMBED;
    }

    public Expression getParamByName(String name) {
        for (Node n : this) {
            if (!(n instanceof Identifier) || !n.toString().equalsIgnoreCase(name)) continue;
            return (Expression)n.nextSibling().nextSibling();
        }
        return null;
    }

    @Override
    public void execute(Environment env) throws IOException {
        Template includedTemplate;
        String templateNameString = ((Expression)this.get(1)).getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getLocation() + "The expression " + this.get(1) + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        String encoding = null;
        Expression encodingExp = this.getParamByName("encoding");
        if (encodingExp != null) {
            encoding = encodingExp.getStringValue(env);
        }
        boolean parse = true;
        Expression parseExp = this.getParamByName("parse");
        if (parseExp != null) {
            Object tm = parseExp.evaluate(env);
            parseExp.assertNonNull(tm, env);
            parse = tm instanceof CharSequence ? StringUtil.getYesNo(Wrap.asString(tm)) : parseExp.isTrue(env);
        }
        String templatePath = "";
        if (this.template != null) {
            String templatePath1 = this.template.getName();
            int lastSlash = templatePath1.lastIndexOf(47);
            templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
        }
        try {
            templateNameString = TemplateCache.getFullTemplatePath(env, templatePath, templateNameString);
            includedTemplate = env.getTemplateForInclusion(templateNameString, encoding, parse);
        }
        catch (ParseException pe) {
            String msg = "Error parsing included template " + templateNameString + "\n" + pe.getMessage();
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading included file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.include(includedTemplate, this.useFreshNamespace());
    }
}

