/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.ParseException;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.log.Logger;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

public class ImportDeclaration
extends TemplateNode
implements TemplateElement {
    private String templatePath = "";
    private Template template;

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(Template template) {
        this.template = template;
    }

    public String getNamespace() {
        return this.get(3).toString();
    }

    public Expression getTemplateNameExpression() {
        return (Expression)this.get(1);
    }

    @Override
    public void execute(Environment env) throws IOException {
        Template importedTemplate;
        String templateNameString = this.getTemplateNameExpression().getStringValue(env);
        if (templateNameString == null) {
            String msg = "Error " + this.getLocation() + "The expression " + this.getTemplateNameExpression() + " is undefined.";
            throw new InvalidReferenceException(msg, env);
        }
        try {
            if (templateNameString.indexOf("://") <= 0) {
                int protIndex;
                templateNameString = templateNameString.length() > 0 && templateNameString.charAt(0) == '/' ? ((protIndex = this.templatePath.indexOf("://")) > 0 ? this.templatePath.substring(0, protIndex + 2) + templateNameString : templateNameString.substring(1)) : this.templatePath + templateNameString;
            }
            importedTemplate = env.getTemplateForImporting(templateNameString);
        }
        catch (ParseException pe) {
            String msg = "Error parsing imported template " + templateNameString;
            Logger.getLogger("freemarker.runtime").error(msg, pe);
            throw new TemplateException(msg, pe, env);
        }
        catch (IOException ioe) {
            String msg = "Error reading imported file " + templateNameString;
            throw new TemplateException(msg, ioe, env);
        }
        env.importLib(importedTemplate, this.getNamespace(), false);
    }

    @Override
    public String getDescription() {
        return "import " + this.getTemplateNameExpression() + " as " + this.getNamespace();
    }

    public String getTemplateName() {
        return this.getTemplateNameExpression().toString();
    }

    @Override
    public void close() {
        if (this.template != null) {
            String templatePath1 = this.template.getName();
            int lastSlash = templatePath1.lastIndexOf(47);
            this.templatePath = lastSlash == -1 ? "" : templatePath1.substring(0, lastSlash + 1);
            this.template.addImport(this);
        }
    }
}

