/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;

public class HashLiteral
extends TemplateNode
implements Expression {
    private List<Expression> keys = new ArrayList<Expression>();
    private List<Expression> values = new ArrayList<Expression>();

    @Override
    public void close() {
        boolean justSawKey = false;
        for (Expression exp : this.childrenOfType(Expression.class)) {
            if (justSawKey) {
                this.values.add(exp);
            } else {
                this.keys.add(exp);
            }
            justSawKey = !justSawKey;
        }
        assert (this.keys.size() == this.values.size()) : this.getSource();
    }

    @Override
    public Object evaluate(Environment env) {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < this.keys.size(); ++i) {
            Object key = this.keys.get(i).evaluate(env);
            Object value = this.values.get(i).evaluate(env);
            result.put(key, value);
        }
        return result;
    }

    public List<Expression> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public List<Expression> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        HashLiteral result = new HashLiteral();
        for (int i = 0; i < this.keys.size(); ++i) {
            Expression keyClone = this.keys.get(i).deepClone(name, subst);
            Expression valueClone = this.values.get(i).deepClone(name, subst);
            result.keys.add(keyClone);
            result.values.add(valueClone);
        }
        result.close();
        return result;
    }
}

