/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.parser.Node;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateSequenceModel;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public interface Expression
extends Node {
    public Object evaluate(Environment var1);

    default public String getDescription() {
        return "the expression: " + this;
    }

    default public boolean isAssignableTo() {
        return false;
    }

    default public String getStringValue(Environment env) {
        return this.getStringValue(env, this.evaluate(env));
    }

    default public String getStringValue(Environment env, Object referent) {
        this.assertNonNull(referent, env);
        if (referent instanceof Number) {
            return env.formatNumber((Number)referent);
        }
        if (referent instanceof TemplateDateModel) {
            TemplateDateModel dm = (TemplateDateModel)referent;
            return env.formatDate(Wrap.getDate(dm, this, env), dm.getDateType());
        }
        if (referent instanceof CharSequence) {
            return Wrap.asString(referent);
        }
        return referent.toString();
    }

    public Expression _deepClone(String var1, Expression var2);

    default public Expression deepClone(String name, Expression subst) {
        Expression clone = this._deepClone(name, subst);
        clone.copyLocationFrom(this);
        clone.setParent(this.getParent());
        return clone;
    }

    default public void assertNonNull(Object value, Environment env) {
        this.assertIsDefined(value, env);
        if (value == Wrap.JAVA_NULL) {
            throw new InvalidReferenceException("Expression " + this + " is null " + this.getLocation() + ".", env);
        }
    }

    default public void assertIsDefined(Object value, Environment env) {
        if (value == null) {
            throw new InvalidReferenceException("Expression " + this + " is undefined " + this.getLocation() + ".", env);
        }
    }

    default public boolean isTrue(Environment env) {
        Object referent = this.evaluate(env);
        this.assertIsDefined(referent, env);
        if (referent == Wrap.JAVA_NULL) {
            return false;
        }
        if (Wrap.isBoolean(referent)) {
            return Wrap.asBoolean(referent);
        }
        if (referent instanceof Collection) {
            return !((Collection)referent).isEmpty();
        }
        if (referent instanceof Map) {
            return !((Map)referent).isEmpty();
        }
        if (referent.getClass().isArray()) {
            return Array.getLength(referent) > 0;
        }
        if (referent instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)referent).size() > 0;
        }
        return referent.toString().length() > 0;
    }
}

