/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.core.variables.Wrap;

public class EqualityExpression
extends TemplateNode
implements Expression {
    public Expression getLeft() {
        return (Expression)this.get(0);
    }

    public Expression getRight() {
        return (Expression)this.get(2);
    }

    @Override
    public Object evaluate(Environment env) {
        return this.isTrue(env);
    }

    @Override
    public boolean isTrue(Environment env) {
        Token.TokenType operation = (Token.TokenType)this.get(1).getType();
        Object left = this.getLeft().evaluate(env);
        Object right = this.getRight().evaluate(env);
        this.assertIsDefined(left, env);
        this.assertIsDefined(right, env);
        this.getLeft().assertNonNull(left, env);
        this.getRight().assertNonNull(right, env);
        if (left instanceof Number && right instanceof Number) {
            ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
            int comp = ae.compareNumbers((Number)left, (Number)right);
            return operation == Token.TokenType.NOT_EQUALS ? comp != 0 : comp == 0;
        }
        if (left == Wrap.JAVA_NULL || right == Wrap.JAVA_NULL) {
            boolean areEqual;
            boolean bl = areEqual = left == right;
            return operation == Token.TokenType.NOT_EQUALS ? !areEqual : areEqual;
        }
        left = Wrap.unwrap(left);
        right = Wrap.unwrap(right);
        return operation == Token.TokenType.NOT_EQUALS ? !left.equals(right) : left.equals(right);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        EqualityExpression result = new EqualityExpression();
        result.add(this.getLeft().deepClone(name, subst));
        result.add(this.get(1));
        result.add(this.getRight().deepClone(name, subst));
        return result;
    }
}

