/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Token;
import freemarker.core.variables.ReflectionCode;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateHashModel;
import java.util.Map;

public class DotVariable
extends TemplateNode
implements Expression {
    public Expression getTarget() {
        return (Expression)this.get(0);
    }

    public String getKey() {
        return this.get(2).toString();
    }

    @Override
    public boolean isAssignableTo() {
        return true;
    }

    @Override
    public Object evaluate(Environment env) {
        Object lhs = this.getTarget().evaluate(env);
        this.assertNonNull(lhs, env);
        if (lhs instanceof Map) {
            String key = this.getKey();
            Object value = ((Map)lhs).get(key);
            if (value == null) {
                return ((Map)lhs).containsKey(key) ? Wrap.JAVA_NULL : null;
            }
            return Wrap.wrap(value);
        }
        if (lhs instanceof TemplateHashModel) {
            return Wrap.wrap(((TemplateHashModel)lhs).get(this.getKey()));
        }
        return ReflectionCode.getProperty(lhs, this.getKey(), this.getTemplate().legacySyntax());
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        Expression clonedTarget = this.getTarget().deepClone(name, subst);
        Token op = (Token)this.get(1);
        Token key = (Token)this.get(2);
        DotVariable result = new DotVariable();
        result.add(clonedTarget);
        result.add(op);
        result.add(key);
        return result;
    }
}

