/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;

public class BuiltinVariable
extends TemplateNode
implements Expression {
    private String name;

    public void setName(String name) {
        this.name = name.intern();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object evaluate(Environment env) {
        switch (this.name) {
            case "namespace": {
                return env.getCurrentNamespace();
            }
            case "main": {
                return env.getMainNamespace();
            }
            case "globals": {
                return env;
            }
            case "locals": {
                return env.getCurrentMacroContext();
            }
            case "data_model": {
                return env.getDataModel();
            }
            case "scope": {
                return env.getCurrentScope();
            }
            case "vars": {
                return new VarsHash(env);
            }
            case "locale": {
                return env.getLocale().toString();
            }
            case "lang": {
                return env.getLocale().getLanguage();
            }
            case "current_node": 
            case "node": {
                return env.getCurrentVisitorNode();
            }
            case "pass": {
                return Macro.DO_NOTHING_MACRO;
            }
            case "name": {
                return env.getTemplate().getName();
            }
            case "version": {
                return Configuration.getVersionNumber();
            }
            case "output_encoding": {
                return env.getOutputEncoding();
            }
            case "url_escaping_charset": {
                return env.getURLEscapingCharset();
            }
            case "error": {
                return env.getCurrentRecoveredErrorMessage();
            }
        }
        throw new TemplateException("Invalid built-in variable: " + this, env);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        return this;
    }

    static class VarsHash
    implements TemplateHashModel {
        private final Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        @Override
        public Object get(String key) {
            return this.env.getVariable(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

