/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.builtins.BuiltIn;
import freemarker.builtins.DateTime;
import freemarker.builtins.ExistenceBuiltIn;
import freemarker.builtins.HashBuiltin;
import freemarker.builtins.MacroBuiltins;
import freemarker.builtins.NodeFunctions;
import freemarker.builtins.NumericalCast;
import freemarker.builtins.SequenceContainsBuiltIn;
import freemarker.builtins.SequenceFunctions;
import freemarker.builtins.StringFunctions;
import freemarker.builtins.StringTransformations;
import freemarker.builtins.TypeChecks;
import freemarker.builtins.cBI;
import freemarker.builtins.evalBI;
import freemarker.builtins.groupsBI;
import freemarker.builtins.instanceofBI;
import freemarker.builtins.interpretBI;
import freemarker.builtins.numberBI;
import freemarker.builtins.resolveBI;
import freemarker.builtins.sizeBI;
import freemarker.builtins.stringBI;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.ParseException;
import freemarker.core.parser.Token;
import freemarker.core.variables.JavaMethodCall;
import freemarker.core.variables.Wrap;
import java.util.HashMap;

public class BuiltInExpression
extends TemplateNode
implements Expression {
    private static final HashMap<String, BuiltIn> knownBuiltins = new HashMap();
    private String key;
    private BuiltIn bi;

    public BuiltInExpression() {
        knownBuiltins.put("source", (env, caller) -> caller.getTarget().getSource());
        knownBuiltins.put("upper_case", (env, caller) -> Wrap.asString(caller.getTarget().evaluate(env)).toUpperCase(env.getLocale()));
        knownBuiltins.put("lower_case", (env, caller) -> Wrap.asString(caller.getTarget().evaluate(env)).toLowerCase(env.getLocale()));
        knownBuiltins.put("length", (env, caller) -> Wrap.asString(caller.getTarget().evaluate(env)).length());
        knownBuiltins.put("trim", (env, caller) -> Wrap.asString(caller.getTarget().evaluate(env)).trim());
        knownBuiltins.put("substring", (env, caller) -> new JavaMethodCall(Wrap.asString(caller.getTarget().evaluate(env)), "substring"));
        knownBuiltins.put("instanceof", new instanceofBI());
        knownBuiltins.put("exists", new ExistenceBuiltIn.ExistsBuiltIn());
        knownBuiltins.put("c", new cBI());
        knownBuiltins.put("size", new sizeBI());
        knownBuiltins.put("string", new stringBI());
        knownBuiltins.put("eval", new evalBI());
        knownBuiltins.put("interpret", new interpretBI());
        knownBuiltins.put("resolve", new resolveBI());
        NumericalCast numericalCast = new NumericalCast();
        knownBuiltins.put("byte", numericalCast);
        knownBuiltins.put("double", numericalCast);
        knownBuiltins.put("float", numericalCast);
        knownBuiltins.put("int", numericalCast);
        knownBuiltins.put("long", numericalCast);
        knownBuiltins.put("short", numericalCast);
        knownBuiltins.put("floor", numericalCast);
        knownBuiltins.put("ceiling", numericalCast);
        knownBuiltins.put("round", numericalCast);
        knownBuiltins.put("capitalize", new StringTransformations.Capitalize());
        knownBuiltins.put("cap_first", new StringTransformations.CapFirst(true));
        knownBuiltins.put("uncap_first", new StringTransformations.CapFirst(false));
        knownBuiltins.put("j_string", new StringTransformations.Java());
        knownBuiltins.put("js_string", new StringTransformations.JavaScript());
        knownBuiltins.put("chop_linebreak", new StringTransformations.Chomp());
        knownBuiltins.put("html", new StringTransformations.Html());
        knownBuiltins.put("rtf", new StringTransformations.Rtf());
        knownBuiltins.put("xml", new StringTransformations.Xml());
        knownBuiltins.put("xhtml", new StringTransformations.Xhtml());
        knownBuiltins.put("web_safe", knownBuiltins.get("html"));
        TypeChecks typeChecks = new TypeChecks();
        knownBuiltins.put("is_boolean", typeChecks);
        knownBuiltins.put("is_collection", typeChecks);
        knownBuiltins.put("is_date", typeChecks);
        knownBuiltins.put("is_enumerable", typeChecks);
        knownBuiltins.put("is_hash", typeChecks);
        knownBuiltins.put("is_hash_ex", typeChecks);
        knownBuiltins.put("is_indexable", typeChecks);
        knownBuiltins.put("is_directive", typeChecks);
        knownBuiltins.put("is_method", typeChecks);
        knownBuiltins.put("is_null", typeChecks);
        knownBuiltins.put("is_number", typeChecks);
        knownBuiltins.put("is_macro", typeChecks);
        knownBuiltins.put("is_node", typeChecks);
        knownBuiltins.put("is_sequence", typeChecks);
        knownBuiltins.put("is_string", typeChecks);
        knownBuiltins.put("is_transform", typeChecks);
        knownBuiltins.put("join", new StringFunctions.Join());
        knownBuiltins.put("index_of", new StringFunctions.IndexOf());
        knownBuiltins.put("last_index_of", new StringFunctions.LastIndexOf());
        knownBuiltins.put("contains", new StringFunctions.Contains());
        knownBuiltins.put("number", new numberBI());
        knownBuiltins.put("left_pad", new StringFunctions.LeftPad());
        knownBuiltins.put("right_pad", new StringFunctions.RightPad());
        knownBuiltins.put("replace", new StringFunctions.Replace());
        knownBuiltins.put("split", new StringFunctions.Split());
        knownBuiltins.put("groups", new groupsBI());
        knownBuiltins.put("matches", new StringFunctions.Matches());
        knownBuiltins.put("starts_with", new StringFunctions.StartsWith());
        knownBuiltins.put("ends_with", new StringFunctions.EndsWith());
        knownBuiltins.put("word_list", new StringFunctions.WordList());
        knownBuiltins.put("url", new StringFunctions.Url());
        knownBuiltins.put("parent", new NodeFunctions.Parent());
        knownBuiltins.put("children", new NodeFunctions.Children());
        knownBuiltins.put("node_name", new NodeFunctions.NodeName());
        knownBuiltins.put("node_type", new NodeFunctions.NodeType());
        knownBuiltins.put("node_namespace", new NodeFunctions.NodeNamespace());
        knownBuiltins.put("root", new NodeFunctions.Root());
        knownBuiltins.put("ancestors", new NodeFunctions.Ancestors());
        knownBuiltins.put("first", new SequenceFunctions.First());
        knownBuiltins.put("last", new SequenceFunctions.Last());
        knownBuiltins.put("reverse", new SequenceFunctions.Reverse());
        knownBuiltins.put("sort", new SequenceFunctions.Sort());
        knownBuiltins.put("chunk", new SequenceFunctions.Chunk());
        knownBuiltins.put("seq_contains", new SequenceContainsBuiltIn());
        knownBuiltins.put("scope", new MacroBuiltins.Scope());
        knownBuiltins.put("namespace", new MacroBuiltins.Namespace());
        knownBuiltins.put("keys", new HashBuiltin.Keys());
        knownBuiltins.put("values", new HashBuiltin.Values());
        knownBuiltins.put("date", new DateTime(2));
        knownBuiltins.put("time", new DateTime(1));
        knownBuiltins.put("datetime", new DateTime(3));
        knownBuiltins.put("is_defined", new ExistenceBuiltIn.IsDefinedBuiltIn());
        knownBuiltins.put("default", new ExistenceBuiltIn.DefaultBuiltIn());
        knownBuiltins.put("has_content", new ExistenceBuiltIn.HasContentBuiltIn());
    }

    @Override
    public void close() {
        this.key = this.getKeyTok().toString().intern();
        this.bi = knownBuiltins.get(this.key);
        if (this.bi == null) {
            throw new ParseException("unknown builtin: ?" + this.key + " at " + this.getKeyTok().getLocation());
        }
    }

    public Expression getTarget() {
        return (Expression)this.get(0);
    }

    public Token getKeyTok() {
        return (Token)this.get(2);
    }

    public BuiltIn getBuiltIn() {
        return this.bi;
    }

    @Override
    public Object evaluate(Environment env) {
        return this.bi.get(env, this);
    }

    public String getName() {
        return this.key;
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        BuiltInExpression result = new BuiltInExpression();
        result.add(this.getTarget().deepClone(name, subst));
        result.add(this.get(1));
        result.add(this.getKeyTok());
        result.key = this.key;
        result.bi = this.bi;
        return result;
    }
}

