/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.Environment;
import freemarker.core.nodes.AssignmentInstruction;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.UserDirective;
import freemarker.core.variables.UserDirectiveBody;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class BlockAssignment
extends TemplateNode
implements TemplateElement {
    public Expression getTargetExpression() {
        return (Expression)this.get(1);
    }

    public Expression getNamespaceExp() {
        Node inToken = this.firstChildOfType(Token.TokenType.IN);
        if (inToken != null) {
            return (Expression)inToken.nextSibling();
        }
        return null;
    }

    @Override
    public void execute(Environment env) throws IOException {
        Map scope = null;
        Expression namespaceExp = this.getNamespaceExp();
        if (namespaceExp != null) {
            try {
                scope = (Map)namespaceExp.evaluate(env);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException(this.getLocation() + "\nInvalid reference to namespace: " + namespaceExp, env);
            }
        } else if (this.get(0).getType() == Token.TokenType.ASSIGN) {
            scope = env.getCurrentNamespace();
        } else if (this.get(0).getType() == Token.TokenType.LOCALASSIGN) {
            scope = env.getCurrentMacroContext();
        } else if (this.get(0).getType() == Token.TokenType.GLOBALASSIGN) {
            scope = env;
        }
        CaptureOutput filter = new CaptureOutput();
        if (this.firstChildOfType(Block.class) != null) {
            env.render(this.firstChildOfType(Block.class), filter, null, null);
        }
        String text = filter.capturedText;
        AssignmentInstruction.set(this.getTargetExpression(), text, env, scope);
    }

    @Override
    public String getDescription() {
        return "block assignment to: " + this.getTargetExpression();
    }

    private static class CaptureOutput
    implements UserDirective {
        String capturedText = "";

        private CaptureOutput() {
        }

        @Override
        public void execute(Environment env, Map<String, Object> args, Object[] bodyVars, UserDirectiveBody body) throws IOException {
            body.render(this.getWriter(env.getOut(), args));
        }

        public Writer getWriter(Writer out, Map<String, Object> args) {
            return new StringWriter(){

                @Override
                public void flush() {
                    capturedText = this.toString();
                }
            };
        }
    }
}

