/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.annotations.Parameters;
import freemarker.core.Environment;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.FMParser;
import freemarker.core.variables.VarArgsFunction;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ArgsList
extends TemplateNode {
    private static Map<String, ParameterList> parameterListCache = new ConcurrentHashMap<String, ParameterList>();
    private static final ParameterList NO_PARAM_LIST = new ParameterList();

    public abstract Map<String, Object> getParameterMap(Object var1, Environment var2);

    public abstract List<Object> getParameterSequence(Object var1, Environment var2);

    public static ParameterList getParameterList(Object target) {
        String keyName = target.getClass().getName();
        ParameterList result = parameterListCache.get(keyName);
        if (result == NO_PARAM_LIST) {
            return null;
        }
        if (result != null) {
            return result;
        }
        Parameters params = ArgsList.getAnnotatedParameters(target);
        if (params != null) {
            String paramString = params.value();
            if ("".equals(paramString)) {
                result = new ParameterList();
            } else {
                try {
                    result = ArgsList.getParameterList(paramString);
                }
                catch (Exception pe) {
                    throw new TemplateException("Can't parse parameter list [" + paramString + "] on " + target, pe, Environment.getCurrentEnvironment());
                }
            }
            parameterListCache.put(keyName, result);
            return result;
        }
        parameterListCache.put(keyName, NO_PARAM_LIST);
        return null;
    }

    private static ParameterList getParameterList(String s) {
        FMLexer token_source = new FMLexer(s);
        token_source.switchTo(FMLexer.LexicalState.EXPRESSION);
        FMParser parser = new FMParser(token_source);
        return parser.ParameterList();
    }

    private static Parameters getAnnotatedParameters(Object target) {
        Parameters params = null;
        Method keyMethod = null;
        if (target instanceof TemplateMethodModel) {
            try {
                keyMethod = target.getClass().getMethod("exec", List.class);
            }
            catch (Exception e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (target instanceof VarArgsFunction) {
            try {
                keyMethod = target.getClass().getMethod("apply", new Object[0].getClass());
            }
            catch (Exception e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (keyMethod != null) {
            params = keyMethod.getAnnotation(Parameters.class);
        }
        if (params == null) {
            params = target.getClass().getAnnotation(Parameters.class);
        }
        return params;
    }

    public abstract ArgsList deepClone(String var1, Expression var2);
}

