/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes.generated;

import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.Wrap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AdditiveExpression
extends TemplateNode
implements Expression {
    public Expression getLeft() {
        return (Expression)this.get(0);
    }

    public Expression getRight() {
        return (Expression)this.get(2);
    }

    @Override
    public Object evaluate(Environment env) {
        Object result = ((Expression)this.get(0)).evaluate(env);
        for (int i = 0; i < this.size() / 2; ++i) {
            boolean isMinus;
            boolean bl = isMinus = this.get(i * 2 + 1).getType() == Token.TokenType.MINUS;
            if (isMinus) {
                if (!(result instanceof Number)) {
                    throw new EvaluationException("Expecting number here");
                }
                Number leftSide = (Number)result;
                Expression rhs = (Expression)this.get(i * 2 + 2);
                Object rightSide = rhs.evaluate(env);
                if (!(rightSide instanceof Number)) {
                    throw new EvaluationException("Expecting number at: " + rhs.getLocation());
                }
                ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
                result = ae.subtract(leftSide, (Number)rightSide);
                continue;
            }
            Object right = ((Expression)this.get(i * 2 + 2)).evaluate(env);
            result = this.addOrConcatenate(env, result, right);
        }
        return result;
    }

    private Object addOrConcatenate(Environment env, Object left, Object right) {
        ArithmeticEngine ae;
        ArithmeticEngine arithmeticEngine = ae = env != null ? env.getArithmeticEngine() : this.getTemplate().getArithmeticEngine();
        if (left instanceof Number && right instanceof Number) {
            return ae.add((Number)left, (Number)right);
        }
        if (Wrap.isList(left) && Wrap.isList(right)) {
            List<?> leftList = Wrap.asList(left);
            List<?> rightList = Wrap.asList(right);
            ArrayList result = new ArrayList();
            result.addAll(leftList);
            result.addAll(rightList);
            return result;
        }
        if (Wrap.isMap(left) && Wrap.isMap(right)) {
            Map leftMap = (Map)Wrap.unwrap(left);
            Map rightMap = (Map)Wrap.unwrap(right);
            LinkedHashMap result = new LinkedHashMap(leftMap);
            for (Object key : rightMap.keySet()) {
                result.put(key, rightMap.get(key));
            }
            return result;
        }
        return this.getLeft().getStringValue(env, left) + this.getRight().getStringValue(env, right);
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        AdditiveExpression result = new AdditiveExpression();
        for (Node n : this) {
            if (n instanceof Expression) {
                result.add(((Expression)n).deepClone(name, subst));
                continue;
            }
            result.add(n);
        }
        return result;
    }
}

