/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes;

import freemarker.core.nodes.generated.Interpolation;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.Text;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.Token;

public class Whitespace
extends Text {
    private Boolean ignored;

    public Whitespace(Token.TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        super(type, tokenSource, beginOffset, endOffset);
    }

    public boolean isIgnored() {
        if (this.ignored == null) {
            this.ignored = this.isNonOutputtingLine() || this.getType() == Token.TokenType.TRAILING_WHITESPACE && this.checkForExplicitRightTrim() || this.getType() == Token.TokenType.NON_TRAILING_WHITESPACE && this.getBeginColumn() == 1 && this.checkForExplicitLeftTrim();
        }
        return this.ignored;
    }

    public void setIgnored(boolean b) {
        this.ignored = b;
    }

    private boolean checkForExplicitLeftTrim() {
        for (Token tok = this.nextCachedToken(); tok != null && tok.getBeginLine() == this.getBeginLine(); tok = tok.nextCachedToken()) {
            if (tok.getType() != Token.TokenType.TRIM && tok.getType() != Token.TokenType.LTRIM) continue;
            return true;
        }
        return false;
    }

    private boolean checkForExplicitRightTrim() {
        for (Token tok = this.previousCachedToken(); tok != null && tok.getBeginLine() == this.getBeginLine(); tok = tok.previousCachedToken()) {
            if (tok.getType() != Token.TokenType.TRIM && tok.getType() != Token.TokenType.RTRIM) continue;
            return true;
        }
        return false;
    }

    private boolean isNonOutputtingLine() {
        if (this.spansLine()) {
            return false;
        }
        Token tok = this.previousCachedToken();
        while (tok != null && tok.getEndLine() == this.getBeginLine()) {
            if (tok.firstAncestorOfType(Macro.class) != this.firstAncestorOfType(Macro.class)) {
                tok = tok.previousCachedToken();
                continue;
            }
            if (tok.getType() == Token.TokenType.CLOSE_BRACE && tok.getParent() instanceof Interpolation) {
                return false;
            }
            if (tok.getType() == Token.TokenType.REGULAR_PRINTABLE || tok.getType() == Token.TokenType.PROBLEMATIC_CHAR || tok.getType() == Token.TokenType.NOPARSE) {
                return false;
            }
            tok = tok.previousCachedToken();
        }
        tok = this.nextCachedToken();
        while (tok != null && tok.getBeginLine() == this.getBeginLine()) {
            if (tok.firstAncestorOfType(Macro.class) != this.firstAncestorOfType(Macro.class)) {
                tok = tok.nextCachedToken();
                continue;
            }
            if (tok.getType() == Token.TokenType.OUTPUT_ESCAPE) {
                return false;
            }
            if (tok.getType() == Token.TokenType.REGULAR_PRINTABLE || tok.getType() == Token.TokenType.PROBLEMATIC_CHAR || tok.getType() == Token.TokenType.NOPARSE) {
                return false;
            }
            tok = tok.nextCachedToken();
        }
        return true;
    }

    private boolean spansLine() {
        return this.getBeginColumn() == 1 && this.charAt(this.length() - 1) == '\n';
    }
}

