/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes;

import freemarker.core.Environment;
import freemarker.core.TemplateRunnable;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.NamedArgsList;
import freemarker.core.nodes.generated.PositionalArgsList;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.scope.NamedParameterListScope;
import freemarker.core.variables.scope.NamedParameterMapScope;
import freemarker.core.variables.scope.Scope;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParameterList
extends TemplateNode {
    private List<String> params = new ArrayList<String>();
    private Map<String, Expression> defaults;
    private String catchall;

    public void addParam(String paramName) {
        this.params.add(paramName);
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<String> getParamNames() {
        ArrayList<String> result = new ArrayList<String>(this.params);
        if (this.catchall != null) {
            result.add(this.catchall);
        }
        return result;
    }

    boolean containsParam(String name) {
        return this.params.contains(name);
    }

    public void addParam(String paramName, Expression defaultExp) {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, Expression>();
        }
        this.defaults.put(paramName, defaultExp);
        this.addParam(paramName);
    }

    public void setCatchAll(String varname) {
        this.catchall = varname;
    }

    public String getCatchAll() {
        return this.catchall;
    }

    private boolean hasDefaultExpressions() {
        return this.defaults != null && !this.defaults.isEmpty();
    }

    public Expression getDefaultExpression(String paramName) {
        return this.defaults == null ? null : this.defaults.get(paramName);
    }

    public Expression getDefaultExpression(int paramIndex) {
        if (this.params == null || paramIndex >= this.params.size()) {
            return null;
        }
        return this.getDefaultExpression(this.params.get(paramIndex));
    }

    private void fillInDefaults(final Environment env, final Scope scope, final Collection<String> paramNames) {
        try {
            env.runInScope(scope, new TemplateRunnable<Object>(){

                @Override
                public Object run() throws IOException {
                    ParameterList.this.fillInDefaultsInternal(env, scope, paramNames);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new TemplateException(e, env);
        }
    }

    private void fillInDefaultsInternal(Environment env, Scope scope, Collection<String> paramNames) {
        InvalidReferenceException firstReferenceException;
        Expression firstUnresolvedExpression;
        boolean hasUnresolvedArg;
        boolean resolvedAnArg;
        do {
            firstUnresolvedExpression = null;
            firstReferenceException = null;
            hasUnresolvedArg = false;
            resolvedAnArg = false;
            for (String paramName : paramNames) {
                Object arg = scope.get(paramName);
                if (arg != null) continue;
                Expression defaultExp = this.getDefaultExpression(paramName);
                if (defaultExp != null) {
                    try {
                        Object value = defaultExp.evaluate(env);
                        if (value == null) {
                            if (hasUnresolvedArg) continue;
                            firstUnresolvedExpression = defaultExp;
                            hasUnresolvedArg = true;
                            continue;
                        }
                        scope.put(paramName, value);
                        resolvedAnArg = true;
                    }
                    catch (InvalidReferenceException e) {
                        if (hasUnresolvedArg) continue;
                        hasUnresolvedArg = true;
                        firstReferenceException = e;
                    }
                    continue;
                }
                if (arg != null) continue;
                throw new EvaluationException("Missing required parameter " + paramName);
            }
        } while (resolvedAnArg && hasUnresolvedArg);
        if (hasUnresolvedArg) {
            if (firstReferenceException != null) {
                throw firstReferenceException;
            }
            assert (firstUnresolvedExpression != null);
            firstUnresolvedExpression.assertNonNull(null, scope.getEnvironment());
        }
    }

    public List<Object> getParameterSequence(PositionalArgsList args, Environment env) {
        int i;
        ArrayList<Object> result = new ArrayList<Object>(this.params.size());
        int argsSize = args.size();
        int paramsSize = this.params.size();
        int commonSize = Math.min(argsSize, paramsSize);
        for (i = 0; i < commonSize; ++i) {
            result.add(args.getValueAt(i, env));
        }
        if (commonSize < argsSize) {
            if (this.catchall == null) {
                throw new TemplateException("Extraneous parameters provided; expected " + paramsSize + ", got " + argsSize, env);
            }
            for (i = commonSize; i < argsSize; ++i) {
                result.add(args.getValueAt(i, env));
            }
        } else if (commonSize < paramsSize) {
            NamedParameterListScope scope = new NamedParameterListScope(env.getCurrentScope(), this.params, result, false);
            this.fillInDefaults(env, scope, this.params.subList(args.size(), this.params.size()));
        }
        return result;
    }

    public List<Object> getParameterSequence(NamedArgsList args, Environment env) {
        int paramsSize;
        int argsSize = args.size();
        if (argsSize > (paramsSize = this.params.size())) {
            LinkedHashSet<String> l = new LinkedHashSet<String>(args.getArgs().keySet());
            l.removeAll(this.params);
            throw new TemplateException("Extraneous parameters " + l, env);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedList<String> unresolvedParamNames = null;
        Map<String, Expression> argsMap = args.getCopyOfMap();
        for (String paramName : this.params) {
            Expression argExp = argsMap.remove(paramName);
            if (argExp != null) {
                Object argModel = argExp.evaluate(env);
                argExp.assertIsDefined(argModel, env);
                result.add(argModel);
                continue;
            }
            if (unresolvedParamNames == null) {
                unresolvedParamNames = new LinkedList<String>();
            }
            unresolvedParamNames.add(paramName);
        }
        if (unresolvedParamNames != null) {
            NamedParameterListScope scope = new NamedParameterListScope(env.getCurrentScope(), this.params, result, false);
            this.fillInDefaults(env, scope, unresolvedParamNames);
        }
        return result;
    }

    public Map<String, Object> getParameterMap(PositionalArgsList args, Environment env, boolean ignoreExtraParams) {
        int argsSize = args.childrenOfType(Expression.class).size();
        int paramsSize = this.params.size();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.catchall == null && argsSize > paramsSize && !ignoreExtraParams) {
            throw new TemplateException("Expecting exactly " + paramsSize + " arguments, received " + argsSize + ".", env);
        }
        int min = Math.min(paramsSize, argsSize);
        for (int i = 0; i < min; ++i) {
            result.put(this.params.get(i), args.getValueAt(i, env));
        }
        if (this.hasDefaultExpressions() && argsSize < paramsSize) {
            NamedParameterMapScope scope = new NamedParameterMapScope(env.getCurrentScope(), result);
            this.fillInDefaults(env, scope, this.params.subList(argsSize, paramsSize));
        }
        if (this.catchall != null) {
            ArrayList<Object> catchAllVars = new ArrayList<Object>();
            result.put(this.catchall, catchAllVars);
            for (int i = paramsSize; i < argsSize; ++i) {
                catchAllVars.add(args.getValueAt(i, env));
            }
        }
        return result;
    }

    public Map<String, Object> getParameterMap(NamedArgsList args, Environment env) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedList<String> unresolvedParamNames = null;
        Map<String, Expression> argsMap = args.getCopyOfMap();
        for (String paramName : this.params) {
            Expression argExp = argsMap.remove(paramName);
            if (argExp != null) {
                Object value = argExp.evaluate(env);
                argExp.assertIsDefined(value, env);
                result.put(paramName, value);
                continue;
            }
            if (this.defaults != null && this.defaults.containsKey(paramName)) {
                if (unresolvedParamNames == null) {
                    unresolvedParamNames = new LinkedList<String>();
                }
                unresolvedParamNames.add(paramName);
                continue;
            }
            throw new TemplateException("Missing required parameter " + paramName, env);
        }
        if (unresolvedParamNames != null) {
            NamedParameterMapScope scope = new NamedParameterMapScope(env.getCurrentScope(), result);
            this.fillInDefaults(env, scope, unresolvedParamNames);
        }
        HashMap<String, Object> catchAllMap = null;
        if (this.catchall != null) {
            catchAllMap = new HashMap<String, Object>();
            result.put(this.catchall, catchAllMap);
        }
        if (!argsMap.isEmpty()) {
            if (this.catchall != null) {
                for (Map.Entry<String, Expression> entry : argsMap.entrySet()) {
                    Expression exp = entry.getValue();
                    Object val = exp.evaluate(env);
                    exp.assertIsDefined(val, env);
                    catchAllMap.put(entry.getKey(), val);
                }
            } else {
                throw new TemplateException("Extraneous parameters " + argsMap.keySet() + " provided.", env);
            }
        }
        return result;
    }

    public Map<String, Object> getParameterMap(ArgsList args, Environment env) {
        if (args instanceof NamedArgsList) {
            return this.getParameterMap((NamedArgsList)args, env);
        }
        return this.getParameterMap((PositionalArgsList)args, env, false);
    }
}

