/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes;

import freemarker.core.Environment;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.RangeExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.ReflectionCode;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamicKeyName
extends TemplateNode
implements Expression {
    public Expression getNameExpression() {
        return (Expression)this.get(2);
    }

    public Expression getTarget() {
        return (Expression)this.get(0);
    }

    @Override
    public Object evaluate(Environment env) {
        Object lhs = this.getTarget().evaluate(env);
        this.getTarget().assertNonNull(lhs, env);
        if (this.getNameExpression() instanceof RangeExpression) {
            return this.dealWithRangeKey(lhs, (RangeExpression)this.getNameExpression(), env);
        }
        Object key = this.getNameExpression().evaluate(env);
        if (key == null) {
            this.getNameExpression().assertNonNull(key, env);
        }
        if (key instanceof Number) {
            int index = ((Number)key).intValue();
            return this.dealWithNumericalKey(lhs, index, env);
        }
        if (key instanceof CharSequence) {
            return this.dealWithStringKey(lhs, Wrap.asString(key), env);
        }
        if (Wrap.isMap(lhs)) {
            return ((Map)Wrap.unwrap(lhs)).get(Wrap.unwrap(key));
        }
        throw DynamicKeyName.invalidTypeException(key, this.getNameExpression(), env, "number, range, or string");
    }

    private Object dealWithNumericalKey(Object target, int index, Environment env) {
        if (target instanceof TemplateSequenceModel) {
            TemplateSequenceModel tsm = (TemplateSequenceModel)target;
            int size = Integer.MAX_VALUE;
            try {
                size = tsm.size();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index < size ? tsm.get(index) : Wrap.JAVA_NULL;
        }
        if (Wrap.isList(target)) {
            try {
                return Wrap.wrap(Wrap.asList(target).get(index));
            }
            catch (IndexOutOfBoundsException ae) {
                return Wrap.JAVA_NULL;
            }
        }
        String s = this.getTarget().getStringValue(env);
        try {
            return s.substring(index, index + 1);
        }
        catch (RuntimeException re) {
            throw new TemplateException("", re, env);
        }
    }

    private Object dealWithStringKey(Object lhs, String key, Environment env) {
        if (lhs instanceof Map) {
            Object obj = ((Map)lhs).get(key);
            if (obj == null) {
                return ((Map)lhs).containsKey(key) ? Wrap.JAVA_NULL : null;
            }
            return Wrap.wrap(obj);
        }
        if (lhs instanceof TemplateHashModel) {
            return Wrap.wrap(((TemplateHashModel)lhs).get(key));
        }
        return ReflectionCode.getProperty(lhs, key, this.getTemplate().legacySyntax());
    }

    private Object dealWithRangeKey(Object target, RangeExpression range, Environment env) {
        int start = Wrap.getNumber(range.getLeft(), env).intValue();
        int end = 0;
        boolean hasRhs = range.hasRhs();
        if (hasRhs) {
            end = Wrap.getNumber(range.getRight(), env).intValue();
        }
        if (Wrap.isList(target)) {
            List<?> list = Wrap.asList(target);
            if (!hasRhs) {
                end = list.size() - 1;
            }
            if (start < 0) {
                String msg = range.getRight().getLocation() + "\nNegative starting index for range, is " + range;
                throw new TemplateException(msg, env);
            }
            if (end < 0) {
                String msg = range.getLeft().getLocation() + "\nNegative ending index for range, is " + range;
                throw new TemplateException(msg, env);
            }
            if (start >= list.size()) {
                String msg = range.getLeft().getLocation() + "\nLeft side index of range out of bounds, is " + start + ", but the sequence has only " + list.size() + " element(s) (note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(msg, env);
            }
            if (end >= list.size()) {
                String msg = range.getRight().getLocation() + "\nRight side index of range out of bounds, is " + end + ", but the sequence has only " + list.size() + " element(s).(note that indices are 0 based, and ranges are inclusive).";
                throw new TemplateException(msg, env);
            }
            ArrayList result = new ArrayList();
            if (start > end) {
                for (int i = start; i >= end; --i) {
                    result.add(list.get(i));
                }
            } else {
                for (int i = start; i <= end; ++i) {
                    result.add(list.get(i));
                }
            }
            return result;
        }
        String s = this.getTarget().getStringValue(env);
        if (!hasRhs) {
            end = s.length() - 1;
        }
        if (start < 0) {
            String msg = range.getLeft().getLocation() + "\nNegative starting index for range " + range + " : " + start;
            throw new TemplateException(msg, env);
        }
        if (end < 0) {
            String msg = range.getLeft().getLocation() + "\nNegative ending index for range " + range + " : " + end;
            throw new TemplateException(msg, env);
        }
        if (start > s.length()) {
            String msg = range.getLeft().getLocation() + "\nLeft side of range out of bounds, is: " + start + "\nbut string " + target + " has " + s.length() + " elements.";
            throw new TemplateException(msg, env);
        }
        if (end > s.length()) {
            String msg = range.getRight().getLocation() + "\nRight side of range out of bounds, is: " + end + "\nbut string " + target + " is only " + s.length() + " characters.";
            throw new TemplateException(msg, env);
        }
        try {
            return s.substring(start, end + 1);
        }
        catch (RuntimeException re) {
            String msg = "Error " + this.getLocation();
            throw new TemplateException(msg, re, env);
        }
    }

    @Override
    public boolean isAssignableTo() {
        return true;
    }

    @Override
    public Expression _deepClone(String name, Expression subst) {
        DynamicKeyName result = new DynamicKeyName();
        result.add(this.getTarget().deepClone(name, subst));
        result.add(this.get(1));
        result.add(this.getNameExpression().deepClone(name, subst));
        result.add(this.get(3));
        return result;
    }
}

