/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.nodes;

import freemarker.core.Environment;
import freemarker.core.nodes.DynamicKeyName;
import freemarker.core.nodes.generated.Expression;
import freemarker.core.nodes.generated.ParentheticalExpression;
import freemarker.core.nodes.generated.StringLiteral;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.parser.Node;
import freemarker.core.parser.Token;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.ReflectionCode;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AssignmentInstruction
extends TemplateNode
implements TemplateElement {
    public List<String> getVarNames() {
        ArrayList<String> result = new ArrayList<String>();
        List<Node> equalsToks = this.childrenOfType(Token.TokenType.EQUALS);
        for (Node tok : equalsToks) {
            Node varExp = tok.previousSibling();
            if (varExp instanceof StringLiteral) {
                result.add(((StringLiteral)varExp).getAsString());
                continue;
            }
            if (varExp.getType() != Token.TokenType.ID) continue;
            result.add(varExp.toString());
        }
        return result;
    }

    public List<Expression> getTargetExpressions() {
        return this.childrenOfType(Expression.class, (T exp) -> exp.nextSibling().getType() == Token.TokenType.EQUALS);
    }

    public Expression getNamespaceExp() {
        Node inToken = this.firstChildOfType(Token.TokenType.IN);
        if (inToken != null) {
            return (Expression)inToken.nextSibling();
        }
        return null;
    }

    @Override
    public void execute(Environment env) throws IOException {
        Map scope = null;
        Expression namespaceExp = this.getNamespaceExp();
        if (namespaceExp != null) {
            try {
                scope = (Map)namespaceExp.evaluate(env);
            }
            catch (ClassCastException cce) {
                throw new InvalidReferenceException(this.getLocation() + "\nInvalid reference to namespace: " + namespaceExp, env);
            }
        } else if (this.get(0).getType() == Token.TokenType.ASSIGN) {
            scope = env.getCurrentNamespace();
        } else if (this.get(0).getType() == Token.TokenType.LOCALASSIGN) {
            scope = env.getCurrentMacroContext();
        } else if (this.get(0).getType() == Token.TokenType.GLOBALASSIGN) {
            scope = env;
        }
        for (Expression exp : this.childrenOfType(Expression.class)) {
            if (exp.nextSibling().getType() != Token.TokenType.EQUALS) continue;
            Expression valueExp = (Expression)exp.nextSibling().nextSibling();
            Object value = valueExp.evaluate(env);
            AssignmentInstruction.set(exp, value, env, scope);
        }
    }

    public static void set(Expression lhs, Object value, Environment env, Map scope) {
        Object key;
        while (lhs instanceof ParentheticalExpression) {
            lhs = ((ParentheticalExpression)lhs).getNested();
        }
        if (lhs instanceof Token) {
            String varName = lhs.toString();
            if (lhs instanceof StringLiteral) {
                varName = ((StringLiteral)lhs).getAsString();
            }
            if (scope != null) {
                scope.put(varName, value);
            } else {
                env.unqualifiedSet(varName, value);
            }
            return;
        }
        Expression targetExp = (Expression)lhs.get(0);
        Expression keyExp = (Expression)lhs.get(2);
        Object target = targetExp.evaluate(env);
        Object object = key = lhs instanceof DynamicKeyName ? keyExp.evaluate(env) : keyExp.toString();
        if (key instanceof Number && (target instanceof List || target.getClass().isArray())) {
            int index = ((Number)key).intValue();
            if (target instanceof List) {
                ((List)target).set(index, value);
            } else {
                try {
                    Array.set(target, index, value);
                }
                catch (Exception e) {
                    throw new EvaluationException(e);
                }
            }
            return;
        }
        if (target instanceof Map) {
            ((Map)target).put(key, value);
            return;
        }
        if (key instanceof String && ReflectionCode.setProperty(target, (String)key, value)) {
            return;
        }
        throw new EvaluationException("Could not set " + lhs);
    }

    @Override
    public String getDescription() {
        return "assignment instruction";
    }
}

