/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.AssertionFailedException;
import freemarker.core.BreakException;
import freemarker.core.Configurable;
import freemarker.core.ReturnException;
import freemarker.core.TemplateRunnable;
import freemarker.core.nodes.ParameterList;
import freemarker.core.nodes.generated.ArgsList;
import freemarker.core.nodes.generated.Block;
import freemarker.core.nodes.generated.IncludeInstruction;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.nodes.generated.NestedInstruction;
import freemarker.core.nodes.generated.PositionalArgsList;
import freemarker.core.nodes.generated.TemplateElement;
import freemarker.core.nodes.generated.UnifiedCall;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.UserDirective;
import freemarker.core.variables.UserDirectiveBody;
import freemarker.core.variables.Wrap;
import freemarker.core.variables.WrappedNode;
import freemarker.core.variables.scope.BlockScope;
import freemarker.core.variables.scope.MacroContext;
import freemarker.core.variables.scope.NamedParameterListScope;
import freemarker.core.variables.scope.Scope;
import freemarker.core.variables.scope.UndeclaredVariableException;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class Environment
extends Configurable
implements Scope {
    private static final ThreadLocal<Environment> threadEnv = new ThreadLocal();
    static final Logger logger = Logger.getLogger("freemarker.runtime");
    private static final Logger attemptLogger = Logger.getLogger("freemarker.runtime.attempt");
    private static final Map<NumberFormatKey, NumberFormat> localizedNumberFormats = new HashMap<NumberFormatKey, NumberFormat>();
    private static final Map<DateFormatKey, DateFormat> localizedDateFormats = new HashMap<DateFormatKey, DateFormat>();
    private static final DecimalFormat C_NUMBER_FORMAT = new DecimalFormat("0.################", new DecimalFormatSymbols(Locale.US));
    private final Map<String, Object> rootDataModel;
    private final List<TemplateElement> elementStack = new ArrayList<TemplateElement>();
    private final List<String> recoveredErrorStack = new ArrayList<String>();
    private NumberFormat numberFormat;
    private Map<String, NumberFormat> numberFormats;
    private DateFormat timeFormat;
    private DateFormat dateFormat;
    private DateFormat dateTimeFormat;
    private Map<String, DateFormat>[] dateFormats;
    private NumberFormat cNumberFormat;
    private Collator collator;
    private Writer out;
    private MacroContext currentMacroContext;
    private Scope mainNamespace;
    private Scope currentScope;
    private Map<Macro, MacroContext> macroContextLookup = new HashMap<Macro, MacroContext>();
    private Map<Macro, Scope> macroToNamespaceLookup = new HashMap<Macro, Scope>();
    private HashMap<String, Object> globalVariables = new HashMap();
    private HashMap<String, Scope> loadedLibs;
    private Throwable lastThrowable;
    private Object lastReturnValue;
    private WrappedNode currentVisitorNode;
    private List<Scope> nodeNamespaces;
    private int nodeNamespaceIndex;
    private String currentNodeName;
    private String currentNodeNS;
    private String cachedURLEscapingCharset;
    private boolean urlEscapingCharsetCached;
    private static final Object[] NO_OUT_ARGS;
    public static final Writer NULL_WRITER;

    public static Environment getCurrentEnvironment() {
        return threadEnv.get();
    }

    public Environment(Template template, Map<String, Object> rootDataModel, Writer out) {
        super(template);
        this.currentScope = this.mainNamespace = new BlockScope(template.getRootElement(), this);
        this.out = out;
        this.rootDataModel = rootDataModel;
        this.importMacros(template);
    }

    public void setCurrentScope(Scope scope) {
        this.currentScope = scope;
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    @Override
    public Template getTemplate() {
        return (Template)this.getFallback();
    }

    public void process() throws IOException {
        Environment savedEnv = threadEnv.get();
        threadEnv.set(this);
        try {
            this.doAutoImportsAndIncludes(this);
            Template template = this.getTemplate();
            this.render(template.getRootElement());
            this.out.flush();
        }
        finally {
            threadEnv.set(savedEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(TemplateElement element) throws IOException {
        this.pushElement(element);
        Block nestedBlock = element.getNestedBlock();
        boolean createNewScope = nestedBlock != null && !nestedBlock.isTemplateRoot() && !(nestedBlock.getParent() instanceof Macro) && nestedBlock.createsScope();
        Scope prevScope = this.currentScope;
        if (createNewScope) {
            this.currentScope = new BlockScope(nestedBlock, this.currentScope);
        }
        try {
            element.execute(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popElement();
            this.currentScope = prevScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Block block, UserDirective directive, Map<String, Object> args, List<String> bodyParameterNames) throws IOException {
        UserDirectiveBody nested = null;
        if (block != null) {
            nested = newOut -> {
                Writer prevOut = this.out;
                this.out = newOut;
                try {
                    this.render(block);
                }
                finally {
                    this.out.flush();
                    this.out = prevOut;
                }
            };
        }
        Object[] outArgs = bodyParameterNames != null && !bodyParameterNames.isEmpty() ? new Object[bodyParameterNames.size()] : NO_OUT_ARGS;
        Scope scope = this.currentScope;
        if (block != null && block.createsScope()) {
            this.currentScope = new NamedParameterListScope(scope, bodyParameterNames, Arrays.asList(outArgs), true);
        }
        try {
            directive.execute(this, args, outArgs, nested);
        }
        finally {
            this.currentScope = scope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Block attemptBlock, Block recoveryBlock) throws IOException {
        Writer prevOut = this.out;
        StringWriter sw = new StringWriter();
        this.out = sw;
        TemplateException thrownException = null;
        try {
            this.render(attemptBlock);
        }
        catch (TemplateException te) {
            thrownException = te;
        }
        finally {
            this.out = prevOut;
        }
        if (thrownException != null) {
            if (attemptLogger.isDebugEnabled()) {
                logger.debug("Error in attempt block " + attemptBlock.getLocation(), thrownException);
            }
            try {
                this.recoveredErrorStack.add(thrownException.getMessage());
                this.render(recoveryBlock);
            }
            finally {
                this.recoveredErrorStack.remove(this.recoveredErrorStack.size() - 1);
            }
        } else {
            this.out.write(sw.toString());
        }
    }

    public String getCurrentRecoveredErrorMessage() {
        if (this.recoveredErrorStack.isEmpty()) {
            throw new TemplateException(".error is not available outside of a <#recover> block", this);
        }
        return this.recoveredErrorStack.get(this.recoveredErrorStack.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(NestedInstruction nestedInstruction) throws IOException {
        MacroContext invokingMacroContext;
        Block body;
        BlockScope blockScope = new BlockScope(this.currentMacroContext.getBody(), this.currentMacroContext.getInvokingScope());
        ParameterList bodyParameters = this.currentMacroContext.getBodyParameters();
        PositionalArgsList bodyArgs = nestedInstruction.getArgs();
        if (bodyParameters != null) {
            Map<String, Object> bodyParamsMap = bodyParameters.getParameterMap(bodyArgs, this, true);
            for (Map.Entry<String, Object> entry : bodyParamsMap.entrySet()) {
                blockScope.put(entry.getKey(), entry.getValue());
            }
        }
        if ((body = (invokingMacroContext = this.currentMacroContext).getBody()) != null) {
            this.currentMacroContext = invokingMacroContext.getInvokingMacroContext();
            Configurable prevParent = this.getFallback();
            Scope prevScope = this.currentScope;
            this.setFallback(this.getCurrentNamespace().getTemplate());
            this.currentScope = blockScope;
            try {
                this.render(body);
            }
            finally {
                this.currentScope = prevScope;
                this.currentMacroContext = invokingMacroContext;
                this.setFallback(prevParent);
                this.currentScope = prevScope;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Iterator<?> it, Block block, String loopVarName) throws IOException {
        Scope prevScope = this.currentScope;
        int index = 0;
        String hasNextName = loopVarName + "_has_next";
        String indexName = loopVarName + "_index";
        try {
            while (it.hasNext()) {
                this.currentScope = new BlockScope(block, prevScope);
                this.currentScope.put(loopVarName, Wrap.wrap(it.next()));
                this.currentScope.put(hasNextName, it.hasNext());
                this.currentScope.put(indexName, index++);
                this.render(block);
            }
        }
        catch (BreakException breakException) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.currentScope = prevScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Object mapOrHash, Block block, String keyName, String valueName) throws IOException {
        Iterator<Object> it = null;
        TemplateHashModel hash = null;
        Map map = null;
        if (mapOrHash instanceof Map) {
            map = (Map)mapOrHash;
            it = map.keySet().iterator();
        } else {
            hash = (TemplateHashModel)mapOrHash;
            it = hash.keys().iterator();
        }
        Scope prevScope = this.currentScope;
        int index = 0;
        String keyHasNext = keyName + "_has_next";
        String valueHasNext = valueName + "_has_next";
        String keyIndexName = keyName + "_index";
        String valueIndexName = valueName + "_index";
        try {
            while (it.hasNext()) {
                this.currentScope = new BlockScope(block, prevScope);
                Object key = it.next();
                Object value = map != null ? map.get(key) : hash.get(key.toString());
                boolean hasNext = it.hasNext();
                this.currentScope.put(keyName, Wrap.wrap(key));
                this.currentScope.put(valueName, Wrap.wrap(value));
                this.currentScope.put(keyHasNext, hasNext);
                this.currentScope.put(valueHasNext, hasNext);
                this.currentScope.put(keyIndexName, index);
                this.currentScope.put(valueIndexName, index++);
                this.render(block);
            }
        }
        catch (BreakException key) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.currentScope = prevScope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(WrappedNode node, List<Scope> namespaces) throws IOException {
        block14: {
            if (this.nodeNamespaces == null) {
                ArrayList<Scope> ss = new ArrayList<Scope>();
                ss.add(this.getCurrentNamespace());
                this.nodeNamespaces = ss;
            }
            int prevNodeNamespaceIndex = this.nodeNamespaceIndex;
            String prevNodeName = this.currentNodeName;
            String prevNodeNS = this.currentNodeNS;
            List<Scope> prevNodeNamespaces = this.nodeNamespaces;
            WrappedNode prevVisitorNode = this.currentVisitorNode;
            this.currentVisitorNode = node;
            if (namespaces != null) {
                this.nodeNamespaces = namespaces;
            }
            try {
                Macro macro = this.getNodeProcessor(node);
                if (macro != null) {
                    this.render(macro, (ArgsList)null, null, null);
                    break block14;
                }
                String nodeType = node.getNodeType();
                if (nodeType != null) {
                    if (nodeType.equals("text")) {
                        this.out.write(nodeType.toString());
                    } else if (nodeType.equals("document")) {
                        this.process(node, namespaces);
                    } else if (!(nodeType.equals("pi") || nodeType.equals("comment") || nodeType.equals("document_type"))) {
                        String nsBit = "";
                        String ns = node.getNodeNamespace();
                        if (ns != null) {
                            nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                        }
                        throw new TemplateException("No handler defined for node named " + node.getNodeName() + nsBit + ", and there is no fallback handler called @" + nodeType + " either.", this);
                    }
                    break block14;
                }
                String nsBit = "";
                String ns = node.getNodeNamespace();
                if (ns != null) {
                    nsBit = ns.length() > 0 ? " and namespace " + ns : " and no namespace";
                }
                throw new TemplateException("No handler defined for node with name " + node.getNodeName() + nsBit + ", and there is no macro or transform called @default either.", this);
            }
            finally {
                this.currentVisitorNode = prevVisitorNode;
                this.nodeNamespaceIndex = prevNodeNamespaceIndex;
                this.currentNodeName = prevNodeName;
                this.currentNodeNS = prevNodeNS;
                this.nodeNamespaces = prevNodeNamespaces;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInScope(Scope scope, TemplateRunnable<T> runnable) throws IOException {
        Scope currentScope = this.currentScope;
        this.currentScope = scope;
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            this.currentScope = currentScope;
        }
    }

    public void fallback() throws IOException {
        Macro macroOrTransform = this.getNodeProcessor(this.currentNodeName, this.currentNodeNS, this.nodeNamespaceIndex);
        if (macroOrTransform instanceof Macro) {
            this.render(macroOrTransform, (ArgsList)null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void render(Macro macro, ArgsList args, ParameterList bodyParameters, Block nestedBlock) throws IOException {
        block17: {
            if (macro == Macro.DO_NOTHING_MACRO) {
                return;
            }
            this.pushElement(macro);
            try {
                MacroContext mc = new MacroContext(macro, this, nestedBlock, bodyParameters);
                MacroContext prevMc = this.macroContextLookup.get(macro);
                this.macroContextLookup.put(macro, mc);
                if (args != null) {
                    Map<String, Object> argsMap = macro.getParams().getParameterMap(args, this);
                    for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
                        mc.put(entry.getKey(), entry.getValue());
                    }
                }
                Scope prevScope = this.currentScope;
                Configurable prevParent = this.getFallback();
                this.currentMacroContext = mc;
                this.currentScope = this.currentMacroContext;
                try {
                    this.render(macro.getNestedBlock());
                }
                catch (ReturnException entry) {
                    if (prevMc != null) {
                        this.macroContextLookup.put(macro, prevMc);
                    } else {
                        this.macroContextLookup.remove(macro);
                    }
                    this.currentMacroContext = mc.getInvokingMacroContext();
                    this.currentScope = prevScope;
                    this.setFallback(prevParent);
                }
                catch (TemplateException te) {
                    this.handleTemplateException(te);
                    break block17;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (prevMc != null) {
                        this.macroContextLookup.put(macro, prevMc);
                    } else {
                        this.macroContextLookup.remove(macro);
                    }
                    this.currentMacroContext = mc.getInvokingMacroContext();
                    this.currentScope = prevScope;
                    this.setFallback(prevParent);
                }
            }
            finally {
                this.popElement();
            }
        }
    }

    public void visitMacroDef(Macro macro) {
        if (this.currentMacroContext == null) {
            this.macroToNamespaceLookup.put(macro, this.getCurrentNamespace());
            this.unqualifiedSet(macro.getName(), macro);
        }
    }

    public Scope getMacroNamespace(Macro macro) {
        Scope result = this.macroToNamespaceLookup.get(macro);
        if (result == null) {
            result = this.mainNamespace;
        }
        return result;
    }

    public MacroContext getMacroContext(Macro macro) {
        return this.macroContextLookup.get(macro);
    }

    public void process(WrappedNode node, List<Scope> namespaces) throws IOException {
        if (node == null && (node = this.getCurrentVisitorNode()) == null) {
            throw new EvaluationException("The target node of recursion is missing or null.");
        }
        List<WrappedNode> children = node.getChildNodes();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            WrappedNode child = children.get(i);
            if (child == null) continue;
            this.render(child, namespaces);
        }
    }

    public MacroContext getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    private void handleTemplateException(TemplateException te) {
        if (this.lastThrowable == te) {
            throw te;
        }
        this.lastThrowable = te;
        if (logger.isErrorEnabled()) {
            logger.error(te.getMessage(), te);
        }
        if (te instanceof AssertionFailedException) {
            throw te;
        }
        this.getTemplateExceptionHandler().handleTemplateException(te, this, this.out);
    }

    @Override
    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.lastThrowable = null;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.numberFormats = null;
        this.numberFormat = null;
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
        this.collator = null;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        super.setTimeZone(timeZone);
        this.dateFormats = null;
        this.dateTimeFormat = null;
        this.dateFormat = null;
        this.timeFormat = null;
    }

    @Override
    public void setURLEscapingCharset(String urlEscapingCharset) {
        this.urlEscapingCharsetCached = false;
        super.setURLEscapingCharset(urlEscapingCharset);
    }

    @Override
    public void setOutputEncoding(String outputEncoding) {
        this.urlEscapingCharsetCached = false;
        super.setOutputEncoding(outputEncoding);
    }

    public String getEffectiveURLEscapingCharset() {
        if (!this.urlEscapingCharsetCached) {
            this.cachedURLEscapingCharset = this.getURLEscapingCharset();
            if (this.cachedURLEscapingCharset == null) {
                this.cachedURLEscapingCharset = this.getOutputEncoding();
            }
            this.urlEscapingCharsetCached = true;
        }
        return this.cachedURLEscapingCharset;
    }

    public Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
        }
        return this.collator;
    }

    public void setOut(Writer out) {
        this.out = out;
    }

    public Writer getOut() {
        return this.out;
    }

    public String formatNumber(Number number) {
        if (this.numberFormat == null) {
            this.numberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.numberFormat.format(number);
    }

    @Override
    public void setNumberFormat(String formatName) {
        super.setNumberFormat(formatName);
        this.numberFormat = null;
    }

    public String formatDate(Date date, int type) {
        DateFormat df = this.getDateFormatObject(type);
        if (df == null) {
            throw new EvaluationException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
        }
        return df.format(date);
    }

    @Override
    public void setTimeFormat(String formatName) {
        super.setTimeFormat(formatName);
        this.timeFormat = null;
    }

    @Override
    public void setDateFormat(String formatName) {
        super.setDateFormat(formatName);
        this.dateFormat = null;
    }

    @Override
    public void setDateTimeFormat(String formatName) {
        super.setDateTimeFormat(formatName);
        this.dateTimeFormat = null;
    }

    public Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    public Object getLastReturnValue() {
        return this.lastReturnValue;
    }

    public void setLastReturnValue(Object lastReturnValue) {
        this.lastReturnValue = lastReturnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberFormat getNumberFormatObject(String pattern) {
        NumberFormat format;
        if (this.numberFormats == null) {
            this.numberFormats = new HashMap<String, NumberFormat>();
        }
        if ((format = this.numberFormats.get(pattern)) != null) {
            return format;
        }
        Map<NumberFormatKey, NumberFormat> map = localizedNumberFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey fk = new NumberFormatKey(pattern, locale);
            format = localizedNumberFormats.get(fk);
            if (format == null) {
                format = "number".equals(pattern) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(pattern) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(pattern) ? NumberFormat.getPercentInstance(locale) : ("computer".equals(pattern) ? this.getCNumberFormat() : new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale())))));
                localizedNumberFormats.put(fk, format);
            }
        }
        format = (NumberFormat)format.clone();
        this.numberFormats.put(pattern, format);
        return format;
    }

    public DateFormat getDateFormatObject(int dateType) {
        switch (dateType) {
            case 0: {
                return null;
            }
            case 1: {
                if (this.timeFormat == null) {
                    this.timeFormat = this.getDateFormatObject(dateType, this.getTimeFormat());
                }
                return this.timeFormat;
            }
            case 2: {
                if (this.dateFormat == null) {
                    this.dateFormat = this.getDateFormatObject(dateType, this.getDateFormat());
                }
                return this.dateFormat;
            }
            case 3: {
                if (this.dateTimeFormat == null) {
                    this.dateTimeFormat = this.getDateFormatObject(dateType, this.getDateTimeFormat());
                }
                return this.dateTimeFormat;
            }
        }
        throw new EvaluationException("Unrecognized date type " + dateType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormat getDateFormatObject(int dateType, String pattern) {
        Map<String, DateFormat> typedDateFormat;
        DateFormat format;
        if (this.dateFormats == null) {
            this.dateFormats = new Map[4];
            this.dateFormats[0] = new HashMap<String, DateFormat>();
            this.dateFormats[1] = new HashMap<String, DateFormat>();
            this.dateFormats[2] = new HashMap<String, DateFormat>();
            this.dateFormats[3] = new HashMap<String, DateFormat>();
        }
        if ((format = (typedDateFormat = this.dateFormats[dateType]).get(pattern)) != null) {
            return format;
        }
        Map<DateFormatKey, DateFormat> map = localizedDateFormats;
        synchronized (map) {
            Locale locale = this.getLocale();
            TimeZone timeZone = this.getTimeZone();
            DateFormatKey fk = new DateFormatKey(dateType, pattern, locale, timeZone);
            format = localizedDateFormats.get(fk);
            if (format == null) {
                int style;
                StringTokenizer tok = new StringTokenizer(pattern, "_");
                int n = style = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : 2;
                if (style != -1) {
                    switch (dateType) {
                        case 0: {
                            throw new EvaluationException("Can't convert the date to string using a built-in format, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(<format>) built-in with explicit formatting pattern with this date.");
                        }
                        case 1: {
                            format = DateFormat.getTimeInstance(style, locale);
                            break;
                        }
                        case 2: {
                            format = DateFormat.getDateInstance(style, locale);
                            break;
                        }
                        case 3: {
                            int timestyle;
                            int n2 = timestyle = tok.hasMoreTokens() ? this.parseDateStyleToken(tok.nextToken()) : style;
                            if (timestyle == -1) break;
                            format = DateFormat.getDateTimeInstance(style, timestyle, locale);
                            break;
                        }
                    }
                }
                if (format == null) {
                    try {
                        format = new SimpleDateFormat(pattern, locale);
                    }
                    catch (IllegalArgumentException e) {
                        throw new EvaluationException("Can't parse " + pattern + " to a date format.", e);
                    }
                }
                format.setTimeZone(timeZone);
                localizedDateFormats.put(fk, format);
            }
        }
        format = (DateFormat)format.clone();
        typedDateFormat.put(pattern, format);
        return format;
    }

    int parseDateStyleToken(String token) {
        if ("short".equals(token)) {
            return 3;
        }
        if ("medium".equals(token)) {
            return 2;
        }
        if ("long".equals(token)) {
            return 1;
        }
        if ("full".equals(token)) {
            return 0;
        }
        return -1;
    }

    public NumberFormat getCNumberFormat() {
        if (this.cNumberFormat == null) {
            this.cNumberFormat = Environment.getNewCNumberFormat();
        }
        return this.cNumberFormat;
    }

    public static NumberFormat getNewCNumberFormat() {
        return (NumberFormat)C_NUMBER_FORMAT.clone();
    }

    public Object getVariable(String name) {
        return this.currentScope.resolveVariable(name);
    }

    @Override
    public Object get(Object name) {
        Object result = this.globalVariables.get(name);
        if (result == null) {
            result = this.rootDataModel.get(name);
        }
        if (result == null) {
            result = this.getConfiguration().getSharedVariable(name.toString());
        }
        return result;
    }

    public void setGlobalVariable(String name, Object value) {
        this.globalVariables.put(name, value);
    }

    private void setVariable(String name, Object value) {
        this.getCurrentNamespace().put(name, value);
    }

    public void unqualifiedSet(String name, Object value) {
        Scope scope = this.currentScope;
        while (!scope.isTemplateNamespace()) {
            if (scope.get(name) != null) {
                scope.put(name, value);
                return;
            }
            scope = scope.getEnclosingScope();
        }
        try {
            scope.put(name, value);
        }
        catch (UndeclaredVariableException uve) {
            if (this.globalVariables.containsKey(name)) {
                this.globalVariables.put(name, value);
            }
            throw uve;
        }
    }

    public void outputInstructionStack(PrintWriter pw) {
        TemplateElement prev;
        pw.println("----------");
        ListIterator<TemplateElement> iter = this.elementStack.listIterator(this.elementStack.size());
        if (iter.hasPrevious()) {
            pw.print("==> ");
            prev = iter.previous();
            pw.print(prev.getDescription());
            pw.print(" [");
            pw.print(prev.getLocation());
            pw.println("]");
        }
        while (iter.hasPrevious()) {
            String location;
            prev = iter.previous();
            if (!(prev instanceof UnifiedCall) && !(prev instanceof IncludeInstruction) || (location = prev.getDescription() + " [" + prev.getLocation() + "]") == null || location.length() <= 0) continue;
            pw.print(" in ");
            pw.println(location);
        }
        pw.println("----------");
        pw.flush();
    }

    @Override
    public Environment getEnvironment() {
        return this;
    }

    @Override
    public Scope getEnclosingScope() {
        return null;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.globalVariables.containsKey(name) || this.rootDataModel.get(name) != null;
    }

    @Override
    public Object put(String varname, Object value) {
        return this.globalVariables.put(varname, value);
    }

    @Override
    public Object remove(Object varname) {
        return this.globalVariables.remove(varname);
    }

    public Scope getMainNamespace() {
        return this.mainNamespace;
    }

    public Scope getCurrentNamespace() {
        Scope scope = this.currentScope;
        while (scope.getEnclosingScope() != this) {
            scope = scope.getEnclosingScope();
        }
        return scope;
    }

    public TemplateHashModel getDataModel() {
        TemplateHashModel result = new TemplateHashModel(){

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Object get(String key) {
                Object value = Environment.this.rootDataModel.get(key);
                if (value == null) {
                    value = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return value;
            }
        };
        return result;
    }

    public List<TemplateElement> getElementStack() {
        return Collections.unmodifiableList(this.elementStack);
    }

    private void pushElement(TemplateElement element) {
        this.elementStack.add(element);
    }

    private void popElement() {
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public WrappedNode getCurrentVisitorNode() {
        return this.currentVisitorNode;
    }

    public void setCurrentVisitorNode(WrappedNode node) {
        this.currentVisitorNode = node;
    }

    Macro getNodeProcessor(WrappedNode node) {
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            throw new TemplateException("Node name is null.", this);
        }
        Macro result = this.getNodeProcessor(nodeName, node.getNodeNamespace(), 0);
        if (result == null) {
            String type = node.getNodeType();
            if (type != null) {
                result = this.getNodeProcessor("@" + type, null, 0);
            }
            if (result == null) {
                result = this.getNodeProcessor("@default", null, 0);
            }
        }
        return result;
    }

    private Macro getNodeProcessor(String nodeName, String nsURI, int startIndex) {
        Scope ns;
        int i;
        Macro result = null;
        for (i = startIndex; i < this.nodeNamespaces.size() && (result = this.getNodeProcessor(ns = this.nodeNamespaces.get(i), nodeName, nsURI)) == null; ++i) {
        }
        if (result != null) {
            this.nodeNamespaceIndex = i + 1;
            this.currentNodeName = nodeName;
            this.currentNodeNS = nsURI;
        }
        return result;
    }

    private Macro getNodeProcessor(Scope ns, String localName, String nsURI) {
        Object value = null;
        if (nsURI == null) {
            value = ns.get(localName);
            return value instanceof Macro ? (Macro)value : null;
        }
        Template template = ns.getTemplate();
        String prefix = template.getPrefixForNamespace(nsURI);
        if (prefix == null) {
            return null;
        }
        if (prefix.length() > 0) {
            value = ns.get(prefix + ":" + localName);
        } else if (nsURI.length() == 0) {
            value = ns.get("N:" + localName);
        } else if (nsURI.equals(template.getDefaultNS())) {
            value = ns.get("D:" + localName);
        } else if (value == null) {
            value = ns.get(localName);
        }
        return value instanceof Macro ? (Macro)value : null;
    }

    public void include(String name, String encoding, boolean parse) throws IOException {
        this.include(this.getTemplateForInclusion(name, encoding, parse), false);
    }

    public Template getTemplateForInclusion(String name, String encoding, boolean parse) throws IOException {
        if (encoding == null) {
            encoding = this.getTemplate().getEncoding();
        }
        if (encoding == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        return this.getConfiguration().getTemplate(name, this.getLocale(), encoding, parse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template includedTemplate, boolean freshNamespace) throws IOException {
        Template prevTemplate = this.getTemplate();
        this.setFallback(includedTemplate);
        Scope prevScope = this.currentScope;
        if (freshNamespace) {
            this.currentScope = new BlockScope(includedTemplate.getRootElement(), this);
            this.importMacros(includedTemplate);
        } else {
            this.currentScope = this.getCurrentNamespace();
            this.importMacros(includedTemplate);
        }
        try {
            this.render(includedTemplate.getRootElement());
        }
        finally {
            this.currentScope = prevScope;
            this.setFallback(prevTemplate);
        }
    }

    public Scope importLib(String name, String namespace) throws IOException {
        return this.importLib(this.getTemplateForImporting(name), namespace, true);
    }

    public Template getTemplateForImporting(String name) throws IOException {
        return this.getTemplateForInclusion(name, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scope importLib(Template loadedTemplate, String namespace, boolean global) throws IOException {
        String templateName;
        Scope existingNamespace;
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((existingNamespace = this.loadedLibs.get(templateName = loadedTemplate.getName())) != null) {
            if (namespace != null) {
                this.setVariable(namespace, existingNamespace);
            }
        } else {
            BlockScope newNamespace = new BlockScope(loadedTemplate.getRootElement(), this);
            if (namespace != null) {
                if (global) {
                    this.setGlobalVariable(namespace, newNamespace);
                } else {
                    this.setVariable(namespace, newNamespace);
                }
                if (this.getCurrentNamespace() == this.mainNamespace) {
                    this.put(namespace, (Object)newNamespace);
                }
            }
            this.loadedLibs.put(templateName, newNamespace);
            Scope prevScope = this.currentScope;
            this.currentScope = newNamespace;
            Writer prevOut = this.out;
            Configurable prevParent = this.getFallback();
            this.out = NULL_WRITER;
            this.setFallback(loadedTemplate);
            try {
                this.render(loadedTemplate.getRootElement());
            }
            finally {
                this.out = prevOut;
                this.currentScope = prevScope;
                this.setFallback(prevParent);
            }
        }
        return this.loadedLibs.get(templateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderElementToString(TemplateElement te) throws IOException {
        Writer prevOut = this.out;
        try {
            StringWriter sw = new StringWriter();
            this.out = sw;
            this.render(te);
            String string = sw.toString();
            return string;
        }
        finally {
            this.out = prevOut;
        }
    }

    private void importMacros(Template template) {
        for (Macro macro : template.getMacros().values()) {
            this.visitMacroDef(macro);
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.getCurrentNamespace().getTemplate().getNamespaceForPrefix(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        return this.getCurrentNamespace().getTemplate().getPrefixForNamespace(nsURI);
    }

    public String getDefaultNS() {
        return this.getCurrentNamespace().getTemplate().getDefaultNS();
    }

    static {
        C_NUMBER_FORMAT.setGroupingUsed(false);
        C_NUMBER_FORMAT.setDecimalSeparatorAlwaysShown(false);
        NO_OUT_ARGS = new Object[0];
        NULL_WRITER = new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberFormatKey) {
                NumberFormatKey fk = (NumberFormatKey)o;
                return fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }

    private static final class DateFormatKey {
        private final int dateType;
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;

        DateFormatKey(int dateType, String pattern, Locale locale, TimeZone timeZone) {
            this.dateType = dateType;
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
        }

        public boolean equals(Object o) {
            if (o instanceof DateFormatKey) {
                DateFormatKey fk = (DateFormatKey)o;
                return this.dateType == fk.dateType && fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale) && fk.timeZone.equals(this.timeZone);
            }
            return false;
        }

        public int hashCode() {
            return this.dateType ^ this.pattern.hashCode() ^ this.locale.hashCode() ^ this.timeZone.hashCode();
        }
    }
}

