/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.annotations.Parameters;
import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.function.BiFunction;
import java.util.function.Function;

public class stringBI
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        if (model instanceof Number) {
            return new NumberFormatter((Number)model, env);
        }
        if (model instanceof TemplateDateModel) {
            TemplateDateModel dm = (TemplateDateModel)model;
            int dateType = dm.getDateType();
            return new DateFormatter(Wrap.getDate(dm, caller.getTarget(), env), dateType, env);
        }
        if (Wrap.isBoolean(model)) {
            return new BooleanFormatter(model, env);
        }
        return model.toString();
    }

    static class NumberFormatter
    implements TemplateHashModel,
    Function<String, Object> {
        private final Number number;
        private final Environment env;
        private final NumberFormat defaultFormat;
        private String cachedValue;

        NumberFormatter(Number number, Environment env) {
            this.number = number;
            this.env = env;
            this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
        }

        public String toString() {
            if (this.cachedValue == null) {
                this.cachedValue = this.defaultFormat.format(this.number);
            }
            return this.cachedValue;
        }

        @Override
        public Object get(String key) {
            return this.env.getNumberFormatObject(key).format(this.number);
        }

        @Override
        @Parameters(value="format")
        public Object apply(String arg) {
            return this.get(arg);
        }
    }

    static class DateFormatter
    implements TemplateHashModel,
    Function<String, Object> {
        private final Date date;
        private final int dateType;
        private final Environment env;
        private final DateFormat defaultFormat;

        DateFormatter(Date date, int dateType, Environment env) {
            this.date = date;
            this.dateType = dateType;
            this.env = env;
            this.defaultFormat = env.getDateFormatObject(dateType);
        }

        public String toString() {
            if (this.dateType == 0) {
                throw new EvaluationException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
            }
            return this.defaultFormat.format(this.date);
        }

        @Override
        public Object get(String key) {
            return this.env.getDateFormatObject(this.dateType, key).format(this.date);
        }

        @Override
        public Object apply(String arg) {
            return this.get(arg);
        }
    }

    static class BooleanFormatter
    implements BiFunction<Object, Object, String> {
        private final Object bool;
        private final Environment env;

        BooleanFormatter(Object bool, Environment env) {
            this.bool = bool;
            this.env = env;
        }

        public String toString() {
            if (this.bool instanceof CharSequence) {
                return Wrap.asString(this.bool);
            }
            return this.env.getBooleanFormat(Wrap.asBoolean(this.bool));
        }

        @Override
        public String apply(Object left, Object right) {
            return Wrap.asString(Wrap.asBoolean(this.bool) ? left : right);
        }
    }
}

