/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateException;

public class numberBI
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object value) {
        String string;
        if (value instanceof Number) {
            return value;
        }
        try {
            string = Wrap.asString(value);
        }
        catch (ClassCastException ex) {
            throw TemplateNode.invalidTypeException(value, caller.getTarget(), env, "string or number");
        }
        ArithmeticEngine e = env == null ? caller.getTemplate().getArithmeticEngine() : env.getArithmeticEngine();
        try {
            return e.toNumber(string);
        }
        catch (NumberFormatException nfe) {
            String mess = "Error: " + caller.getLocation() + "\nExpecting a number in string here, found: " + string;
            throw new TemplateException(mess, env);
        }
    }
}

