/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.UserDirective;
import freemarker.core.variables.UserDirectiveBody;
import freemarker.core.variables.Wrap;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;

public class interpretBI
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        String id = null;
        String interpretString = null;
        if (Wrap.isList(model)) {
            Object tm;
            List<?> tsm = Wrap.asList(model);
            Object v0 = tm = tsm.size() > 1 ? tsm.get(1) : null;
            if (tm != null) {
                if (tm instanceof CharSequence) {
                    id = Wrap.asString(tm);
                } else {
                    throw new EvaluationException("Expecting string as second item of sequence of left of ?interpret built-in");
                }
            }
            if (!((tm = tsm.get(0)) instanceof CharSequence)) {
                throw new EvaluationException("Expecting string as first item of sequence of left of ?interpret built-in");
            }
            interpretString = Wrap.asString(tm);
        } else if (model instanceof CharSequence) {
            interpretString = Wrap.asString(model);
        }
        if (id == null) {
            id = "anonymous_interpreted";
        }
        if (interpretString == null) {
            throw new InvalidReferenceException("No string to interpret", env);
        }
        Template parentTemplate = env.getTemplate();
        try {
            Template template = new Template(parentTemplate.getName() + "$" + id, new StringReader(interpretString), parentTemplate.getConfiguration());
            template.setLocale(env.getLocale());
            return new TemplateProcessorModel(template);
        }
        catch (IOException e) {
            throw new TemplateException("", e, env);
        }
    }

    private static class TemplateProcessorModel
    implements UserDirective {
        private final Template template;

        TemplateProcessorModel(Template template) {
            this.template = template;
        }

        @Override
        public void execute(Environment env, Map<String, Object> params, Object[] loopVars, UserDirectiveBody body) throws IOException {
            try {
                env.include(this.template, false);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EvaluationException(e);
            }
        }
    }
}

