/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.Macro;
import freemarker.core.variables.UserDirective;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import freemarker.core.variables.WrappedNode;
import freemarker.template.TemplateHashModel;

public class TypeChecks
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object value) {
        boolean result = false;
        String builtInName = caller.getName();
        if (builtInName == "is_string") {
            result = value instanceof CharSequence;
        } else if (builtInName == "is_number") {
            result = value instanceof Number;
        } else if (builtInName == "is_date") {
            result = Wrap.isDate(value);
        } else if (builtInName == "is_enumerable" || builtInName == "is_collection") {
            result = Wrap.isIterable(value);
        } else if (builtInName == "is_sequence" || builtInName == "is_indexable") {
            result = Wrap.isList(value);
        } else if (builtInName == "is_macro") {
            result = value instanceof Macro && !((Macro)value).isFunction();
        } else if (builtInName == "is_directive") {
            result = value instanceof Macro || value instanceof UserDirective;
        } else if (builtInName == "is_boolean") {
            result = Wrap.isBoolean(value);
        } else if (builtInName == "is_hash") {
            result = value instanceof TemplateHashModel;
        } else if (builtInName == "is_hash_ex") {
            result = value instanceof TemplateHashModel;
        } else if (builtInName == "is_method") {
            result = value instanceof VarArgsFunction;
        } else if (builtInName == "is_node") {
            result = value instanceof WrappedNode;
        } else if (builtInName == "is_null") {
            result = value == Wrap.JAVA_NULL;
        } else if (builtInName == "is_transform") {
            result = false;
        }
        return result;
    }
}

