/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.variables.InvalidReferenceException;
import freemarker.core.variables.Wrap;
import freemarker.template.utility.StringUtil;

public abstract class StringTransformations
extends ExpressionEvaluatingBuiltIn {
    @Override
    public Object get(Environment env, BuiltInExpression caller, Object lhs) {
        String string = null;
        string = lhs instanceof CharSequence ? Wrap.asString(lhs) : caller.getTarget().getStringValue(env);
        if (string == null) {
            throw new InvalidReferenceException("String is undefined", env);
        }
        return this.apply(string);
    }

    public abstract String apply(String var1);

    public static class Chomp
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.chomp(string);
        }
    }

    public static class Capitalize
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.capitalize(string);
        }
    }

    public static class JavaScript
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.javaScriptStringEnc(string);
        }
    }

    public static class Java
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.javaStringEnc(string);
        }
    }

    public static class CapFirst
    extends StringTransformations {
        private final boolean cap;

        public CapFirst(boolean cap) {
            this.cap = cap;
        }

        @Override
        public String apply(String string) {
            for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                if (this.cap && Character.isUpperCase(ch) || !this.cap && Character.isLowerCase(ch)) {
                    return string;
                }
                char[] chars = string.toCharArray();
                chars[i] = this.cap ? Character.toUpperCase(ch) : Character.toLowerCase(ch);
                return new String(chars);
            }
            return string;
        }
    }

    public static class Rtf
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.RTFEnc(string);
        }
    }

    public static class Xml
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.XMLEnc(string);
        }
    }

    public static class Xhtml
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.XHTMLEnc(string);
        }
    }

    public static class Html
    extends StringTransformations {
        @Override
        public String apply(String string) {
            return StringUtil.HTMLEnc(string);
        }
    }
}

