/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.JavaMethodCall;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class StringFunctions
extends ExpressionEvaluatingBuiltIn {
    private static HashMap<String, Pattern> patternLookup = new HashMap();
    private static LinkedList<String> patterns = new LinkedList();
    private static final int PATTERN_CACHE_SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Pattern getPattern(String patternString, String flagString) {
        int flags = 0;
        String patternKey = patternString + '\u0000' + flagString;
        Pattern result = patternLookup.get(patternKey);
        if (result != null) {
            return result;
        }
        if (flagString == null || flagString.length() == 0) {
            try {
                result = Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                throw new EvaluationException(e);
            }
        }
        if (flagString.indexOf(105) >= 0) {
            flags |= 2;
        }
        if (flagString.indexOf(109) >= 0) {
            flags |= 8;
        }
        if (flagString.indexOf(99) >= 0) {
            flags |= 4;
        }
        if (flagString.indexOf(115) >= 0) {
            flags |= 0x20;
        }
        try {
            result = Pattern.compile(patternString, flags);
        }
        catch (PatternSyntaxException e) {
            throw new EvaluationException(e);
        }
        LinkedList<String> linkedList = patterns;
        synchronized (linkedList) {
            patterns.add(patternKey);
            patternLookup.put(patternKey, result);
            if (patterns.size() > 100) {
                String first = patterns.removeFirst();
                patterns.remove(first);
            }
        }
        return result;
    }

    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        String string = Wrap.asString(model);
        return this.apply(string, env, caller);
    }

    public abstract Object apply(String var1, Environment var2, BuiltInExpression var3);

    static class IndexOfMethod
    implements VarArgsFunction<Integer> {
        private final String s;
        private final boolean reverse;

        IndexOfMethod(String s, boolean reverse) {
            this.s = s;
            this.reverse = reverse;
        }

        private String getName() {
            return "?" + (this.reverse ? "last_" : "") + "index_of";
        }

        @Override
        public Integer apply(Object ... args) {
            int fidx;
            int ln = args.length;
            if (ln == 0) {
                throw new EvaluationException(this.getName() + "(...) expects at least one argument.");
            }
            if (ln > 2) {
                throw new EvaluationException(this.getName() + "(...) expects at most two arguments.");
            }
            Object obj = args[0];
            if (!(obj instanceof CharSequence)) {
                throw new EvaluationException(this.getName() + "(...) expects a string as its first argument.");
            }
            String sub = Wrap.asString(obj);
            if (ln > 1) {
                obj = args[1];
                if (!(obj instanceof Number)) {
                    throw new EvaluationException(this.getName() + "(...) expects a number as its second argument.");
                }
                fidx = ((Number)obj).intValue();
            } else {
                fidx = 0;
            }
            int index = this.reverse ? (ln > 1 ? this.s.lastIndexOf(sub, fidx) : this.s.lastIndexOf(sub)) : this.s.indexOf(sub, fidx);
            return index;
        }
    }

    static class urlBIResult
    implements Function<String, String> {
        private final String target;
        private final Environment env;
        private String cachedResult;

        private urlBIResult(String target, Environment env) {
            this.target = target;
            this.env = env;
        }

        public String toString() {
            if (this.cachedResult == null) {
                String cs = this.env.getEffectiveURLEscapingCharset();
                if (cs == null) {
                    throw new EvaluationException("To do URL encoding, the framework that encloses FreeMarker must specify the output encoding or the URL encoding charset, so ask the programmers to fix it. Or, as a last chance, you can set the url_encoding_charset setting in the template, e.g. <#setting url_escaping_charset='ISO-8859-1'>, or give the charset explicitly to the buit-in, e.g. foo?url('ISO-8859-1').");
                }
                try {
                    this.cachedResult = StringUtil.URLEnc(this.target, cs);
                }
                catch (UnsupportedEncodingException e) {
                    throw new EvaluationException("Failed to execute URL encoding.", e);
                }
            }
            return this.cachedResult;
        }

        @Override
        public String apply(String arg) {
            try {
                return StringUtil.URLEnc(this.target, arg);
            }
            catch (UnsupportedEncodingException e) {
                throw new EvaluationException("Failed to execute URL encoding.", e);
            }
        }
    }

    static class RightPadMethod
    implements VarArgsFunction<String> {
        private String string;

        private RightPadMethod(String string) {
            this.string = string;
        }

        @Override
        public String apply(Object ... args) {
            int ln = args.length;
            if (ln == 0) {
                throw new EvaluationException("?right_pad(...) expects at least 1 argument.");
            }
            if (ln > 2) {
                throw new EvaluationException("?right_pad(...) expects at most 2 arguments.");
            }
            Object obj = args[0];
            if (!(obj instanceof Number)) {
                throw new EvaluationException("?right_pad(...) expects a number as its 1st argument.");
            }
            int width = ((Number)obj).intValue();
            if (ln > 1) {
                obj = args[1];
                if (!(obj instanceof CharSequence)) {
                    throw new EvaluationException("?right_pad(...) expects a string as its 2nd argument.");
                }
                String filling = Wrap.asString(obj);
                try {
                    return StringUtil.rightPad(this.string, width, filling);
                }
                catch (IllegalArgumentException e) {
                    if (filling.length() == 0) {
                        throw new EvaluationException("The 2nd argument of ?right_pad(...) can't be a 0 length string.");
                    }
                    throw new EvaluationException("Error while executing the ?right_pad(...) built-in.", e);
                }
            }
            return StringUtil.rightPad(this.string, width);
        }
    }

    static class LeftPadMethod
    implements VarArgsFunction<String> {
        private String string;

        LeftPadMethod(String s) {
            this.string = s;
        }

        @Override
        public String apply(Object ... args) {
            int ln = args.length;
            if (ln == 0) {
                throw new EvaluationException("?left_pad(...) expects at least 1 argument.");
            }
            if (ln > 2) {
                throw new EvaluationException("?left_pad(...) expects at most 2 arguments.");
            }
            Object obj = args[0];
            if (!(obj instanceof Number)) {
                throw new EvaluationException("?left_pad(...) expects a number as its 1st argument.");
            }
            int width = ((Number)obj).intValue();
            if (ln > 1) {
                obj = args[1];
                if (!(obj instanceof CharSequence)) {
                    throw new EvaluationException("?left_pad(...) expects a string as its 2nd argument.");
                }
                String filling = Wrap.asString(obj);
                try {
                    return StringUtil.leftPad(this.string, width, filling);
                }
                catch (IllegalArgumentException e) {
                    if (filling.length() == 0) {
                        throw new EvaluationException("The 2nd argument of ?left_pad(...) can't be a 0 length string.");
                    }
                    throw new EvaluationException("Error while executing the ?left_pad(...) built-in.", e);
                }
            }
            return StringUtil.leftPad(this.string, width);
        }
    }

    static class RegexMatchModel
    implements TemplateBooleanModel,
    TemplateSequenceModel {
        Matcher matcher;
        String input;
        final boolean matches;
        TemplateSequenceModel groups;
        private ArrayList<Object> data;

        RegexMatchModel(Matcher matcher, String input) {
            this.matcher = matcher;
            this.input = input;
            this.matches = matcher.matches();
        }

        @Override
        public boolean getAsBoolean() {
            return this.matches;
        }

        @Override
        public Object get(int i) {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.get(i);
        }

        @Override
        public int size() {
            if (this.data == null) {
                this.initSequence();
            }
            return this.data.size();
        }

        private void initSequence() {
            this.data = new ArrayList();
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                this.data.add(it.next());
            }
        }

        public Object getGroups() {
            if (this.groups == null) {
                this.groups = new TemplateSequenceModel(){

                    @Override
                    public int size() {
                        try {
                            return matcher.groupCount() + 1;
                        }
                        catch (Exception e) {
                            throw new EvaluationException(e);
                        }
                    }

                    @Override
                    public Object get(int i) {
                        try {
                            return matcher.group(i);
                        }
                        catch (Exception e) {
                            throw new EvaluationException(e);
                        }
                    }
                };
            }
            return this.groups;
        }

        @Override
        public Iterator<Object> iterator() {
            this.matcher.reset();
            return new Iterator<Object>(){
                boolean hasFindInfo;
                {
                    this.hasFindInfo = matcher.find();
                }

                @Override
                public boolean hasNext() {
                    return this.hasFindInfo;
                }

                @Override
                public Object next() {
                    if (!this.hasNext()) {
                        throw new EvaluationException("No more matches");
                    }
                    Match result = new Match();
                    this.hasFindInfo = matcher.find();
                    return result;
                }
            };
        }

        class Match {
            String match;
            List<String> subs = new ArrayList<String>();

            Match() {
                this.match = RegexMatchModel.this.input.substring(RegexMatchModel.this.matcher.start(), RegexMatchModel.this.matcher.end());
                for (int i = 0; i < RegexMatchModel.this.matcher.groupCount() + 1; ++i) {
                    this.subs.add(RegexMatchModel.this.matcher.group(i));
                }
            }

            public String toString() {
                return this.match;
            }
        }
    }

    static class MatcherBuilder
    implements VarArgsFunction<Object> {
        String matchString;

        MatcherBuilder(String matchString) {
            this.matchString = matchString;
        }

        @Override
        public Object apply(Object ... args) {
            int numArgs = args.length;
            if (numArgs == 0) {
                throw new EvaluationException("Expecting at least one argument");
            }
            if (numArgs > 2) {
                throw new EvaluationException("Expecting at most two argumnets");
            }
            String patternString = (String)args[0];
            String flagString = numArgs > 1 ? (String)args[1] : "";
            Pattern pattern = StringFunctions.getPattern(patternString, flagString);
            Matcher matcher = pattern.matcher(this.matchString);
            return new RegexMatchModel(matcher, this.matchString);
        }
    }

    static class ReplaceMethod
    implements VarArgsFunction<String> {
        String string;

        ReplaceMethod(String string) {
            this.string = string;
        }

        @Override
        public String apply(Object ... args) {
            if (args.length < 2 || args.length > 3) {
                throw new EvaluationException("?replace(...) needs 2 or 3 arguments.");
            }
            String first = (String)args[0];
            String second = (String)args[1];
            String flags = args.length == 3 ? (String)args[2] : "";
            boolean caseInsensitive = flags.indexOf(105) >= 0;
            boolean useRegexp = flags.indexOf(114) >= 0;
            boolean firstOnly = flags.indexOf(102) >= 0;
            String result = null;
            if (!useRegexp) {
                result = StringUtil.replace(this.string, first, second, caseInsensitive, firstOnly);
            } else {
                Pattern pattern = StringFunctions.getPattern(first, flags);
                Matcher matcher = pattern.matcher(this.string);
                result = firstOnly ? matcher.replaceFirst(second) : matcher.replaceAll(second);
            }
            return result;
        }
    }

    public static class Url
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new urlBIResult(string, env);
        }
    }

    public static class WordList
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            StringTokenizer st = new StringTokenizer(string);
            ArrayList<String> result = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                result.add(st.nextToken());
            }
            return result;
        }
    }

    public static class RightPad
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new RightPadMethod(string);
        }
    }

    public static class LeftPad
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new LeftPadMethod(string);
        }
    }

    public static class Contains
    extends StringFunctions {
        @Override
        public Function<String, Boolean> apply(String string, Environment env, BuiltInExpression caller) {
            return s -> string.indexOf((String)s) >= 0;
        }
    }

    public static class LastIndexOf
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new IndexOfMethod(string, true);
        }
    }

    public static class IndexOf
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new IndexOfMethod(string, false);
        }
    }

    public static class Matches
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new MatcherBuilder(string);
        }
    }

    public static class EndsWith
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new JavaMethodCall(string, "endsWith");
        }
    }

    public static class StartsWith
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new JavaMethodCall(string, "startsWith");
        }
    }

    public static class Split
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new JavaMethodCall(string, "split");
        }
    }

    public static class Join
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new JavaMethodCall(string, "join");
        }
    }

    public static class Replace
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new ReplaceMethod(string);
        }
    }

    public static class Substring
    extends StringFunctions {
        @Override
        public Object apply(String string, Environment env, BuiltInExpression caller) {
            return new JavaMethodCall(string, "substring");
        }
    }
}

