/*
 * Decompiled with CFR 0.152.
 */
package freemarker.builtins;

import freemarker.builtins.DefaultComparator;
import freemarker.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.ArithmeticEngine;
import freemarker.core.Environment;
import freemarker.core.nodes.generated.BuiltInExpression;
import freemarker.core.nodes.generated.TemplateNode;
import freemarker.core.variables.EvaluationException;
import freemarker.core.variables.VarArgsFunction;
import freemarker.core.variables.Wrap;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public abstract class SequenceFunctions
extends ExpressionEvaluatingBuiltIn {
    static final int KEY_TYPE_STRING = 1;
    static final int KEY_TYPE_NUMBER = 2;
    static final int KEY_TYPE_DATE = 3;

    @Override
    public Object get(Environment env, BuiltInExpression caller, Object model) {
        if (!Wrap.isList(model)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "sequence");
        }
        return this.apply(model);
    }

    public abstract Object apply(Object var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object sort(List seq, String[] keys) {
        void var8_28;
        void var6_5;
        int i;
        int keyCnt;
        int ln = seq.size();
        if (ln == 0) {
            return seq;
        }
        ArrayList<Object> result = new ArrayList<Object>(ln);
        Object e = seq.get(0);
        if (keys != null) {
            keyCnt = keys.length;
            if (keyCnt == 0) {
                keys = null;
            } else {
                for (i = 0; i < keyCnt; ++i) {
                    if (!(var6_5 instanceof TemplateHashModel)) {
                        throw new EvaluationException("sorting failed: " + (i == 0 ? "You can't use ?sort_by when the sequence items are not hashes." : "The subvariable " + StringUtil.jQuote(keys[i - 1]) + " is not a hash, so ?sort_by can't proceed by getting the " + StringUtil.jQuote(keys[i]) + " subvariable."));
                    }
                    Object object = ((TemplateHashModel)var6_5).get(keys[i]);
                    if (object != null) continue;
                    throw new EvaluationException("sorting failed: The " + StringUtil.jQuote(keys[i]) + " subvariable " + (keyCnt == 1 ? "was not found." : "(specified by ?sort_by argument number " + (i + 1) + ") was not found."));
                }
            }
        } else {
            keyCnt = 0;
        }
        int keyType = var6_5 instanceof Number ? 2 : (Wrap.isDate(var6_5) ? 3 : 1);
        if (keys == null) {
            if (keyType == 1) {
                for (i = 0; i < ln; ++i) {
                    Object e2 = seq.get(i);
                    try {
                        result.add(new KVP(Wrap.asString(e2), e2));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        throw new EvaluationException("Failure of ?sort built-in: All values in the sequence must be strings, because the first value was a string. The value at index " + i + " is not string.");
                    }
                }
            } else if (keyType == 2) {
                for (i = 0; i < ln; ++i) {
                    Object e3 = seq.get(i);
                    try {
                        result.add(new KVP((Number)e3, e3));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        throw new EvaluationException("sorting failed: All values in the sequence must be numbers, because the first value was a number. The value at index " + i + " is not number.");
                    }
                }
            } else {
                if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                for (i = 0; i < ln; ++i) {
                    Object e4 = seq.get(i);
                    try {
                        result.add(new KVP(((TemplateDateModel)e4).getAsDate(), e4));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        if (e4 instanceof Number) throw classCastException;
                        throw new EvaluationException("sorting failed: All values in the sequence must be date/time values, because the first value was a date/time. The value at index " + i + " is not date/time.");
                    }
                }
            }
        } else {
            for (i = 0; i < ln; ++i) {
                void var8_22;
                Object e5;
                Object e6 = e5 = seq.get(i);
                for (int j = 0; j < keyCnt; ++j) {
                    Object object;
                    try {
                        object = ((TemplateHashModel)var8_22).get(keys[j]);
                    }
                    catch (ClassCastException e7) {
                        if (var8_22 instanceof TemplateHashModel) throw e7;
                        throw new EvaluationException("sorting failed: Problem with the sequence item at index " + i + ": Can't get the " + StringUtil.jQuote(keys[j]) + " subvariable, because the value is not a hash.");
                    }
                    if (object != null) continue;
                    throw new EvaluationException("sorting failed Problem with the sequence item at index " + i + ": The " + StringUtil.jQuote(keys[j]) + " subvariable was not found.");
                }
                if (keyType == 1) {
                    try {
                        result.add(new KVP(Wrap.asString(var8_22), e5));
                        continue;
                    }
                    catch (ClassCastException e8) {
                        throw new EvaluationException("sorting failed: All key values in the sequence must be date/time values, because the first key value was a date/time. The key value at index " + i + " is not a date/time.");
                    }
                }
                if (keyType == 2) {
                    try {
                        result.add(new KVP((Number)var8_22, e5));
                        continue;
                    }
                    catch (ClassCastException e9) {
                        throw new EvaluationException("sorting failed: All key values in the sequence must be numbers, because the first key value was a number. The key value at index " + i + " is not a number.");
                    }
                }
                if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
                try {
                    result.add(new KVP(((TemplateDateModel)var8_22).getAsDate(), e5));
                    continue;
                }
                catch (ClassCastException e10) {
                    if (var8_22 instanceof TemplateDateModel) continue;
                    throw new EvaluationException("sorting failed: All key values in the sequence must be dates, because the first key value was a date. The key value at index " + i + " is not a date.");
                }
            }
        }
        if (keyType == 1) {
            LexicalKVPComparator lexicalKVPComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
        } else if (keyType == 2) {
            NumericalKVPComparator numericalKVPComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
        } else {
            if (keyType != 3) throw new RuntimeException("FreeMarker bug: Bad key type");
            DateKVPComparator dateKVPComparator = DateKVPComparator.INSTANCE;
        }
        Collections.sort(result, var8_28);
        for (i = 0; i < ln; ++i) {
            result.set(i, ((KVP)result.get(i)).value);
        }
        return result;
    }

    static class KVP {
        private Object key;
        private Object value;

        private KVP(Object key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    static class LexicalKVPComparator
    implements Comparator {
        private Collator collator;

        LexicalKVPComparator(Collator collator) {
            this.collator = collator;
        }

        public int compare(Object arg0, Object arg1) {
            return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
        }
    }

    static class NumericalKVPComparator
    implements Comparator {
        private ArithmeticEngine ae;

        private NumericalKVPComparator(ArithmeticEngine ae) {
            this.ae = ae;
        }

        public int compare(Object arg0, Object arg1) {
            return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
        }
    }

    static class DateKVPComparator
    implements Comparator {
        static final DateKVPComparator INSTANCE = new DateKVPComparator();

        DateKVPComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return ((Date)((KVP)arg0).key).compareTo((Date)((KVP)arg1).key);
        }
    }

    static class SequenceIndexOf
    implements VarArgsFunction<Integer> {
        private final List sequence;
        private final boolean reverse;

        SequenceIndexOf(List sequence, boolean reverse) {
            this.sequence = sequence;
            this.reverse = reverse;
        }

        @Override
        public Integer apply(Object ... args) {
            int startIndex;
            int argc = args.length;
            if (argc != 1 && argc != 2) {
                throw new EvaluationException("Expecting one or two arguments for ?seq_" + (this.reverse ? "last_" : "") + "index_of");
            }
            Object compareToThis = args[0];
            if (argc == 2) {
                try {
                    startIndex = ((Number)args[1]).intValue();
                }
                catch (ClassCastException cce) {
                    throw new EvaluationException("Expecting number as second argument to ?seq_" + (this.reverse ? "last_" : "") + "index_of");
                }
            } else {
                int n = startIndex = this.reverse ? this.sequence.size() - 1 : 0;
            }
            if (startIndex >= this.sequence.size()) {
                startIndex = this.sequence.size() - 1;
            }
            if (startIndex < 0) {
                startIndex = 0;
            }
            Environment env = Environment.getCurrentEnvironment();
            DefaultComparator comparator = new DefaultComparator(env);
            if (this.reverse) {
                for (int i = startIndex; i > -1; --i) {
                    if (!comparator.areEqual(this.sequence.get(i), compareToThis)) continue;
                    return i;
                }
            } else {
                int s = this.sequence.size();
                for (int i = startIndex; i < s; ++i) {
                    if (!comparator.areEqual(this.sequence.get(i), compareToThis)) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    static class SortByMethod
    implements VarArgsFunction {
        List seq;

        SortByMethod(List seq) {
            this.seq = seq;
        }

        public Object apply(Object ... params) {
            String[] subvars;
            if (params.length == 0) {
                throw new EvaluationException("?sort_by(key) needs exactly 1 argument.");
            }
            Object obj = params[0];
            if (obj instanceof CharSequence) {
                subvars = new String[]{Wrap.asString(obj)};
            } else if (obj instanceof TemplateSequenceModel) {
                TemplateSequenceModel seq = (TemplateSequenceModel)obj;
                int ln = seq.size();
                subvars = new String[ln];
                for (int i = 0; i < ln; ++i) {
                    Object item = seq.get(i);
                    try {
                        subvars[i] = Wrap.asString(item);
                        continue;
                    }
                    catch (ClassCastException e) {
                        if (item instanceof CharSequence) continue;
                        throw new EvaluationException("The argument to ?sort_by(key), when it is a sequence, must be a sequence of strings, but the item at index " + i + " is not a string.");
                    }
                }
            } else {
                throw new EvaluationException("The argument to ?sort_by(key) must be a string (the name of the subvariable), or a sequence of strings (the \"path\" to the subvariable).");
            }
            return SequenceFunctions.sort(this.seq, subvars);
        }
    }

    static class ChunkedSequence
    implements TemplateSequenceModel {
        private final List wrappedTsm;
        private final int chunkSize;
        private final Object fillerItem;
        private final int numberOfChunks;

        private ChunkedSequence(List wrappedTsm, int chunkSize, Object fillerItem) {
            if (chunkSize < 1) {
                throw new EvaluationException("The 1st argument to ?chunk(...) must be at least 1.");
            }
            this.wrappedTsm = wrappedTsm;
            this.chunkSize = chunkSize;
            this.fillerItem = fillerItem;
            this.numberOfChunks = (wrappedTsm.size() + chunkSize - 1) / chunkSize;
        }

        @Override
        public Object get(final int chunkIndex) {
            if (chunkIndex >= this.numberOfChunks) {
                return null;
            }
            return new TemplateSequenceModel(){
                private final int baseIndex;
                {
                    this.baseIndex = chunkIndex * chunkSize;
                }

                @Override
                public Object get(int relIndex) {
                    int absIndex = this.baseIndex + relIndex;
                    if (absIndex < wrappedTsm.size()) {
                        return wrappedTsm.get(absIndex);
                    }
                    return absIndex < numberOfChunks * chunkSize ? fillerItem : null;
                }

                @Override
                public int size() {
                    return fillerItem != null || chunkIndex + 1 < numberOfChunks ? chunkSize : wrappedTsm.size() - this.baseIndex;
                }
            };
        }

        @Override
        public int size() {
            return this.numberOfChunks;
        }
    }

    static class ChunkFunction
    implements VarArgsFunction {
        private final List tsm;

        private ChunkFunction(List tsm) {
            this.tsm = tsm;
        }

        public Object apply(Object ... args) {
            int numArgs = args.length;
            if (numArgs != 1 && numArgs != 2) {
                throw new EvaluationException("?chunk(...) expects 1 or 2 arguments.");
            }
            Object chunkSize = args[0];
            if (!(chunkSize instanceof Number)) {
                throw new EvaluationException("?chunk(...) expects a number as its 1st argument.");
            }
            return new ChunkedSequence(this.tsm, ((Number)chunkSize).intValue(), numArgs > 1 ? args[1] : null);
        }
    }

    public static class LastIndexOf
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            List<?> list = Wrap.asList(sequence);
            return new SequenceIndexOf(list, true);
        }
    }

    public static class IndexOf
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            return new SequenceIndexOf(Wrap.asList(sequence), false);
        }
    }

    public static class Chunk
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            return new ChunkFunction(Wrap.asList(sequence));
        }
    }

    public static class SortBy
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            return new SortByMethod(Wrap.asList(sequence));
        }
    }

    public static class Sort
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            List<?> list = Wrap.asList(sequence);
            return Sort.sort(Wrap.asList(sequence), null);
        }
    }

    public static class Reverse
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            List<?> list = Wrap.asList(sequence);
            list = new ArrayList(list);
            Collections.reverse(list);
            return list;
        }
    }

    public static class Last
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            List<?> list = Wrap.asList(sequence);
            return list.size() > 0 ? list.get(list.size() - 1) : null;
        }
    }

    public static class First
    extends SequenceFunctions {
        @Override
        public Object apply(Object sequence) {
            List<?> list = Wrap.asList(sequence);
            return list.size() > 0 ? list.get(0) : null;
        }
    }
}

